/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class XY {
    private final int J = 1;
    private double[][] spinAngle;
    private int L;
    private double T;
    private double H;
    private double dtheta;
    public int time_counter;
    public double E;
    public double Mx;
    public double My;
    public double ave_Mx;
    public double ave_My;
    public double ave_E;

    public XY() {
    }

    public XY(int n, double d, double d2, double d3) {
        this.reinitialize(n, d, d2, d3);
    }

    public boolean reinitialize(int n, double d, double d2, double d3) {
        this.L = n;
        if (d < 0.0) {
            System.out.println("\nTemperature is negative, automatically negated!");
            d *= -1.0;
        }
        this.T = d;
        this.H = d2;
        this.dtheta = d3;
        this.time_counter = 1;
        this.ave_E = 0.0;
        this.ave_My = 0.0;
        this.ave_Mx = 0.0;
        this.spinAngle = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                this.spinAngle[n2][n3] = Math.random() * 2.0 * Math.PI;
                ++n3;
            }
            ++n2;
        }
        this.getME();
        return true;
    }

    public void resetT(double d) {
        if (d < 0.0) {
            System.out.println("\nTemperature is negative, automatically negated!");
            d *= -1.0;
        }
        this.T = d;
    }

    public void resetH(double d) {
        this.H = d;
    }

    public void resetDtheta(double d) {
        if (d < 0.0) {
            d *= -1.0;
        }
        this.dtheta = d < Math.PI ? d : d - (double)((int)(d / Math.PI)) * Math.PI;
    }

    private int pbc(int n) {
        if (n >= this.L) {
            return n - this.L;
        }
        if (n < 0) {
            return n + this.L;
        }
        return n;
    }

    private void getME() {
        this.My = 0.0;
        this.Mx = 0.0;
        this.E = 0.0;
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.Mx += Math.cos(this.spinAngle[n][n2]);
                this.My += Math.sin(this.spinAngle[n][n2]);
                this.E += Math.cos(this.spinAngle[n][n2] - this.spinAngle[n][this.pbc(n2 + 1)]);
                this.E += Math.cos(this.spinAngle[n][n2] - this.spinAngle[this.pbc(n + 1)][n2]);
                ++n2;
            }
            ++n;
        }
        this.E = -1.0 * this.E - this.H * this.My;
    }

    private boolean rotate() {
        int n = (int)(Math.random() * (double)this.L);
        int n2 = (int)(Math.random() * (double)this.L);
        double d = this.spinAngle[n][n2];
        double d2 = -Math.cos(d);
        double d3 = -Math.sin(d);
        double d4 = -Math.cos(this.spinAngle[this.pbc(n - 1)][n2] - d) - Math.cos(this.spinAngle[this.pbc(n + 1)][n2] - d) - Math.cos(this.spinAngle[n][this.pbc(n2 - 1)] - d) - Math.cos(this.spinAngle[n][this.pbc(n2 + 1)] - d);
        double d5 = (2.0 * Math.random() - 1.0) * this.dtheta;
        d2 += Math.cos(d + d5);
        d4 += Math.cos(this.spinAngle[this.pbc(n - 1)][n2] - d - d5) + Math.cos(this.spinAngle[this.pbc(n + 1)][n2] - d - d5) + Math.cos(this.spinAngle[n][this.pbc(n2 - 1)] - d - d5) + Math.cos(this.spinAngle[n][this.pbc(n2 + 1)] - d - d5);
        if ((d4 = -1.0 * d4 - this.H * (d3 += Math.sin(d + d5))) <= 0.0 || Math.random() < Math.exp(-d4 / this.T)) {
            double[] dArray = this.spinAngle[n];
            int n3 = n2;
            dArray[n3] = dArray[n3] + d5;
            if (this.spinAngle[n][n2] > Math.PI * 2) {
                double[] dArray2 = this.spinAngle[n];
                int n4 = n2;
                dArray2[n4] = dArray2[n4] - Math.PI * 2;
            } else if (this.spinAngle[n][n2] < Math.PI * -2) {
                double[] dArray3 = this.spinAngle[n];
                int n5 = n2;
                dArray3[n5] = dArray3[n5] + Math.PI * 2;
            }
            this.Mx += d2;
            this.My += d3;
            this.E += d4;
            return true;
        }
        return false;
    }

    public void rotateSpinBloc(int n, int n2, int n3, int n4, double d) {
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                double[] dArray = this.spinAngle[n5];
                int n7 = n6;
                dArray[n7] = dArray[n7] + d;
                if (this.spinAngle[n5][n6] > Math.PI * 2) {
                    double[] dArray2 = this.spinAngle[n5];
                    int n8 = n6;
                    dArray2[n8] = dArray2[n8] - Math.PI * 2;
                } else if (this.spinAngle[n5][n6] < 0.0) {
                    double[] dArray3 = this.spinAngle[n5];
                    int n9 = n6;
                    dArray3[n9] = dArray3[n9] + Math.PI * 2;
                }
                ++n6;
            }
            ++n5;
        }
        this.getME();
    }

    public void onestep() {
        int n = this.L * this.L;
        int n2 = 0;
        while (n2 < n) {
            this.rotate();
            ++n2;
        }
        this.ave_Mx += this.Mx;
        this.ave_My += this.My;
        this.ave_E += this.E;
        ++this.time_counter;
    }

    private int identifyVortex(int n, int n2) {
        double d = 0.0;
        double[] dArray = new double[]{this.spinAngle[n][n2], this.spinAngle[n][this.pbc(n2 + 1)], this.spinAngle[this.pbc(n + 1)][this.pbc(n2 + 1)], this.spinAngle[this.pbc(n + 1)][n2]};
        int n3 = 0;
        while (n3 < 3) {
            double d2 = dArray[n3 + 1] - dArray[n3];
            d = d2 <= Math.PI && d2 > -Math.PI ? (d += d2) : (d2 > Math.PI ? (d += d2 - Math.PI * 2) : (d += d2 + Math.PI * 2));
            ++n3;
        }
        if (d > Math.PI) {
            return 1;
        }
        if (d < -Math.PI) {
            return -1;
        }
        return 0;
    }

    private void drawOneSpin(Graphics graphics, int n, int n2, double d, double d2) {
        int n3 = (int)(d / 2.0 * Math.cos(d2));
        int n4 = (int)(d / 2.0 * Math.sin(d2));
        graphics.drawLine(n - n3, n2 + n4, n + n3, n2 - n4);
        int n5 = (int)(d / 4.0 * Math.cos(d2 + 0.5235987755982988));
        int n6 = (int)(d / 4.0 * Math.sin(d2 + 0.5235987755982988));
        graphics.drawLine(n + n3, n2 - n4, n + n3 - n5, n2 - n4 + n6);
        n5 = (int)(d / 4.0 * Math.cos(d2 - 0.5235987755982988));
        n6 = (int)(d / 4.0 * Math.sin(d2 - 0.5235987755982988));
        graphics.drawLine(n + n3, n2 - n4, n + n3 - n5, n2 - n4 + n6);
    }

    private void drawPlus(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)(d / 2.0);
        graphics.fillRect(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    private void drawMinus(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)(d / 2.0);
        graphics.fillRect(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public void drawSpins(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = (double)n3 / (double)this.L;
        double d2 = (double)n4 / (double)this.L;
        double d3 = d;
        if (d2 < d) {
            d3 = d2;
        }
        graphics.setColor(new Color(200, 200, 255));
        int n5 = 0;
        while (n5 < this.L) {
            int n6 = 0;
            while (n6 < this.L) {
                int n7 = n + (int)((double)n5 * d + d / 2.0);
                int n8 = n2 + (int)((double)n6 * d2 + d2 / 2.0);
                this.drawOneSpin(graphics, n7, n8, d3, this.spinAngle[n5][n6]);
                int n9 = this.identifyVortex(n5, n6);
                if (n9 == 1) {
                    graphics.setColor(Color.red);
                    this.drawPlus(graphics, n + (int)((double)(n5 + 1) * d), n2 + (int)((double)(n6 + 1) * d2), d3 / 3.0);
                    graphics.setColor(new Color(200, 200, 255));
                } else if (n9 == -1) {
                    graphics.setColor(new Color(0, 180, 20));
                    this.drawMinus(graphics, n + (int)((double)(n5 + 1) * d), n2 + (int)((double)(n6 + 1) * d2), d3 / 3.0);
                    graphics.setColor(new Color(200, 200, 255));
                }
                ++n6;
            }
            ++n5;
        }
    }
}

