/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class XYApplet
extends Applet {
    public XY experiment;
    private Canvas canvas = new XYCanvas(this);
    private Choice linearDimension = new Choice();
    private Button start = new Button("Start");
    private Button step = new Button("Step");
    private Button cont = new Button("Continue");
    private Button stop = new Button("Stop");
    private TextField temperature = new TextField("0.893", 6);
    private TextField field = new TextField("0", 6);
    private TextField angle = new TextField("1", 6);
    private TextField mctime = new TextField(4);
    private TextField mx = new TextField(5);
    private TextField my = new TextField(5);
    private TextField energy = new TextField(5);
    private TextField meanMx = new TextField(5);
    private TextField meanMy = new TextField(5);
    private TextField meanE = new TextField(5);
    public char status = (char)115;
    private int[] LChoices = new int[]{4, 8, 16, 32, 64, 128, 256};
    public int L;
    private double T;
    private double H;
    private double dtheta;

    public void init() {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new FlowLayout());
        panel2.setLayout(new FlowLayout());
        int n = 0;
        while (n < 7) {
            this.linearDimension.addItem("" + this.LChoices[n]);
            ++n;
        }
        panel.add(new Label("L:"));
        panel.add(this.linearDimension);
        panel.add(new Label("  T:"));
        panel.add(this.temperature);
        panel.add(new Label("  H:"));
        panel.add(this.field);
        panel.add(new Label(" dtheta"));
        panel.add(this.angle);
        panel.add(this.start);
        panel.add(this.step);
        panel.add(this.cont);
        panel.add(this.stop);
        this.add((Component)panel, "North");
        panel2.add(new Label("t:"));
        panel2.add(this.mctime);
        panel2.add(new Label("Mx:"));
        panel2.add(this.mx);
        panel2.add(new Label("My:"));
        panel2.add(this.my);
        panel2.add(new Label("E:"));
        panel2.add(this.energy);
        panel2.add(new Label("<Mx>:"));
        panel2.add(this.meanMx);
        panel2.add(new Label("<My>:"));
        panel2.add(this.meanMy);
        panel2.add(new Label("<E>:"));
        panel2.add(this.meanE);
        this.add((Component)panel2, "South");
        this.add((Component)this.canvas, "Center");
        this.start.addActionListener(new StartListener());
        this.step.addActionListener(new StepListener());
        this.stop.addActionListener(new StopListener());
        this.cont.addActionListener(new ContListener());
        this.start.addMouseListener(new StartMouseAdapter());
        this.step.addMouseListener(new StepMouseAdapter());
        this.stop.addMouseListener(new StopMouseAdapter());
        this.cont.addMouseListener(new ContMouseAdapter());
        this.mctime.setEditable(false);
        this.mx.setEditable(false);
        this.my.setEditable(false);
        this.energy.setEditable(false);
        this.meanMx.setEditable(false);
        this.meanMy.setEditable(false);
        this.meanE.setEditable(false);
        this.L = 32;
        this.T = 1.5;
        this.H = 0.0;
        new MyThread().start();
    }

    private double setPrecision(double d, int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            n2 *= 10;
            ++n3;
        }
        return (double)((int)(d * (double)n2)) / (double)n2;
    }

    public void displayVariables() {
        this.mctime.setText("" + this.experiment.time_counter);
        this.mx.setText("" + this.setPrecision(this.experiment.Mx, 2));
        this.my.setText("" + this.setPrecision(Math.sqrt(this.experiment.My * this.experiment.My + this.experiment.Mx * this.experiment.Mx), 2));
        this.energy.setText("" + this.setPrecision(this.experiment.E, 2));
        this.meanMx.setText("" + this.setPrecision(this.experiment.ave_Mx / (double)this.experiment.time_counter, 2));
        this.meanMy.setText("" + this.setPrecision(this.experiment.ave_My / (double)this.experiment.time_counter, 2));
        this.meanE.setText("" + this.setPrecision(this.experiment.ave_E / (double)this.experiment.time_counter, 2));
    }

    private class MyThread
    extends Thread {
        private MyThread() {
        }

        public void run() {
            while (true) {
                if (XYApplet.this.experiment != null) {
                    if (XYApplet.this.status == 'r') {
                        XYApplet.this.experiment.onestep();
                        XYApplet.this.canvas.repaint();
                    } else if (XYApplet.this.status == 't' && XYApplet.this.experiment != null) {
                        XYApplet.this.experiment.onestep();
                        XYApplet.this.canvas.repaint();
                        XYApplet.this.status = (char)115;
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class StopMouseAdapter
    extends MouseAdapter {
        private StopMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("Stops the simulation.");
        }

        public void mouseExited(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("");
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XYApplet.this.status = (char)115;
        }
    }

    private class ContMouseAdapter
    extends MouseAdapter {
        private ContMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("Resets magnetic field H and temperature T, and continues the simulation with the current configuration.");
        }

        public void mouseExited(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("");
        }
    }

    private class ContListener
    implements ActionListener {
        private ContListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XYApplet.this.experiment == null) {
                XYApplet.this.status = (char)115;
                return;
            }
            double d = new Double(XYApplet.this.temperature.getText());
            double d2 = new Double(XYApplet.this.field.getText());
            double d3 = new Double(XYApplet.this.angle.getText());
            if (d != XYApplet.this.T) {
                XYApplet.this.T = d;
                XYApplet.this.experiment.resetT(XYApplet.this.T);
            }
            if (d2 != XYApplet.this.H) {
                XYApplet.this.H = d2;
                XYApplet.this.experiment.resetH(XYApplet.this.H);
            }
            if (d3 != XYApplet.this.dtheta) {
                XYApplet.this.dtheta = d3;
                XYApplet.this.experiment.resetDtheta(XYApplet.this.dtheta);
            }
            XYApplet.this.status = (char)114;
        }
    }

    private class StepMouseAdapter
    extends MouseAdapter {
        private StepMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("Advances the simulation by one Monte Carlo step, then stops.");
        }

        public void mouseExited(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("");
        }
    }

    private class StepListener
    implements ActionListener {
        private StepListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XYApplet.this.status = (char)116;
        }
    }

    private class StartMouseAdapter
    extends MouseAdapter {
        private StartMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("Initialize/Reinitialize the system with a random configuration and runs in an infinite loop.");
        }

        public void mouseExited(MouseEvent mouseEvent) {
            XYApplet.this.showStatus("");
        }
    }

    private class StartListener
    implements ActionListener {
        private StartListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XYApplet.this.L = XYApplet.this.LChoices[XYApplet.this.linearDimension.getSelectedIndex()];
            XYApplet.this.T = new Double(XYApplet.this.temperature.getText());
            XYApplet.this.H = new Double(XYApplet.this.field.getText());
            XYApplet.this.dtheta = new Double(XYApplet.this.angle.getText());
            if (XYApplet.this.experiment == null) {
                XYApplet.this.experiment = new XY(XYApplet.this.L, XYApplet.this.T, XYApplet.this.H, XYApplet.this.dtheta);
            } else {
                XYApplet.this.experiment.reinitialize(XYApplet.this.L, XYApplet.this.T, XYApplet.this.H, XYApplet.this.dtheta);
            }
            XYApplet.this.canvas.repaint();
            XYApplet.this.status = (char)114;
        }
    }
}

