/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class XYCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    XYApplet app;
    int oldWidth = -1;
    int oldHeight = -1;
    int imageOffset = 15;
    int startX;
    int startY;
    int endX;
    int endY;
    int boxXStartIndex;
    int boxYStartIndex;
    int boxXEndIndex;
    int boxYEndIndex;
    int boxX;
    int boxY;
    int boxWidth;
    int boxHeight;
    int centerX;
    int centerY;
    double initialAngle;
    double finalAngle;
    boolean spinsSet = false;
    Image image = null;

    public XYCanvas(XYApplet xYApplet) {
        this.app = xYApplet;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.draw3DRect(this.imageOffset - 5, this.imageOffset - 5, dimension.width - 2 * this.imageOffset + 10, dimension.height - 2 * this.imageOffset + 10, true);
        if (this.app.experiment != null) {
            int n = dimension.width - 2 * this.imageOffset;
            int n2 = dimension.height - 2 * this.imageOffset;
            if (this.oldWidth != n || this.oldHeight != n2 || this.image == null) {
                this.image = this.createImage(n, n2);
                this.oldWidth = n;
                this.oldHeight = n2;
            }
            Graphics graphics2 = this.image.getGraphics();
            graphics2.clearRect(0, 0, n, n2);
            this.app.experiment.drawSpins(graphics2, 0, 0, n, n2);
            graphics.drawImage(this.image, this.imageOffset, this.imageOffset, this);
            this.app.displayVariables();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.app.status != 's' || this.app.experiment == null || this.image == null) {
            return;
        }
        if (this.spinsSet) {
            this.initialAngle = this.finalAngle = this.computeAngle(mouseEvent.getX() - this.imageOffset - this.centerX, this.centerY - mouseEvent.getY() + this.imageOffset);
        } else {
            this.startX = mouseEvent.getX() - this.imageOffset;
            this.startY = mouseEvent.getY() - this.imageOffset;
            this.boxYEndIndex = 0;
            this.boxYStartIndex = 0;
            this.boxXEndIndex = 0;
            this.boxXStartIndex = 0;
            this.boxHeight = 0;
            this.boxWidth = 0;
            this.boxY = 0;
            this.boxX = 0;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.app.status != 's' || this.app.experiment == null || this.image == null) {
            return;
        }
        Graphics graphics = this.image.getGraphics();
        Graphics graphics2 = this.getGraphics();
        if (!this.spinsSet) {
            int n;
            int n2;
            graphics.setXORMode(Color.white);
            graphics.setColor(Color.gray);
            graphics.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
            this.endX = mouseEvent.getX() - this.imageOffset;
            this.endY = mouseEvent.getY() - this.imageOffset;
            int n3 = this.startX;
            int n4 = this.endX;
            if (n4 < n3) {
                n4 = n3;
                n3 = this.endX;
            }
            if ((n2 = this.endY) < (n = this.startY)) {
                n2 = n;
                n = this.endY;
            }
            double d = (double)this.oldWidth / (double)this.app.L;
            double d2 = (double)this.oldHeight / (double)this.app.L;
            this.boxXStartIndex = (int)((double)n3 / d);
            this.boxYStartIndex = (int)((double)n / d2);
            this.boxXEndIndex = (int)((double)n4 / d);
            this.boxYEndIndex = (int)((double)n2 / d2);
            this.boxX = (int)((double)this.boxXStartIndex * d) + 1;
            this.boxY = (int)((double)this.boxYStartIndex * d2) + 1;
            this.boxWidth = (int)((double)(this.boxXEndIndex - this.boxXStartIndex + 1) * d) - 2;
            this.boxHeight = (int)((double)(this.boxYEndIndex - this.boxYStartIndex + 1) * d2) - 2;
            this.centerX = this.boxX + this.boxWidth / 2;
            this.centerY = this.boxY + this.boxHeight / 2;
            graphics.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
            graphics2.drawImage(this.image, this.imageOffset, this.imageOffset, this);
        } else {
            double d = this.finalAngle;
            this.finalAngle = this.computeAngle(mouseEvent.getX() - this.imageOffset - this.centerX, this.centerY - mouseEvent.getY() + this.imageOffset);
            this.app.experiment.rotateSpinBloc(this.boxXStartIndex, this.boxYStartIndex, this.boxXEndIndex, this.boxYEndIndex, this.finalAngle - d);
            this.repaint(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
            graphics.setPaintMode();
            graphics.setColor(Color.gray);
            graphics.drawRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight);
            graphics.setColor(Color.red);
            graphics.drawOval(this.centerX - 3, this.centerY - 3, 6, 6);
            graphics2.drawImage(this.image, this.imageOffset, this.imageOffset, this);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.app.status != 's' || this.app.experiment == null || this.image == null) {
            return;
        }
        this.mouseDragged(mouseEvent);
        boolean bl = this.spinsSet = !this.spinsSet;
        if (!this.spinsSet) {
            this.repaint();
        } else {
            Graphics graphics = this.image.getGraphics();
            graphics.setPaintMode();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.app.status != 's' || this.app.experiment == null || this.image == null) {
            return;
        }
        if (!this.spinsSet) {
            this.app.showStatus("Mouse press, drag, and release on the canvas selects a bloc of spins.");
        } else {
            this.app.showStatus("Mouse press, drag, and release changes the orientation of the selected spins.");
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.app.showStatus("");
        if (this.app.status != 's' || this.app.experiment == null || this.image == null) {
            return;
        }
        this.spinsSet = false;
        Graphics graphics = this.image.getGraphics();
        graphics.setPaintMode();
        this.repaint();
    }

    private double computeAngle(double d, double d2) {
        if (d == 0.0) {
            if (d2 > 0.0) {
                return 1.5707963267948966;
            }
            if (d2 < 0.0) {
                return -1.5707963267948966;
            }
            return 0.0;
        }
        double d3 = Math.atan(d2 / d);
        if (d < 0.0) {
            d3 += Math.PI;
        }
        return d3;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

