/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Cluster3D
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    int w;
    int h;
    int h2;
    int w2;
    int mx0;
    int my0;
    int[] iCol;
    int maxCl;
    int hBut = 30;
    int[] xi;
    int[] yi;
    int[] zi;
    int[] x1;
    int[] y1;
    int[] zs;
    int[][] Fx;
    int[][] Fy;
    int L = 30;
    int L1;
    int[][][] cl;
    double p = 0.312;
    double fiX = 0.2;
    double fiY = 0.3;
    double dfi = 0.01;
    double scale;
    double[] z1;
    boolean painted = false;
    Image buffImage;
    Graphics buffGraphics;
    Label lbP;
    TextField tfP;
    Button btNew;
    Color[] col;

    public void init() {
        this.w = this.getSize().width;
        this.h = this.getSize().height - this.hBut;
        this.h2 = this.h / 2;
        this.w2 = this.w / 2;
        String string = this.getParameter("L");
        if (string != null) {
            this.L = Integer.parseInt(string);
        }
        if ((string = this.getParameter("p")) != null) {
            this.p = Double.valueOf(string);
        }
        int n = this.L * this.L * this.L;
        int n2 = this.L + 2;
        this.L1 = this.L + 1;
        this.scale = (double)this.w2 / (Math.sqrt(3.0) * (double)this.L);
        this.xi = new int[n];
        this.yi = new int[n];
        this.zi = new int[n];
        this.x1 = new int[n];
        this.y1 = new int[n];
        this.zs = new int[n];
        this.z1 = new double[n];
        int n3 = 0;
        while (n3 < this.maxCl) {
            this.xi[n3] = 2 * (int)(10.0 * (Math.random() - 0.5));
            this.yi[n3] = 2 * (int)(10.0 * (Math.random() - 0.5));
            this.zi[n3] = 2 * (int)(10.0 * (Math.random() - 0.5));
            this.zs[n3] = n3;
            ++n3;
        }
        this.cl = new int[n2][n2][n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n2) {
                    this.cl[n4][n5][n6] = -1;
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        this.Fx = new int[3][];
        this.Fy = new int[3][];
        int n7 = 0;
        while (n7 < 3) {
            this.Fx[n7] = new int[4];
            this.Fy[n7] = new int[4];
            ++n7;
        }
        this.col = new Color[256];
        int n8 = 0;
        while (n8 < 256) {
            this.col[n8] = new Color(n8, n8, n8);
            ++n8;
        }
        this.iCol = new int[3];
        this.buffImage = this.createImage(this.w, this.h);
        this.buffGraphics = this.buffImage.getGraphics();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.lbP = new Label("p", 2);
        this.add(this.lbP);
        this.tfP = new TextField("" + (float)this.p, 5);
        this.add(this.tfP);
        this.tfP.addKeyListener(this);
        this.btNew = new Button("New");
        this.btNew.addActionListener(this);
        this.add(this.btNew);
        this.built();
    }

    public void built() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 1;
        while (n5 < this.L1) {
            int n6 = 1;
            while (n6 < this.L1) {
                int n7 = 1;
                while (n7 < this.L1) {
                    this.cl[n5][n6][n7] = 0;
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        int n8 = this.L / 2;
        int[] nArray = new int[]{1, -1, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 1, -1, 0, 0};
        int[] nArray3 = new int[]{0, 0, 0, 0, 1, -1};
        this.cl[n8][n8][n8] = 1;
        int n9 = 0;
        while (n9 < 6) {
            this.xi[n9] = n8 + nArray[n9];
            this.yi[n9] = n8 + nArray2[n9];
            this.zi[n9] = n8 + nArray3[n9];
            this.cl[this.xi[n9]][this.yi[n9]][this.zi[n9]] = 2;
            ++n9;
        }
        int n10 = 5;
        do {
            --n10;
            n3 = this.xi[n4];
            n2 = this.yi[n4];
            n = this.zi[n4];
            if (this.cl[n3][n2][n] != 2) continue;
            if (Math.random() > this.p) {
                this.cl[n3][n2][n] = -1;
                continue;
            }
            this.cl[n3][n2][n] = 1;
            int n11 = 0;
            while (n11 < 6) {
                int n12 = n3 + nArray[n11];
                int n13 = n2 + nArray2[n11];
                int n14 = n + nArray3[n11];
                if (this.cl[n12][n13][n14] == 0) {
                    this.cl[n12][n13][n14] = 2;
                    this.xi[++n10] = n12;
                    this.yi[n10] = n13;
                    this.zi[n10] = n14;
                }
                ++n11;
            }
        } while (n10 >= 0);
        this.maxCl = 0;
        n4 = 1;
        while (n4 < this.L1) {
            n3 = 1;
            while (n3 < this.L1) {
                n2 = 1;
                while (n2 < this.L1) {
                    if (this.cl[n4][n3][n2] == 1) {
                        this.xi[this.maxCl] = 2 * (n4 - n8);
                        this.yi[this.maxCl] = 2 * (n3 - n8);
                        this.zi[this.maxCl++] = 2 * (n2 - n8);
                    }
                    ++n2;
                }
                ++n3;
            }
            ++n4;
        }
        n = 0;
        while (n < this.maxCl) {
            this.zs[n] = n;
            ++n;
        }
        this.rotate();
    }

    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mx0 = mouseEvent.getX();
        this.my0 = mouseEvent.getY();
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.isShiftDown()) {
            this.scale *= Math.exp((double)(-(n2 - this.my0)) / (double)this.w);
        } else {
            this.fiX += this.dfi * (double)(n2 - this.my0);
        }
        this.fiY += this.dfi * (double)(n - this.mx0);
        this.mx0 = n;
        this.my0 = n2;
        this.rotate();
        this.repaint();
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            try {
                this.p = Double.valueOf(this.tfP.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.built();
            this.repaint();
        }
        keyEvent.consume();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.built();
        this.repaint();
    }

    public void rotate() {
        double d = Math.cos(this.fiX);
        double d2 = Math.cos(this.fiY);
        double d3 = Math.sin(this.fiX);
        double d4 = Math.sin(this.fiY);
        double d5 = this.scale * d2;
        double d6 = this.scale * d4;
        double d7 = this.scale * d3 * d4;
        double d8 = this.scale * d;
        double d9 = -this.scale * d3 * d2;
        double d10 = -255.0 * d * d4;
        double d11 = 255.0 * d3;
        double d12 = 255.0 * d * d2;
        int[] nArray = new int[]{(int)(d5 + d6), (int)(d5 + d6), (int)(d5 - d6), (int)(d5 - d6), (int)(-d5 + d6), (int)(-d5 + d6), (int)(-d5 - d6), (int)(-d5 - d6)};
        int[] nArray2 = new int[]{(int)(d7 + d8 + d9), (int)(d7 - d8 + d9), (int)(d7 - d8 - d9), (int)(d7 + d8 - d9), (int)(-d7 + d8 + d9), (int)(-d7 - d8 + d9), (int)(-d7 - d8 - d9), (int)(-d7 + d8 - d9)};
        int[] nArray3 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        int[] nArray4 = new int[]{nArray2[0], nArray2[1], nArray2[2], nArray2[3]};
        int[] nArray5 = new int[]{nArray[4], nArray[5], nArray[6], nArray[7]};
        int[] nArray6 = new int[]{nArray2[4], nArray2[5], nArray2[6], nArray2[7]};
        int[] nArray7 = new int[]{nArray[0], nArray[3], nArray[7], nArray[4]};
        int[] nArray8 = new int[]{nArray2[0], nArray2[3], nArray2[7], nArray2[4]};
        int[] nArray9 = new int[]{nArray[1], nArray[2], nArray[6], nArray[5]};
        int[] nArray10 = new int[]{nArray2[1], nArray2[2], nArray2[6], nArray2[5]};
        int[] nArray11 = new int[]{nArray[0], nArray[4], nArray[5], nArray[1]};
        int[] nArray12 = new int[]{nArray2[0], nArray2[4], nArray2[5], nArray2[1]};
        int[] nArray13 = new int[]{nArray[3], nArray[7], nArray[6], nArray[2]};
        int[] nArray14 = new int[]{nArray2[3], nArray2[7], nArray2[6], nArray2[2]};
        if (d10 > 0.0) {
            this.Fx[0] = nArray3;
            this.Fy[0] = nArray4;
        } else {
            this.Fx[0] = nArray5;
            this.Fy[0] = nArray6;
        }
        if (d11 > 0.0) {
            this.Fx[1] = nArray7;
            this.Fy[1] = nArray8;
        } else {
            this.Fx[1] = nArray9;
            this.Fy[1] = nArray10;
        }
        if (d12 > 0.0) {
            this.Fx[2] = nArray11;
            this.Fy[2] = nArray12;
        } else {
            this.Fx[2] = nArray13;
            this.Fy[2] = nArray14;
        }
        this.iCol[0] = (int)Math.abs(d10);
        this.iCol[1] = (int)Math.abs(d11);
        this.iCol[2] = (int)Math.abs(d12);
        int n = 0;
        while (n < this.maxCl) {
            this.x1[n] = (int)(d5 * (double)this.xi[n] + d6 * (double)this.zi[n]);
            this.y1[n] = (int)(d7 * (double)this.xi[n] + d8 * (double)this.yi[n] + d9 * (double)this.zi[n]);
            this.z1[n] = d10 * (double)this.xi[n] + d11 * (double)this.yi[n] + d12 * (double)this.zi[n];
            ++n;
        }
        int n2 = this.maxCl - 1;
        while (--n2 >= 0) {
            boolean bl = false;
            int n3 = 0;
            while (n3 <= n2) {
                int n4 = this.zs[n3];
                int n5 = this.zs[n3 + 1];
                if (this.z1[n4] > this.z1[n5]) {
                    this.zs[n3 + 1] = n4;
                    this.zs[n3] = n5;
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
        }
        this.painted = false;
    }

    public void paint(Graphics graphics) {
        if (!this.painted) {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            this.buffGraphics.setColor(Color.blue);
            this.buffGraphics.fillRect(0, 0, this.w, this.h);
            int n = 0;
            while (n < this.maxCl) {
                int n2 = this.zs[n];
                int n3 = 0;
                while (n3 < 3) {
                    int n4 = 0;
                    while (n4 < 4) {
                        nArray[n4] = this.w2 + this.x1[n2] + this.Fx[n3][n4];
                        nArray2[n4] = this.h2 - this.y1[n2] - this.Fy[n3][n4];
                        ++n4;
                    }
                    this.buffGraphics.setColor(this.col[this.iCol[n3]]);
                    this.buffGraphics.fillPolygon(nArray, nArray2, 4);
                    ++n3;
                }
                ++n;
            }
            this.painted = true;
        }
        graphics.drawImage(this.buffImage, 0, this.hBut, this);
        this.showStatus("fiX=" + (int)(360.0 * this.fiX) + "   fiY=" + (int)(360.0 * this.fiY));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

