/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class Contour
extends Applet
implements ItemListener,
ActionListener,
MouseMotionListener {
    int Rc = 8;
    int Lc;
    int w;
    int h;
    int lbSize = 30;
    int[] iV;
    int maxColor;
    int cWhite = this.maxColor = 9;
    int cBlack = this.maxColor + 1;
    int hBar;
    int hCol;
    int[] nb;
    int[] delNb;
    double[] V;
    double[][] f;
    double[][] G;
    double Vo;
    double sV;
    double Vp = -0.95;
    Choice chRc;
    Label lbRc;
    Button btNew;
    Image img;
    Image imBar;
    IndexColorModel iColor;
    long generTime;
    boolean bBurn = false;
    Checkbox cbBurn;

    public void init() {
        this.w = this.getSize().width - 30;
        this.h = this.getSize().height - this.lbSize;
        this.nb = new int[this.w * this.h];
        this.delNb = new int[4];
        this.delNb[0] = 1;
        this.delNb[1] = -1;
        this.delNb[2] = this.w;
        this.delNb[3] = -this.w;
        String string = this.getParameter("Rc");
        if (string != null) {
            this.Rc = Integer.parseInt(string);
        }
        if ((string = this.getParameter("Vp")) != null) {
            this.Vp = Double.valueOf(string);
        }
        this.V = new double[this.w * this.h];
        this.iV = new int[this.w * (this.h + 2)];
        this.f = new double[this.h + 64][this.w + 64];
        int n = 0;
        while (n < this.h + 64) {
            int n2 = 0;
            while (n2 < this.w + 64) {
                this.f[n][n2] = 2.0 * Math.random() - 1.0;
                ++n2;
            }
            ++n;
        }
        this.G = new double[32][32];
        this.Lc = 2 * this.Rc;
        double d = this.Rc * this.Rc;
        this.G[0][0] = 1.0;
        int n3 = 1;
        while (n3 < this.Lc) {
            this.G[0][n3] = Math.exp(-((double)(n3 * n3) / d));
            int n4 = 1;
            while (n4 <= n3) {
                this.G[n4][n3] = this.G[0][n3] * this.G[0][n4];
                ++n4;
            }
            ++n3;
        }
        byte[] byArray = new byte[this.maxColor + 2];
        byte[] byArray2 = new byte[this.maxColor + 2];
        byte[] byArray3 = new byte[this.maxColor + 2];
        int n5 = this.maxColor / 2;
        long l = (long)n5 * (long)n5 * (long)n5 * (long)n5;
        int n6 = 0;
        while (n6 < n5) {
            long l2 = n6;
            l2 *= l2;
            l2 *= l2;
            byte by = (byte)(255L - 255L * l2 / l);
            byArray[this.maxColor - 1 - n6] = by;
            byArray3[n5 - n6] = by;
            byArray3[n5 + n6] = by;
            byArray2[n6] = by;
            ++n6;
        }
        byArray3[n5] = -36;
        byArray2[this.cWhite] = -1;
        byArray3[this.cWhite] = -1;
        byArray[this.cWhite] = -1;
        this.iColor = new IndexColorModel(8, this.maxColor + 2, byArray, byArray3, byArray2);
        this.hCol = this.h / this.maxColor;
        this.hBar = this.maxColor * this.hCol;
        int[] nArray = new int[20 * this.hBar];
        int n7 = 0;
        int n8 = this.maxColor - 1;
        while (n8 >= 0) {
            int n9 = 0;
            while (n9 < this.hCol) {
                int n10 = 0;
                while (n10 < 20) {
                    nArray[n7++] = n8;
                    ++n10;
                }
                ++n9;
            }
            --n8;
        }
        this.imBar = this.createImage(new MemoryImageSource(20, this.hBar, (ColorModel)this.iColor, nArray, 0, 20));
        this.lbRc = new Label("Rc", 2);
        this.add(this.lbRc);
        this.chRc = new Choice();
        int n11 = 0;
        int n12 = 1;
        while (n11 < 5) {
            this.chRc.addItem(Integer.toString(n12));
            n12 *= 2;
            ++n11;
        }
        this.chRc.select("" + this.Rc);
        this.chRc.addItemListener(this);
        this.add(this.chRc);
        this.btNew = new Button("New");
        this.btNew.addActionListener(this);
        this.add(this.btNew);
        string = this.getParameter("Burn");
        if (string != null) {
            this.bBurn = true;
        }
        this.cbBurn = new Checkbox("Burn", this.bBurn);
        this.add(this.cbBurn);
        this.cbBurn.addItemListener(this);
        this.addMouseMotionListener(this);
        this.averaging();
    }

    public void destroy() {
        this.removeMouseMotionListener(this);
    }

    public void averaging() {
        this.generTime = System.currentTimeMillis();
        double d = 100.0;
        double d2 = -100.0;
        this.sV = 0.0;
        int n = 0;
        int n2 = this.w + 32;
        int n3 = 32;
        while (n3 < this.h + 32) {
            int n4 = 32;
            while (n4 < n2) {
                double d3 = this.G[0][0] * this.f[n3][n4];
                int n5 = 1;
                while (n5 < this.Lc) {
                    int n6 = n3 + n5;
                    int n7 = n3 - n5;
                    int n8 = n4 + n5;
                    int n9 = n4 - n5;
                    d3 += this.G[0][n5] * (this.f[n6][n4] + this.f[n7][n4] + this.f[n3][n8] + this.f[n3][n9]) + this.G[n5][n5] * (this.f[n6][n8] + this.f[n7][n8] + this.f[n6][n9] + this.f[n7][n9]);
                    int n10 = 1;
                    while (n10 < n5) {
                        int n11 = n3 + n10;
                        int n12 = n3 - n10;
                        int n13 = n4 + n10;
                        int n14 = n4 - n10;
                        d3 += this.G[n10][n5] * (this.f[n6][n13] + this.f[n7][n13] + this.f[n6][n14] + this.f[n7][n14] + this.f[n11][n8] + this.f[n12][n8] + this.f[n11][n9] + this.f[n12][n9]);
                        ++n10;
                    }
                    ++n5;
                }
                this.V[n++] = d3;
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
                this.sV += d3;
                ++n4;
            }
            ++n3;
        }
        this.sV /= (double)(this.w * this.h);
        this.Vo = d2;
        if (d2 < -d) {
            this.Vo = -d;
        }
        this.makeImg();
        this.generTime = System.currentTimeMillis() - this.generTime;
    }

    public void makeImg() {
        double d = 0.5 * (double)this.maxColor / this.Vo;
        double d2 = this.Vp * this.Vo;
        int n = 0;
        while (n < this.w * this.h) {
            double d3;
            double d4 = this.V[n];
            this.iV[n + this.w] = d3 < d2 ? this.cWhite : (int)(d * (d4 + this.Vo));
            ++n;
        }
        if (this.bBurn) {
            int n2 = -1;
            int n3 = this.w;
            while (n3 < 2 * this.w) {
                if (this.iV[n3] == this.cWhite) {
                    this.nb[++n2] = n3;
                }
                ++n3;
            }
            while (n2 >= 0) {
                int n4;
                if (this.iV[n4 = this.nb[n2--]] != this.cWhite) continue;
                this.iV[n4] = this.cBlack;
                int n5 = 0;
                while (n5 < 4) {
                    int n6 = n4 + this.delNb[n5];
                    if (this.iV[n6] == this.cWhite) {
                        this.nb[++n2] = n6;
                    }
                    ++n5;
                }
            }
        }
        if (this.img != null) {
            this.img.flush();
        }
        this.img = this.createImage(new MemoryImageSource(this.w, this.h, (ColorModel)this.iColor, this.iV, this.w, this.w));
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.img, 0, this.lbSize, this);
        graphics.drawImage(this.imBar, this.w + 10, this.lbSize, this);
        graphics.setColor(Color.white);
        int n = this.lbSize + (int)((double)this.hBar * (1.0 - this.sV / this.Vo) / 2.0);
        graphics.drawLine(this.w + 10, n, this.w + 30, n);
        graphics.setColor(Color.black);
        n = this.lbSize + (int)((double)this.hBar * (1.0 - this.Vp) / 2.0);
        graphics.drawLine(this.w + 10, n, this.w + 30, n);
        this.showStatus("T=" + this.generTime + "ms ");
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getX() > this.w) {
            int n = mouseEvent.getY() - this.lbSize;
            this.Vp = 1.0 - (double)n * 2.0 / (double)this.hBar;
            if (this.Vp < -1.0) {
                this.Vp = -1.0;
            }
            if (this.Vp > 1.0) {
                this.Vp = 1.0;
            }
            this.makeImg();
            this.repaint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.cbBurn) {
            this.bBurn = this.cbBurn.getState();
            this.makeImg();
        }
        if (object == this.chRc) {
            this.Rc = Integer.parseInt(this.chRc.getSelectedItem());
            this.Lc = 2 * this.Rc;
            double d = this.Rc * this.Rc;
            this.G[0][0] = 1.0;
            int n = 1;
            while (n < this.Lc) {
                this.G[0][n] = Math.exp(-((double)(n * n) / d));
                int n2 = 1;
                while (n2 <= n) {
                    this.G[n2][n] = this.G[0][n] * this.G[0][n2];
                    ++n2;
                }
                ++n;
            }
            this.averaging();
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.h + 64) {
            int n2 = 0;
            while (n2 < this.w + 64) {
                this.f[n][n2] = 2.0 * Math.random() - 1.0;
                ++n2;
            }
            ++n;
        }
        this.averaging();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

