/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;

public class Random3D
extends Applet
implements ItemListener,
ActionListener,
MouseListener,
MouseMotionListener {
    int n = 32;
    int n1;
    int Rc = 4;
    int h;
    int w;
    int h2;
    int w2;
    int mx0;
    int my0;
    int[] xPol;
    int[] yPol;
    int[][][] iCol;
    double Vp = 0.0;
    double Vs;
    double Vmin;
    double Vmax;
    double fiX = 0.8;
    double fiY = 0.3;
    double dfi = 0.01;
    double scale = 0.8;
    double m20;
    double m21;
    double m22;
    double[][][] vert;
    double[][][] vert1;
    double[][][][] Norm;
    double[][][] Norm1z;
    double[] M;
    Image buffImage;
    Graphics buffGraphics;
    Choice chRc;
    Choice chL;
    Label lbRc;
    Label lbL;
    Button btNew;
    Color[][] col;
    boolean painted;

    public void init() {
        int n;
        int n2;
        int n3;
        this.w = this.getSize().width - 30;
        this.h = this.getSize().height;
        this.w2 = this.w / 2;
        this.h2 = this.h / 2;
        String string = this.getParameter("N");
        if (string != null) {
            this.n = Integer.parseInt(string);
        }
        if ((string = this.getParameter("Rc")) != null) {
            this.Rc = Integer.parseInt(string);
        }
        this.xPol = new int[3];
        this.yPol = new int[3];
        this.buffImage = this.createImage(this.w, this.h);
        this.buffGraphics = this.buffImage.getGraphics();
        this.col = new Color[2][256];
        int n4 = 0;
        while (n4 < 256) {
            this.col[0][n4] = new Color(0, 0, n4);
            this.col[1][n4] = new Color(0, n4, 0);
            ++n4;
        }
        string = this.getParameter("bgColor");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
            this.setBackground(new Color(n3, n2, n));
        } else {
            this.setBackground(new Color(255, 255, 255));
        }
        this.lbL = new Label("L", 2);
        this.add(this.lbL);
        this.chL = new Choice();
        int n5 = 0;
        n3 = 32;
        while (n5 < 4) {
            this.chL.addItem(Integer.toString(n3));
            n3 *= 2;
            ++n5;
        }
        this.chL.select("" + this.n);
        this.chL.addItemListener(this);
        this.add(this.chL);
        this.lbRc = new Label("Rc", 2);
        this.add(this.lbRc);
        this.chRc = new Choice();
        n2 = 0;
        n = 1;
        while (n2 < 5) {
            this.chRc.addItem(Integer.toString(n));
            n *= 2;
            ++n2;
        }
        this.chRc.select("" + this.Rc);
        this.chRc.addItemListener(this);
        this.add(this.chRc);
        this.btNew = new Button("New");
        this.btNew.addActionListener(this);
        this.add(this.btNew);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.landscape();
        this.make3D();
    }

    public void make3D() {
        this.vert = new double[this.n1][this.n1][3];
        this.vert1 = new double[this.n1][this.n1][2];
        double d = (double)this.w / (double)this.n;
        int n = 0;
        while (n < this.n1) {
            int n2 = 0;
            while (n2 < this.n1) {
                this.vert[n][n2][0] = d * (double)n - (double)this.w2;
                this.vert[n][n2][2] = d * (double)n2 - (double)this.w2;
                double d2 = this.M[n + this.n1 * n2];
                if (d2 < this.Vp) {
                    d2 = this.Vp;
                }
                this.vert[n][n2][1] = (double)this.w * d2 - (double)(this.w2 / 2);
                ++n2;
            }
            ++n;
        }
        this.Norm = new double[this.n1][this.n1][2][3];
        this.Norm1z = new double[this.n1][this.n1][2];
        this.iCol = new int[this.n][this.n][2];
        int n3 = 0;
        while (n3 < this.n) {
            int n4 = 0;
            while (n4 < this.n) {
                double d3 = ((this.vert[n3][n4][1] + this.vert[n3 + 1][n4][1] + this.vert[n3 + 1][n4 + 1][1]) / 3.0 + (double)(this.w2 / 2)) / (double)this.w;
                this.iCol[n3][n4][0] = d3 < this.Vp + 1.0E-4 ? 0 : 1;
                d3 = ((this.vert[n3][n4][1] + this.vert[n3][n4 + 1][1] + this.vert[n3 + 1][n4 + 1][1]) / 3.0 + (double)(this.w2 / 2)) / (double)this.w;
                this.iCol[n3][n4][1] = d3 < this.Vp + 1.0E-4 ? 0 : 1;
                this.Norm[n3][n4][0][0] = this.vert[n3][n4][1] - this.vert[n3 + 1][n4][1];
                this.Norm[n3][n4][0][1] = d;
                this.Norm[n3][n4][0][2] = this.vert[n3 + 1][n4][1] - this.vert[n3 + 1][n4 + 1][1];
                double d4 = Math.sqrt(this.Norm[n3][n4][0][0] * this.Norm[n3][n4][0][0] + this.Norm[n3][n4][0][1] * this.Norm[n3][n4][0][1] + this.Norm[n3][n4][0][2] * this.Norm[n3][n4][0][2]) / 255.5;
                double[] dArray = this.Norm[n3][n4][0];
                dArray[0] = dArray[0] / d4;
                double[] dArray2 = this.Norm[n3][n4][0];
                dArray2[1] = dArray2[1] / d4;
                double[] dArray3 = this.Norm[n3][n4][0];
                dArray3[2] = dArray3[2] / d4;
                this.Norm[n3][n4][1][0] = this.vert[n3][n4 + 1][1] - this.vert[n3 + 1][n4 + 1][1];
                this.Norm[n3][n4][1][1] = d;
                this.Norm[n3][n4][1][2] = this.vert[n3][n4][1] - this.vert[n3][n4 + 1][1];
                d4 = Math.sqrt(this.Norm[n3][n4][1][0] * this.Norm[n3][n4][1][0] + this.Norm[n3][n4][1][1] * this.Norm[n3][n4][1][1] + this.Norm[n3][n4][1][2] * this.Norm[n3][n4][1][2]) / 255.5;
                double[] dArray4 = this.Norm[n3][n4][1];
                dArray4[0] = dArray4[0] / d4;
                double[] dArray5 = this.Norm[n3][n4][1];
                dArray5[1] = dArray5[1] / d4;
                double[] dArray6 = this.Norm[n3][n4][1];
                dArray6[2] = dArray6[2] / d4;
                ++n4;
            }
            ++n3;
        }
        this.rotate();
    }

    public void landscape() {
        int n;
        this.n1 = this.n + 1;
        int n2 = this.n;
        int n3 = this.n1 * this.n1;
        this.M = new double[n3];
        double[][] dArray = new double[this.n1 + 64][this.n1 + 64];
        int n4 = 0;
        while (n4 < this.n1 + 64) {
            int n5 = 0;
            while (n5 < this.n1 + 64) {
                dArray[n4][n5] = 2.0 * Math.random() - 1.0;
                ++n5;
            }
            ++n4;
        }
        int n6 = 2 * this.Rc;
        double d = this.Rc * this.Rc;
        double[][] dArray2 = new double[32][32];
        dArray2[0][0] = 1.0;
        int n7 = 1;
        while (n7 < n6) {
            dArray2[0][n7] = Math.exp(-((double)(n7 * n7) / d));
            n = 1;
            while (n <= n7) {
                dArray2[n][n7] = dArray2[0][n7] * dArray2[0][n];
                ++n;
            }
            ++n7;
        }
        this.Vs = 0.0;
        this.Vmin = 100.0;
        this.Vmax = -100.0;
        n = 0;
        int n8 = this.n1 + 32;
        int n9 = 32;
        while (n9 < n8) {
            int n10 = 32;
            while (n10 < n8) {
                double d2 = dArray2[0][0] * dArray[n9][n10];
                int n11 = 1;
                while (n11 < n6) {
                    int n12 = n9 + n11;
                    int n13 = n9 - n11;
                    int n14 = n10 + n11;
                    int n15 = n10 - n11;
                    d2 += dArray2[0][n11] * (dArray[n12][n10] + dArray[n13][n10] + dArray[n9][n14] + dArray[n9][n15]) + dArray2[n11][n11] * (dArray[n12][n14] + dArray[n13][n14] + dArray[n12][n15] + dArray[n13][n15]);
                    int n16 = 1;
                    while (n16 < n11) {
                        int n17 = n9 + n16;
                        int n18 = n9 - n16;
                        int n19 = n10 + n16;
                        int n20 = n10 - n16;
                        d2 += dArray2[n16][n11] * (dArray[n12][n19] + dArray[n13][n19] + dArray[n12][n20] + dArray[n13][n20] + dArray[n17][n14] + dArray[n18][n14] + dArray[n17][n15] + dArray[n18][n15]);
                        ++n16;
                    }
                    ++n11;
                }
                this.M[n++] = d2 *= 0.02;
                this.Vs += d2;
                if (d2 > this.Vmax) {
                    this.Vmax = d2;
                }
                if (d2 < this.Vmin) {
                    this.Vmin = d2;
                }
                ++n10;
            }
            ++n9;
        }
        this.Vs /= (double)n3;
    }

    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.landscape();
        this.make3D();
        this.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chRc) {
            this.Rc = Integer.parseInt(this.chRc.getSelectedItem());
        }
        if (object == this.chL) {
            this.n = Integer.parseInt(this.chL.getSelectedItem());
        }
        this.landscape();
        this.make3D();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mx0 = mouseEvent.getX();
        this.my0 = mouseEvent.getY();
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.getX() < this.w) {
            if (mouseEvent.isShiftDown()) {
                this.scale *= Math.exp((double)(-(n2 - this.my0)) / (double)this.w);
            } else {
                this.fiX += this.dfi * (double)(n2 - this.my0);
            }
            this.fiY += this.dfi * (double)(n - this.mx0);
            this.mx0 = n;
            this.my0 = n2;
            this.rotate();
        } else {
            this.Vp = this.Vmax - (double)n2 * (this.Vmax - this.Vmin) / (double)this.h;
            this.make3D();
        }
        this.repaint();
        mouseEvent.consume();
    }

    public void rotate() {
        double d = Math.cos(this.fiX);
        double d2 = Math.cos(this.fiY);
        double d3 = Math.sin(this.fiX);
        double d4 = Math.sin(this.fiY);
        double d5 = this.scale * d2;
        double d6 = this.scale * d4;
        double d7 = this.scale * d3 * d4;
        double d8 = this.scale * d;
        double d9 = -this.scale * d3 * d2;
        this.m20 = -d * d4;
        this.m21 = d3;
        this.m22 = d * d2;
        int n = 0;
        while (n < this.n1) {
            int n2 = 0;
            while (n2 < this.n1) {
                this.vert1[n][n2][0] = d5 * this.vert[n][n2][0] + d6 * this.vert[n][n2][2];
                this.vert1[n][n2][1] = d7 * this.vert[n][n2][0] + d8 * this.vert[n][n2][1] + d9 * this.vert[n][n2][2];
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.n) {
            int n4 = 0;
            while (n4 < this.n) {
                int n5 = 0;
                while (n5 < 2) {
                    this.Norm1z[n3][n4][n5] = this.m20 * this.Norm[n3][n4][n5][0] + this.m21 * this.Norm[n3][n4][n5][1] + this.m22 * this.Norm[n3][n4][n5][2];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        this.painted = false;
    }

    public void paint(Graphics graphics) {
        int n;
        if (!this.painted) {
            this.buffGraphics.clearRect(0, 0, this.w, this.h);
            n = 0;
            int n2 = this.n;
            int n3 = 1;
            int n4 = 0;
            int n5 = this.n;
            int n6 = 1;
            if (this.m20 < 0.0) {
                n = this.n;
                n2 = -1;
                n3 = -1;
            }
            if (this.m22 < 0.0) {
                n4 = this.n;
                n5 = -1;
                n6 = -1;
            }
            int n7 = n;
            while (n7 != n2) {
                int n8 = n4;
                while (n8 != n5) {
                    if (this.Norm1z[n7][n8][0] > 0.0) {
                        this.xPol[0] = this.w2 + (int)this.vert1[n7][n8][0];
                        this.xPol[1] = this.w2 + (int)this.vert1[n7 + 1][n8][0];
                        this.xPol[2] = this.w2 + (int)this.vert1[n7 + 1][n8 + 1][0];
                        this.yPol[0] = this.h2 - (int)this.vert1[n7][n8][1];
                        this.yPol[1] = this.h2 - (int)this.vert1[n7 + 1][n8][1];
                        this.yPol[2] = this.h2 - (int)this.vert1[n7 + 1][n8 + 1][1];
                        this.buffGraphics.setColor(this.col[this.iCol[n7][n8][0]][(int)this.Norm1z[n7][n8][0]]);
                        this.buffGraphics.fillPolygon(this.xPol, this.yPol, 3);
                    }
                    if (this.Norm1z[n7][n8][1] > 0.0) {
                        this.xPol[0] = this.w2 + (int)this.vert1[n7][n8][0];
                        this.xPol[1] = this.w2 + (int)this.vert1[n7][n8 + 1][0];
                        this.xPol[2] = this.w2 + (int)this.vert1[n7 + 1][n8 + 1][0];
                        this.yPol[0] = this.h2 - (int)this.vert1[n7][n8][1];
                        this.yPol[1] = this.h2 - (int)this.vert1[n7][n8 + 1][1];
                        this.yPol[2] = this.h2 - (int)this.vert1[n7 + 1][n8 + 1][1];
                        this.buffGraphics.setColor(this.col[this.iCol[n7][n8][1]][(int)this.Norm1z[n7][n8][1]]);
                        this.buffGraphics.fillPolygon(this.xPol, this.yPol, 3);
                    }
                    n8 += n6;
                }
                n7 += n3;
            }
            this.painted = true;
        }
        graphics.drawImage(this.buffImage, 0, 0, this);
        graphics.setColor(Color.blue);
        graphics.fillRect(this.w + 10, 0, 20, this.h);
        graphics.setColor(Color.white);
        n = this.h - (int)((double)this.h * (this.Vs - this.Vmin) / (this.Vmax - this.Vmin));
        graphics.drawLine(this.w + 10, n, this.w + 30, n);
        graphics.setColor(Color.yellow);
        n = this.h - (int)((double)this.h * (this.Vp - this.Vmin) / (this.Vmax - this.Vmin));
        graphics.drawLine(this.w + 10, n, this.w + 30, n);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

