// 2D Fractal Mountain,  Evgeny Demidov,  8 Feb 2002
import java.awt.*;
import java.awt.event.*;
public class fract2D extends java.applet.Applet
 implements ActionListener, KeyListener{
  int  n = 256, n1, w, h, h2, h0, lbSize = 50;
  double p[], m = 2;
  Label lbM;    Button btNew;    TextField tfM;

public void init() {
  w = getSize().width;
  h = getSize().height - lbSize;  h2 = h/2; h0 = h2 + lbSize;
  String s=getParameter("n"); if (s != null) n = Integer.parseInt(s);
  s=getParameter("m"); if (s != null) m = Double.valueOf(s).doubleValue();
  n1 = n+1;
  p = new double[n1];
  lbM = new Label("m", Label.RIGHT);  add(lbM);
  tfM = new TextField( "" + (float)m, 5);  add(tfM);
  tfM.addKeyListener(this);
  btNew = new Button("New");   btNew.addActionListener(this);
  add(btNew);
  build();
}
public void build(){
  double R = 2;
  int k = n/2;
  p[k] = R*(Math.random()-.5);
  while( k > 1){
    int st = k;
    k /= 2;  R /= m;
    for (int i = k; i < n; i += st)
      p[i] = (p[i-k] + p[i+k])/2 + R*(Math.random()-.5);}
}

public void paint(Graphics g) {
  g.setColor(Color.white);   g.fillRect(0, 0, w, h+lbSize);
  int x = 0, x0 = 0, y, y0 = (int)(h2*p[0]) + h0;
  g.setColor(Color.red);
  x = x0 = 0;  y0 = (int)(h2*p[0]) + h0;
  for (int i = 0; i < n1; i++){
    x += 2;  y = (int)(h2*p[i]) + h0;
    g.drawLine(x0,y0 ,x,y);
    x0 = x;  y0 = y;}
}

public void actionPerformed(ActionEvent e){
  build();
  repaint();
}
public void keyTyped(KeyEvent e){}
public void keyPressed(KeyEvent e){}
public void keyReleased(KeyEvent e){
  final int keyEnter = 10;
  if (e.getKeyCode() == keyEnter){
    try{ m = Double.valueOf(tfM.getText()).doubleValue();
    }catch(NumberFormatException ne){}
    build();
    repaint();
  }
  e.consume();
}
public void update(Graphics g){ paint(g); }
}