// Path integral Monte-Carlo,  Evgeny Demidov, 14 Apr 2004
import java.awt.*;
import java.awt.event.*;
public class pimc extends java.applet.Applet
 implements ActionListener{
  int  nt = 100, nt2=nt-2, np = 200, k = 1,  w, h, h2, h0, lbSize = 50;
  double x[], P[];
  long generTime;
  Button btNew;

public void init() {
  w = getSize().width;
  h = getSize().height - lbSize;  h2 = h/2; h0 = h2 + lbSize;
  x = new double[nt];
  for (int i = 0; i < nt; i++) x[i] = 0;
  P = new double[np];
  for (int i = 0; i < np; i++) P[i] = 0;
  String s=getParameter("k"); if (s != null) k = Integer.parseInt(s);
  btNew = new Button("Step");   btNew.addActionListener(this);
  add(btNew);
  mc();
}

public void mc(){
  int r;
  double dx, xnew, xr, ds;
  generTime = System.currentTimeMillis();
  for (int i = 0; i < 1000000; i++){
   r = (int)(nt*Math.random());
   if (r<1) r=1;
   if (r>nt2) r=nt2;
//   r=100;
   xr = x[r];
   dx = 5*(Math.random()-.5);
   xnew = xr + dx;
   ds = dx*(2*(xnew+xr-x[r+1]-x[r-1]) + xnew+xr );

   if ( (ds<0) || (Math.exp(-ds)<Math.random()) ) x[r] = xnew;
//System.out.println(""+r+"  "+x1);
   }
  generTime = System.currentTimeMillis()-generTime;
}

public void paint(Graphics g) {
  g.setColor(Color.white);   g.fillRect(0, 0, w, h+lbSize);
//  g.setColor(Color.black);   g.drawLine(0,h0 ,w,h0);
  int xt, x0=(int)(x[0]/10)+h0;
  g.setColor(Color.red);
  for (int t = 1; t < nt; t++){
    xt = (int)(x[t]/10) + h0;
    g.drawLine(3*(t-1),x0 ,3*t,xt);
    x0 = xt;}
  showStatus( "T=" + generTime );
}

public void actionPerformed(ActionEvent e){
  mc();
  repaint();
}

public void update(Graphics g){ paint(g); }
}
