#include "display.h"
#include <stdlib.h> // atod()
#include <stdio.h> // sprintf()
#include <string.h> // strrchr()
#include <float.h> // DBL_MAX_10_EXP

void display::equals ()
{
  g_print ("Do you really think I could do that?\n");
}

void display::ac ()
{
  no1 = no2 = 0.0;
  current_operator ='+';
  has_point = FALSE;
  set_value ( 0.0);
}

void display::set_text (char* text) 
{
  gtk_entry_set_text ( GTK_ENTRY (editbox), text);
}
  
char *display::get_text() 
{
  // is this a memory leak? do i have to free sth?
  return g_strdup ( gtk_entry_get_text ( GTK_ENTRY (editbox)));
}

void display::set_value (double d)
{
  char buf[255];
  sprintf(buf, "%.20g", d);
  set_text ( buf);
}

double display::get_value ()
{
  return ( atof ( get_text()));
}

void display::numeral (char* which)
{
  char* text = get_text ();
  char* pc2 = text;
  if ( need_new_number ) 
    {
      set_text ( which);
      has_point = ( which[0]=='.' ? TRUE : FALSE);
      need_new_number = FALSE;
      return;
    }
  if ( ( pc2 = strrchr ( text, 'e')) != NULL)
    {
      // exponent
      // extract the exponent int
      // only accept input if DBL_MAX_10_EXP is not exceeded
    }
  else
    { // non-exponent
      if ( which[0] == '.' && !has_point) {
	has_point = TRUE;
	gtk_entry_append_text ( GTK_ENTRY ( editbox), which);
      }
      else
	{
	  gtk_entry_append_text ( GTK_ENTRY ( editbox), which);
	  if ( which[0]!='0') set_value ( get_value ());
	}
    }
}

double display::calculate (double n1, double n2, char operat)
{
  switch ( operat)
    {
    case '+': return n1 + n2;
    case '-': return n1 - n2;
    case '*': return n1 * n2;
    case '/': return n1 / n2; // don't care div by zero - just shows `inf'
    }
}

void display::op (char* which)
{
  if ( need_new_number) return;

  if (no2 == 0.0)
    {
      no2 = get_value ();
      no1 = 0.0;
    }
  else
    {
      no1 = get_value ();
      no2 = calculate( no2, no1, current_operator);
      set_value ( no2);
    }
  need_new_number = TRUE;
  has_point = FALSE;
  current_operator = which[0];
};
