// display.h
// declaration of class display 

#include <gtk/gtk.h>

class display 
{
 private:
  
  GtkWidget *editbox; // the editbox we work on
  char current_operator; // holds +, -, * or /
  double no1, no2; // holds the two numbers the operators work on
  gboolean has_point; // whether we already have a decimal point
  gboolean need_new_number; 

  double calculate (double n1, double n2, char operat);

  // forbid copying and assignment by declaring both private
  display(const display&);
  display& operator= (const display&);

 public:
  display () : 
    editbox ( gtk_entry_new ()), 
    current_operator ( '+'), 
    no1 ( 0.0), 
    no2 ( 0.0),
    has_point ( FALSE),
    need_new_number ( FALSE)
    {
      gtk_entry_set_editable ( GTK_ENTRY (editbox), FALSE);
      set_value ( 0.0);
    };
  
  GtkWidget *get_editbox() 
    {
      return editbox;
    }
  
  char *get_text ();
  void set_text ( char*);  
  double get_value ();
  void set_value ( double);

  void equals (); // enter and =
  void op ( char*); // +-*/
  void numeral ( char*); // 0 through 9 and .
  void ac (); // clear state  
  ~display () {};
};
