#include <gtk/gtk.h>
#include <stdio.h> // sprintf()
#include <ctype.h> // is*()

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#define PACKAGE bcalc
#define VERSION misconfigured
#endif

#include "display.h"

display *thedisplay; 

/*  callback for OFF button */
void cb_OFF( GtkWidget *widget, gpointer data )
{
  gtk_main_quit();
}

/*  callback for equals */
void cb_equals( GtkWidget *widget, gpointer data )
{
  thedisplay->equals();
}

/*  callback for numerals */ 
void cb_numeral( GtkWidget *widget, gpointer data )
{
  thedisplay->numeral ( (char*) data);
}

/*  callback for operators +, -, * and / */
void cb_operator( GtkWidget *widget, gpointer data )
{
  thedisplay->op( (char*) data);
}

// callback for AC
void cb_AC( GtkWidget *widget, gpointer data )
{
  thedisplay->ac();
}

//  callback for key_press_event
gint cb_key_press( GtkWidget *widget, GdkEvent *event, gpointer data)
{
  GdkEventKey *myevent;

  if (event->type == GDK_KEY_PRESS) 
    {
      myevent = (GdkEventKey*) event;

      if ( isdigit (myevent->string[0]) || myevent->string[0] == '.') 
	{
	  thedisplay->numeral (myevent->string);
	} 

      // this is return grey and white
      // where are some defines for these magics?
      else if ( myevent->keyval == 65293 || 
		myevent->keyval == 65421 || 
		myevent->string[0] == '=')
	{
	  thedisplay->equals();
	}

      else 
	{
	  switch (myevent->string[0]) {
	  case '/':
	  case '-':
	  case '*':
	  case '+': 
	    {
	      thedisplay->op (myevent->string );
	    }
	  }
	}
      return(TRUE);
    }
  return(FALSE);
}

/*  callback for delete event */
gint delete_event( GtkWidget *widget,
		   GdkEvent  *event,
		   gpointer  *data )
{
  gtk_main_quit();
  return(TRUE); /* has event been handled? */
}

void makegui(GtkWidget * w)
{
  static char* names1[3][6] = {
    {"", "M", "sqrt", "log", "ln", "OFF"},
    {"a*b/c", " ' \"", "hyp", "sin", "cos", "tan"},
    {"", "ENG", "[(--", "--)]", "Min", "MR"} 
  };

  static char* supers1[3][6] = {
    {"SHIFT", "", "x", "10^x", "e^x", ""},
    {"d/c", "<-", "", "sin-", "cos-", "tan-"},
    {"v-", "<-", "X<>Y", "X<>M", "1/x", "x!"}
  };

    void (*funcs1[3][6])(GtkWidget *, gpointer) = { 
    {NULL, NULL, NULL, NULL, NULL, cb_OFF}, 
    {NULL, NULL, NULL, NULL, NULL, NULL}, 
    {NULL, NULL, NULL, NULL, NULL, NULL}
  };


  static char* names2[4][5] = {
    {"7", "8", "9", "C", "AC"},
    {"4", "5", "6", "*", "/"},
    {"1", "2", "3", "+", "-"},
    {"0", ".", "EXP", "=", "M+"}
  };

  static char* supers2[4][5] = {
    {"", "on", "on-", "", "SAC"},
    {"Ex", "Ex", "n", "x^y", "x^/y"},
    {"nPr", "nCr", "", "R->P", "P->R"},
    {"RND", "RAN#", "pi", "%", "M-"}
  };
  
  void (*funcs2[4][5]) (GtkWidget *, gpointer) = {
    {cb_numeral, cb_numeral, cb_numeral, NULL, cb_AC},
    {cb_numeral, cb_numeral, cb_numeral, cb_operator, cb_operator},
    {cb_numeral, cb_numeral, cb_numeral, cb_operator, cb_operator},
    {cb_numeral, cb_numeral, NULL, cb_equals, NULL}
  };
  GtkWidget *vbox; // for the great vbox
  GtkWidget *hbox; // for each row of buttons
  GtkWidget *smvbox; // for packing label and button
  GtkWidget *label;
  GtkWidget *button;
  int i,j;
  
  /* start building the CASIO fx-82 SUPER (costs 19.95 DM) */
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start (GTK_BOX(vbox), thedisplay->get_editbox(), TRUE, TRUE, 0);
  gtk_widget_show(thedisplay->get_editbox());
  /* the above part */
  for(i=0; i<3; ++i) {
    hbox = gtk_hbox_new(TRUE, 2);
    for (j=0; j<6; ++j) {
      smvbox = gtk_vbox_new(FALSE,0);
      label = gtk_label_new(supers1[i][j]);
      gtk_widget_set_sensitive ( GTK_WIDGET (label), FALSE);
      button = gtk_button_new_with_label(names1[i][j]);
      if ( funcs1[i][j] != NULL ) 
	{
	  gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(funcs1[i][j]), NULL);
	}
      else
	{
	  gtk_widget_set_sensitive ( GTK_WIDGET (button), FALSE);
	}
      gtk_box_pack_start (GTK_BOX(smvbox), label, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(smvbox), button, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(hbox), smvbox, TRUE, TRUE, 0);
      gtk_widget_show (button);
      gtk_widget_show (label);
      gtk_widget_show (smvbox);
    }
    gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
  }
  /* a separator */
  hbox = gtk_hseparator_new();
  gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, FALSE, 3);
  gtk_widget_show(hbox);
  /* the below part */
  for(i=0; i<4; ++i) {
    hbox = gtk_hbox_new(TRUE, 2);
    for (j=0; j<5; ++j) {
      smvbox = gtk_vbox_new(FALSE,0);
      label = gtk_label_new(supers2[i][j]);
      gtk_widget_set_sensitive ( GTK_WIDGET (label), FALSE);
      button = gtk_button_new_with_label(names2[i][j]);
      if ( funcs2[i][j] != NULL ) 
	{
	  gtk_signal_connect (GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(funcs2[i][j]), g_strdup(names2[i][j]));
	}
      else
	{
	  gtk_widget_set_sensitive ( GTK_WIDGET (button), FALSE);
	}
      gtk_box_pack_start (GTK_BOX(smvbox), label, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX(smvbox), button, FALSE, FALSE, 0);
      gtk_box_pack_start(GTK_BOX(hbox), smvbox, TRUE, TRUE, 0);
      gtk_widget_show(button);
      gtk_widget_show (label);
      gtk_widget_show (smvbox);
    }
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show(hbox);
  }
  gtk_container_add(GTK_CONTAINER(w), vbox);
  gtk_widget_show(vbox);
};

int main( int argc, char* argv[] )
{
  GtkWidget *editbox;
  GtkWidget *window;
  gchar title[80];
  
  gtk_init(&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  sprintf(title, "%s %s", PACKAGE, VERSION);
  gtk_window_set_title (GTK_WINDOW (window), title);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "key_press_event", GTK_SIGNAL_FUNC (cb_key_press), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 8);

  thedisplay = new display();
  
  makegui(window);
 
  gtk_widget_show (window);
  
  gtk_main ();
  
  return(0);
};








