/*  $Id$

    Designed and implemented by Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1994 University of Amsterdam. All rights reserved.
*/

#ifndef _CONSOLE_H_INCLUDED
#define _CONSOLE_H_INCLUDED

#ifndef _export
#ifdef _MAKE_DLL
#define _export _declspec(dllexport)
#else
#define _export extern
#endif
#endif

#include <signal.h>

#define RLC_APPTIMER_ID	100		/* >=100: application timer */

typedef struct
{ int	 	 first;
  int	 	 last;
  int	 	 size;			/* size of the buffer */
  unsigned char *buffer;		/* character buffer */
} rlc_queue, *RlcQueue;

typedef void	(*RlcUpdateHook)(void);	/* Graphics update hook */
typedef void	(*RlcTimerHook)(int);	/* Timer fireing hook */
typedef int	(*RlcRenderHook)(int);	/* Render one format */
typedef void	(*RlcRenderAllHook)(void); /* Render all formats */
typedef int	(*RlcMain)(int, char**); /* the main() function */
typedef void	(*RlcInterruptHook)(int); /* Hook for Control-C */
typedef void	(*RlcResizeHook)(int, int); /* Hook for window change */

#ifdef _WINDOWS_			/* <windows.h> is included */
					/* rlc_color(which, ...) */
#define RLC_WINDOW	  (0)		/* window background */
#define RLC_TEXT	  (1)		/* text color */
#define RLC_HIGHLIGHT	  (2)		/* selected text background */
#define RLC_HIGHLIGHTTEXT (3)		/* selected text */

_export HANDLE	rlc_hinstance(void);	/* hInstance of WinMain() */
_export HWND	rlc_hwnd(void);		/* HWND of console window */
_export int	rlc_main(HANDLE hI, HANDLE hPrevI,
			 LPSTR cmd, int show, RlcMain main, HICON icon);
_export void	rlc_icon(HICON icon);	/* Change icon of main window */
_export COLORREF rlc_color(int which, COLORREF color);
#endif /*_WINDOWS_*/

_export RlcUpdateHook	rlc_update_hook(RlcUpdateHook updatehook);
_export RlcTimerHook	rlc_timer_hook(RlcTimerHook timerhook);
_export RlcRenderHook   rlc_render_hook(RlcRenderHook renderhook);
_export RlcRenderAllHook rlc_render_all_hook(RlcRenderAllHook renderallhook);
_export RlcInterruptHook rlc_interrupt_hook(RlcInterruptHook interrupthook);
_export RlcResizeHook	rlc_resize_hook(RlcResizeHook resizehook);
_export int		rlc_copy_output_to_debug_output(int docopy);

_export void		rlc_title(char *title, char *old, int size);
_export void		rlc_dispatch(RlcQueue q);
_export void		rlc_check_intr(void);
_export RlcQueue	rlc_input_queue(void); /* libs stdin queue */
_export RlcQueue	rlc_make_queue(int size);
_export void		rlc_free_queue(RlcQueue q);
_export int		rlc_from_queue(RlcQueue q);
_export int		rlc_is_empty_queue(RlcQueue q);
_export void		rlc_empty_queue(RlcQueue q);
_export void		rlc_word_char(int chr, int isword);
_export int		rlc_iswin32s(void);	/* check for Win32S */

_export int		rlc_read(char *buf, int count);
_export int		rlc_write(char *buf, unsigned int count);

_export int		getch(void);
_export int		getche(void);
_export int		getkey(void);
_export int		kbhit(void);
_export void		ScreenInit(void);
_export void		ScreenGetCursor(int *row, int *col);
_export void		ScreenSetCursor(int row, int col);
_export int		ScreenCols(void);
_export int		ScreenRows(void);

#endif /* _CONSOLE_H_INCLUDED */
