//
//
//

#ifndef _RAD_TYPE_H_
#define _RAD_TYPE_H_

#pragma pack(1)
enum
{
RAD_STRING=1,
RAD_BOX,
RAD_RECT,
RAD_LINE,
RAD_CIRCLE,
RAD_PUSHBUTTON,
RAD_CHECKBUTTON,
RAD_POINTBUTTON,
RAD_EDITBOX1,
RAD_EDITBOX2,
RAD_EDITBOX3,
RAD_SLIDEBAR,
RAD_LISTBOX,
RAD_MENU,
RAD_FILLCIRCLE,
//RAD_PROGRESSBAR
};

typedef char RadType;

typedef struct
{
	int		key;
	char	*str;
	char	*name;
} AccKey;

typedef struct
{
	char	*name;
	int		value;
} WFLAG;

struct Accel
{
	RadType type;
	char flags;				// bit 0 is set for variable size of editbox
							// bit 1 is set for predefined keys
							// bit 2 is set for transparent
							// bit 3 is set for add to .RC
							// bit 5 is set for	range checking
	int x,y,w,h,ww,hh,
	key,
	ink,paper;
	union {
		int		min;
		double  mind;
	};
	union {
		int		max;
		double  maxd;
	};
	char name[MAXNAME+1], fnc[MAXVAR+1], variable[MAXVAR+1];
};

struct Flags
{
	int title,frame,modal,solid,nomove,menu,
	nopicto,clickable,focus,sizeable,uselast,
	statusbar,center;
};

struct Wind
{
	int 	typ,x,y,w,h,flags,ink,paper;
	int		current;				// -1 nor none
	char 	name[MAXNAME+1],fnc[MAXVAR+1];
	Accel	table[MAX_ACCEL];
	void 	*widget_ptr[MAX_WIDGETS];
	RadType widget_type[MAX_WIDGETS];
	int 	widgets;
	int		items;					// num of complete items in window
	Window	*form;					// ptr to each window
	int		isSelected;
};

class Projekt
{
	public:
		int		version, magic;
		Wind	Okno[MAX_WND];		// windows
		int		curr;				// index to current window
	// ---------------------------------
		Palette	paleta[256]; // vzdy 0 bajt je pouzita farba, a 1, 2 & 3 su RGB
		char	prjname[64];
		int		nwin;		// num of windows
		int		font;					// 0 default, else 1 .. 5
		int		video_mode, back_color;
		int		app_altx, app_cfg, app_magnify, app_wnd, app_root;
	// ---------------------------------
		int		Items(void) { return Okno[curr].items; }
		Wind	*wind(void) { return &Okno[curr]; }
		Accel	*accel(void) { return &Okno[curr].table[Okno[curr].items]; }
		Accel	*table(void) { return Okno[curr].table; }
		Window	*form(void) { return Okno[curr].form; }
		static  void proc(GuiEvent *);
		void	Redraw(Wind *);
		void	DrawAll(int f=0);
		Projekt();
		Projekt(char *);
		void Save(void)
		{
			FILE *fp=fopen(prjname,"wb");
			if (fp)
			{
				fwrite(this, sizeof(Projekt), 1, fp);
				fclose(fp);
			}
		}
		~Projekt();
		void Init(void);
		void PridajWidget(void);
		void DrawWidget(Wind *, int);
		void AddToWidgets(void *, RadType);
		void DeleteItem(void);
		void Update(void);  // update controls
		void Forward(void);
		void Backward(void);
		void Clone(void);
		void AddWindow(void);
		void DeleteWindow(void);
		void DuplicateWindow(void);
		void Up(void);
		void Down(void);
		int  ClickTest(int x, int y, Wind *w);
};

class XColors {
	public:
		Palette p;
		char   *s;
		XColors(Palette pp, char *ss)
		{
			p = pp;
			s = ss;
		}
};

#pragma pack()
#endif
