/*
    Copyright (C) 1996,99  Marian Krivos
	nezmar@internet.alcatel.sk
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    base.cc - base graphics support routines   

*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <stdarg.h>
#include <ctype.h>
#ifdef __DJGPP__
#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>
#include <sys/farptr.h>
#include <sys/nearptr.h>
#include <sys/segments.h>
#endif

#include "base.h"
#include "_fastgl.h"

int _CurrColor,_CurrBkColor;
int	clip_x_min,clip_y_min,clip_x_max,clip_y_max;
char *Image;
int	cx_max,cy_max;
int	X_max, Y_max;				// maximalne rozlisenie
int	lfb;	// non-zero if lfb is enabled
int granularity;
char *videobase; // offset VRAM in VideoSegment (non-zero in LINUX only)
unsigned videobasesegment=0xa000; // default 0xA000 for dos 64kb window
unsigned VideoSelector=0xFFFFFFFF; // selector for VRAM
unsigned VideoLinear=0; // linear address of mapped FRAMEBUFFER (dos only)
int	mmx_state=0, mmx=0;
int	driver=0;
int	fonth,fontw,fontn;
char *font;
int	ppop;
int	X_width, Y_width;
int	inGraph	= 0;
int	cx_work, cy_work, cx_maxwork, cy_maxwork;
static PolygonStruct ps;
char imagebuffer[16 * 32 * MAX_TEXT_LENGTH];
static int linear=0;
unsigned int _fgl_palette[256];

#ifdef __MSDOS__
static __dpmi_regs dpmir;
#endif

#ifdef __linux__
static int mode_tab[7]={TEXT, G320x200x256, G640x480x256, G800x600x256,	G1024x768x256, G1280x1024x256, G1600x1200x256};
#else
static int mode_tab[7]={3, 19, 0x101, 0x103, 0x105, 0x107, 0x120};
#endif

int	memorysize,vesaversion,framebuffer;

static const char *drv_name[FG_LAST]=
{"VESA", "CIRRUS LOGIC", "TRIDENT",
 "S3 OLD", "S3 NEW", "MX", "TSENG3000",	"ATI", "TSENG4000",
 "CHIPS & TECHNOLOGIES", "WESTERN DIGITAL", "BANSHEE", "SGS RIVA 128",
 "MATROX","PERMEDIA 2", "INTEL I740"};


#ifdef __WATCOMC__				// dpmi reduction to DJGPP interface ...
int	__dpmi_allocate_dos_memory(int _paragraphs,	int	*_ret_selector_or_max)
{
	union REGS reg;

	reg.w.ax = 0x100;
	reg.w.bx = _paragraphs;
	int386(0x31, &reg, &reg);
	if (reg.w.cflag	& 1)
		return -1;				// error

	*_ret_selector_or_max =	reg.w.dx;
	return reg.w.ax;
}

int	__dpmi_free_ldt_descriptor(unsigned sel)
{
	union REGS reg;

	reg.w.ax = 0x1;
	reg.w.bx = sel;
	int386(0x31, &reg, &reg);
	if (reg.w.cflag	& 1)
		return -1;				// error

	return 0;
}

#ifdef __MSDOS__
extern unsigned cdecl seg_overlay(void);
#pragma aux qnx_segment_overlay_flags "*_";

unsigned qnx_segment_overlay_flags(void)
{
	int val;
    val = seg_overlay();
	return val;
}
#endif
#endif

const	char *GetDriverName(void)
{
	if (lfb) return "Linear FrameBuffer";
	return drv_name[driver];
}

void Pixel(int x, int y)
{
	char *ptr;

	if (y <	cy_work	|| x < cx_work || y >= cy_maxwork || x >= cx_maxwork) return;
	switch (ppop)
	{
		case 0:
			*(Image	+ cx_max * y + x) =	_CurrColor;
			break;
		case 1:					// xor
			*(Image	+ cx_max * y + x) ^= _CurrColor;
			break;
		case 2:					// and
			*(Image	+ cx_max * y + x) &= _CurrColor;
			break;
		case 3:					// or
			*(Image	+ cx_max * y + x) |= _CurrColor;
			break;
		case 4:					// plus
			*(Image	+ cx_max * y + x) += _CurrColor;
			break;
		case 5:					// minus
			*(Image	+ cx_max * y + x) -= _CurrColor;
			break;
		case 6:					// not
			*(Image	+ cx_max * y + x) ^= 255;
			break;
		case 7:					// not
			ptr=(Image + cx_max *	y +	x);
			if (*ptr>=16) *ptr = _CurrColor;
			break;
	}
}

void Boxw(int x, int y,	int	w, int h)
{
	char *ptr;

	if (y <	0 || x < 0 || y	>= cy_max || x >= cx_max ||	w<1	|| h<1)
		return;
	if ((x + w)	> cx_max)
		w -= ((x + w) -	cx_max);
	if ((y + h)	> cy_max)
		h -= ((y + h) -	cy_max);
	ptr	= Image	+ cx_max * y + x;

	L1Box(ptr, w, h, cx_max	- w);
}

void Box(int x,	int y, int w, int h)
{
	char *ptr;

	if (y >= cy_maxwork || x >= cx_maxwork || w<1 || h<1 || (y + h) <= cy_work || (x + w) <= cx_work) return;

	if ((x + w) > cx_maxwork)
		w -= ((x + w) -	cx_maxwork);
	if ((y + h) > cy_maxwork)
		h -= ((y + h) -	cy_maxwork);
	if ((x + w) > cx_work && x < cx_work)
	{
		w = ((x	+ w) - cx_work);
		x = cx_work;
	}
	if ((y + h) > cy_work && y < cy_work)
	{
		h = ((y	+ h) - cy_work);
		y = cy_work;
	}
	ptr = Image + cx_max * y + x;
	L1BoxX(ptr, w, h, cx_max - w);
}

static void	_symetry(int xs, int ys, int x,	int	y)
{
	Pixel(xs + x, ys + y);
	Pixel(xs - x, ys + y);
	Pixel(xs + x, ys - y);
	Pixel(xs - x, ys - y);
	Pixel(xs + y, ys + x);
	Pixel(xs - y, ys + x);
	Pixel(xs + y, ys - x);
	Pixel(xs - y, ys - x);
}

static void	_symetry2(int xs, int ys, int x, int y)
{
	Line(xs+x,ys+y,xs-x,ys+y);
	Line(xs+x,ys-y,xs-x,ys-y);
	Line(xs+y,ys+x,xs-y,ys+x);
	Line(xs+y,ys-x,xs-y,ys-x);
}

void FillCircle(int	xs,	int	ys,	int	r)
{
	int	x =	0;
	int	y =	r;
	int	p =	3 -	2 *	r;

	if ((ys	+ r) < cy_work || (xs +	r) < cx_work ||	(ys	- r) >=	cy_maxwork || (xs -	r) >= cx_maxwork ||	r <	1)
		return;
	while (x < y)
	{
		_symetry2(xs, ys, x, y);
		if (p <	0)
			p += 4 * (x++) + 6;
		else
			p += 4 * ((x++)	- (y--)) + 10;
	}
	if (x == y)	_symetry2(xs, ys, x, y);
}

void DrawCircle(int	xs,	int	ys,	int	r)
{
	int	x =	0;
	int	y =	r;
	int	p =	3 -	2 *	r;

	if ((ys	+ r) < cy_work || (xs +	r) < cx_work ||	(ys	- r) >=	cy_maxwork || (xs -	r) >= cx_maxwork ||	r <	1)
		return;
	while (x < y)
	{
		_symetry(xs, ys, x,	y);
		if (p <	0)
			p += 4 * (x++) + 6;
		else
			p += 4 * ((x++)	- (y--)) + 10;
	}
	if (x == y)
		_symetry(xs, ys, x,	y);
}

static void	_vsymetry2(int xs, int ys, int x, int y)
{
	draw_line(xs+x,ys+y,xs-x,ys+y);
	draw_line(xs+x,ys-y,xs-x,ys-y);
	draw_line(xs+y,ys+x,xs-y,ys+x);
	draw_line(xs+y,ys-x,xs-y,ys-x);
}

void fill_circle(int xs, int ys, int r)
{
	int	x =	0;
	int	y =	r;
	int	p =	3 -	2 *	r;

	if ((ys	+ r) < clip_y_min || (xs + r) <	clip_x_min || (ys -	r) >= clip_y_max ||	(xs	- r) >=	clip_x_max || r<1)
		return;

	while (x < y)
	{
		_vsymetry2(xs, ys, x, y);
		if (p <	0)
			p += 4 * (x++) + 6;
		else
			p += 4 * ((x++)	- (y--)) + 10;
	}
	if (x == y)
		_vsymetry2(xs, ys, x, y);
}

static void	_vsymetry(int xs, int ys, int x, int y)
{
	draw_point(xs +	x, ys +	y);
	draw_point(xs -	x, ys +	y);
	draw_point(xs +	x, ys -	y);
	draw_point(xs -	x, ys -	y);
	draw_point(xs +	y, ys +	x);
	draw_point(xs -	y, ys +	x);
	draw_point(xs +	y, ys -	x);
	draw_point(xs -	y, ys -	x);
}

void draw_circle(int xs, int ys, int r)
{
	int	x =	0;
	int	y =	r;
	int	p =	3 -	2 *	r;

	if ((ys	+ r) < clip_y_min || (xs + r) <	clip_x_min || (ys -	r) >= clip_y_max ||	(xs	- r) >=	clip_x_max || r<1)
		return;

	while (x < y)
	{
		_vsymetry(xs, ys, x, y);
		if (p <	0)
			p += 4 * (x++) + 6;
		else
			p += 4 * ((x++)	- (y--)) + 10;
	}
	if (x == y)
		_vsymetry(xs, ys, x, y);
}

void Vline(int x, int y, int c)
{
	char *ptr;
	int	i;

	if (y <	0 || x < 0 || y	>= cy_max || x >= cx_max ||	c<1)
		return;
	if ((y + c)	> cy_max)
		c -= ((y + c) -	cy_max);
	ptr	= Image	+ cx_max * y + x;

	for	(i = c;	i; i--)
	{
		*ptr = _CurrColor;
		ptr	+= cx_max;
	}
}

void Hline(int x, int y, int c)
{
	char *ptr;
	int	j;

	if (y <	0 || x < 0 || y	>= cy_max || x >= cx_max ||	c<1)
		return;
	if ((x + c)	> cx_max)
		c -= ((x + c) -	cx_max);
	ptr	= Image	+ cx_max * y + x;

	switch(ppop)
	{
		default:
		case 0:	 // set
			memset(ptr,	_CurrColor,	c);
			break;
		case 1:	 // xor
			for	(j = c;	j; j--)
			{
				*ptr++ ^= _CurrColor;
			}
			break;
		case 2:	 // and
			for	(j = c;	j; j--)
			{
				*ptr++ &= _CurrColor;
			}
			break;
		case 3:	 // or
			for	(j = c;	j; j--)
			{
				*ptr++ |= _CurrColor;
			}
			break;
		case 4:	 // plus
			for	(j = c;	j; j--)
			{
				*ptr++ += _CurrColor;
			}
			break;
		case 5:	 // minus
			for	(j = c;	j; j--)
			{
				*ptr++ -= _CurrColor;
			}
			break;
		case 6:	 // not
			for	(j = c;	j; j--)
			{
				*ptr++ ^= 255;
			}
			break;
		case 7:	 // replace
			for	(j = c;	j; j--)
			{
				if (*(ptr) >= 16) *ptr = _CurrColor;
				ptr++;
			}
			break;
	}
}

void Rectw(int x, int y, int w,	int	h)
{
	Hline(x, y,	w);
	Hline(x, y + h - 1,	w);
	Vline(x, y,	h);
	Vline(x	+ w	- 1, y,	h);
}

void Rect(int x, int y,	int	w, int h)
{
	Line(x,y,x+w-1,y);
	Line(x,y,x,y+h-1);
	Line(x,y+h-1,x+w-1,y+h-1);
	Line(x+w-1,y,x+w-1,y+h-1);
}

void RamToVideo(int	x, int y, int xm, int ym, int w, int h)
{
	char *src, *dst;

	if (y <	0 || x < 0 || y	>= cy_max || x >= cx_max ||	w<1	|| h<1)
		return;
	if ((ym	+ h) < clip_y_min || (xm + w) <	clip_x_min || ym >=	clip_y_max || xm >=	clip_x_max)
		return;
	if ((x + w)	> cx_max)
		w -= ((x + w) -	cx_max);
	if ((y + h)	> cy_max)
		h -= ((y + h) -	cy_max);

	if ((xm	+ w) > clip_x_max)
		w -= ((xm +	w) - clip_x_max);
	else if	(xm	< clip_x_min)
	{
		w += (xm - clip_x_min);
		x += clip_x_min	- xm;
		xm = clip_x_min;
	}
	if ((ym	+ h) > clip_y_max)
		h -= ((ym +	h) - clip_y_max);
	else if	(ym	< clip_y_min)
	{
		h += (ym - clip_y_min);
		y += clip_y_min	- ym;
		ym = clip_y_min;
	}

	if (w<1 || h<1) return;
	src	= Image	+ y	* cx_max + x;
	dst	= (char	*) (ym * X_width + xm +	videobase);
	if (!videobase || !lfb) L1RamToVideo8(src, dst, w, h,	cx_max - w,	X_width	- w);
	else L1RamToRam(src, dst, w, h,	X_width	- w, cx_max	- w);
}

void RamToVideo2(int x,	int	y, int xm, int ym, int w, int h)
{
	char *src, *dst;

	if (y <	0 || x < 0 || y	>= cy_max || x >= cx_max ||	w<1	|| h<1)
		return;
	if ((ym	+ h) < clip_y_min || (xm + w) <	clip_x_min || ym >=	clip_y_max || xm >=	clip_x_max)
		return;
	if ((x + w)	> cx_max)
		w -= ((x + w) -	cx_max);
	if ((y + h)	> cy_max)
		h -= ((y + h) -	cy_max);

	if ((xm	+ w) > clip_x_max)
		w -= ((xm +	w) - clip_x_max);
	else if	(xm	< clip_x_min)
	{
		w += (xm - clip_x_min);
		x += clip_x_min	- xm;
		xm = clip_x_min;
	}
	if ((ym	+ h) > clip_y_max)
		h -= ((ym +	h) - clip_y_max);
	else if	(ym	< clip_y_min)
	{
		h += (ym - clip_y_min);
		y += clip_y_min	- ym;
		ym = clip_y_min;
	}
	if (w<1 || h<1) return;
	src	= Image	+ y	* cx_max + x;
	dst	= (char	*) (ym * X_width + xm +	videobase);
	if (!videobase || !lfb) L1RamToVideo2(src, dst, w, h,	cx_max - w,	X_width	- w);
	else L1RamToRamPpop(src, dst, w, h,	X_width	- w, cx_max	- w);
}

void VideoToRam(int	x, int y, int xm, int ym, int w, int h)
{
	char *src, *dst;

	if ((y + h)	< clip_y_min ||	(x + w)	< clip_x_min ||	y >= clip_y_max	|| x >=	clip_x_max || w<1 || h<1)
		return;
	if (ym < 0 || xm < 0 ||	ym >= cy_max ||	xm >= cx_max)
		return;

	if ((x + w)	> clip_x_max)
		w -= ((x + w) -	clip_x_max);
	else if	(x < clip_x_min)
	{
		w += (x	- clip_x_min);
		xm += clip_x_min - x;
		x =	clip_x_min;
	}
	if ((y + h)	> clip_y_max)
		h -= ((y + h) -	clip_y_max);
	else if	(y < clip_y_min)
	{
		h += (y	- clip_y_min);
		ym += clip_y_min - y;
		y =	clip_y_min;
	}

	if ((xm	+ w) > cx_max)
		w -= ((xm +	w) - cx_max);
	if ((ym	+ h) > cy_max)
		h -= ((ym +	h) - cy_max);

	if (w<1 || h<1) return;
	dst	= Image	+ ym * cx_max +	xm;
	src	= (char	*) (y *	X_width	+ x	+ videobase);
	if (!videobase || !lfb) L1VideoToRam8(src, dst, w, h,	cx_max - w,	X_width	- w);
	else L1RamToRam(src, dst, w, h,	cx_max - w,	X_width	- w);
}

void RamToRam(int x, int y,	int	xmax, int ymax,	int	xdst, int ydst,	int	xmaxdst, int ymaxdst, int w, int h,	char *from,	char *to)
{
	char *src, *dst;

	if (y <	0 || x < 0 || y	>= ymax	|| x >=	xmax ||	w<1	|| h<1)
		return;
	if (ydst < 0 ||	xdst < 0 ||	ydst >=	ymaxdst	|| xdst	>= xmaxdst)
		return;
	if ((x + w)	> xmax)
		w -= ((x + w) -	xmax);
	if ((y + h)	> ymax)
		h -= ((y + h) -	ymax);
	if ((xdst +	w) > xmaxdst)
		w -= ((xdst	+ w) - xmaxdst);
	if ((ydst +	h) > ymaxdst)
		h -= ((ydst	+ h) - ymaxdst);

	if (w<1 || h<1) return;
	dst	= to + ydst	* xmaxdst +	xdst;
	src	= from + y * xmax +	x;
	if (ppop!=_GTRANSP) L1RamToRam(src,	dst, w,	h, xmaxdst - w,	xmax - w);
	else L1RamToRamPpop(src, dst, w, h, xmaxdst - w, xmax - w);
}

void RamToRamd(int x, int y, int xmax, int ymax, int xdst, int ydst, int xmaxdst, int ymaxdst, int w, int h, char *from, char *to)
{
	char *src, *dst;

	if (y <	0 || x < 0 || y	>= ymax	|| x >=	xmax ||	w<1	|| h<1)
		return;
	if (ydst < 0 ||	xdst < 0 ||	ydst >=	ymaxdst	|| xdst	>= xmaxdst)
		return;
	if ((x + w)	> xmax)
		w -= ((x + w) -	xmax);
	if ((y + h)	> ymax)
		h -= ((y + h) -	ymax);
	if ((xdst +	w) > xmaxdst)
		w -= ((xdst	+ w) - xmaxdst);
	if ((ydst +	h) > ymaxdst)
		h -= ((ydst	+ h) - ymaxdst);

	if (w<1 || h<1) return;
	dst	= to + (ydst + h - 1) *	xmaxdst	+ xdst;
	src	= from + (y	+ h	- 1) * xmax	+ x;
	L1RamToRam(src,	dst, w,	h, -(xmaxdst + w), -(xmax +	w));
}

void text_to_buffer(int	x, int y, char *s, int xsize, int ysize, char *buf)
{
	int	width =	strlen(s) *	fontw;

	if ((y + fonth)	< 0	|| (x +	width) < 0 || y	>= ysize ||	x >= xsize)
		return;
	if (width >	(MAX_TEXT_LENGTH * fontw))
	{
		s[MAX_TEXT_LENGTH] = 0;
		width =	MAX_TEXT_LENGTH	* fontw;
	}
#ifndef	__WATCOMC__
	set_mmx();
#endif
	buf	+= y*xsize+x;
	while (*s)
	{
		CharOutClip(buf, (char *) (*s++	* (fontw * fonth) +	font),xsize);
		buf	+= fontw;
	}
#ifndef	__WATCOMC__
	reset_mmx();
#endif	
}

void Textw(int x, int y, char *s)
{
	char *dst;
	int	width =	strlen(s) *	fontw;

	if ((y + fonth)	< 0	|| (x +	width) < 0 || y	>= cy_max || x >= cx_max)
		return;
	if (width >	(MAX_TEXT_LENGTH * fontw))
	{
		s[MAX_TEXT_LENGTH] = 0;
		width =	MAX_TEXT_LENGTH	* fontw;
	}
	dst	= imagebuffer;
#ifndef	__WATCOMC__
	set_mmx();
#endif
	while (*s)
	{
		CharOutClip(dst, (char *) (*s++	* (fontw * fonth) +	font), MAX_TEXT_LENGTH*fontw);
		dst	+= fontw;
	}
#ifndef	__WATCOMC__
	reset_mmx();
#endif
	RamToRam(0,	0, MAX_TEXT_LENGTH * fontw,	fonth, x, y, cx_max, cy_max, width,	fonth, imagebuffer,	Image);
}

void Text(int x, int y,	char *s)
{
	char *dst;
	int tc;
	int	w =	strlen(s) *	fontw, h = fonth, hh = h, ww=w;

	if ((y + fonth)	< 0	|| (x +	w) < 0 || y	>= cy_max || x >= cx_max)
		return;
	if (w >	(MAX_TEXT_LENGTH * fontw))
	{
		s[MAX_TEXT_LENGTH] = 0;
		w =	MAX_TEXT_LENGTH	* fontw;
	}
	if (w <= 0)
		return;
#ifndef	__WATCOMC__
	set_mmx();
#endif
	dst	= imagebuffer;
	tc = get_bcolor();
	if (ppop == _GTRANSP)
	{
		set_bcolor(0);
	}
	while (*s)
	{
		CharOutClip(dst, (char *) (*s++	* (fontw * fonth) +	font), MAX_TEXT_LENGTH*fontw);
		dst	+= fontw;
	}
	set_bcolor(tc);
#ifndef	__WATCOMC__
	reset_mmx();
#endif
	if (y >= cy_maxwork	|| x >=	cx_maxwork)
		return;
	if ((y + h)	<= cy_work || (x + w) <= cx_work)
		return;

	if ((x + w) > cx_maxwork)
		ww = (w -= ((x + w) - cx_maxwork));
	if ((y + h) > cy_maxwork)
		hh = (h -= ((y + h) - cy_maxwork));

	if ((x + w) > cx_work && x < cx_work)
	{
		w = ((x + w) -	cx_work);
		x = cx_work;
	}
	if ((y + h) > cy_work && y < cy_work)
	{
		h = ((y + h) -	cy_work);
		y = cy_work;
	}

	if (w<1 || h<1) return;
	dst	= Image	+ cx_max * y + x;
	L1RamToRamPpop(imagebuffer+(MAX_TEXT_LENGTH * fontw * (hh-h))+(ww-w), dst, w, h, cx_max - w, MAX_TEXT_LENGTH * fontw - w);
}

int	text_out(int x,	int	y, char	*s)
{
	char *dst, *pom;
	int tc;
	int	a =	cx_max,	b =	cy_max;
	int	width =	strlen(s) *	fontw;

	if ((y + fonth)	< clip_y_min ||	(x + width)	< clip_x_min ||	y >= clip_y_max	|| x >=	clip_x_max)
		return x;
	if (width >	(MAX_TEXT_LENGTH * fontw))
	{
		s[MAX_TEXT_LENGTH] = 0;
		width =	MAX_TEXT_LENGTH	* fontw;
	}
#ifndef	__WATCOMC__
	set_mmx();
#endif	
	dst	= imagebuffer;
	pom	= Image;
	cx_max = MAX_TEXT_LENGTH * fontw;
	cy_max = fonth;
	Image =	imagebuffer;

	tc = get_bcolor();
	if (ppop == _GTRANSP)
	{
		set_bcolor(0);
	}

	while (*s)
	{
		CharOutClip(dst, (char *) (*s++	* (fontw * fonth) +	font), MAX_TEXT_LENGTH*fontw);
		dst	+= fontw;
	}
	set_bcolor(tc);
#ifndef	__WATCOMC__
	reset_mmx();
#endif	
	RamToVideo2(0, 0, x, y,	width, fonth);
	Image =	pom;
	cx_max = a;
	cy_max = b;
	return x + width;
}

void fill_box(int x, int y, int w, int h)
{
	if ((y + h)	< clip_y_min ||	(x + w)	< clip_x_min ||	y >= clip_y_max	|| x >=	clip_x_max || w<1 || h<1)
		return;
	if ((x + w)	> clip_x_max)
		w -= ((x + w) -	clip_x_max);
	if ((y + h)	> clip_y_max)
		h -= ((y + h) -	clip_y_max);
	if (x <	clip_x_min)
	{
		w += (x	- clip_x_min);
		x =	clip_x_min;
	}
	if (y <	clip_y_min)
	{
		h += (y	- clip_y_min);
		y =	clip_y_min;
	}
	if (w<1	|| h<1)	return;
	_fill_rect(x, y, w,	h);
}

void draw_box(int x, int y, int w, int h)
{
	draw_line(x, y,	x +	w -	1, y);
	draw_line(x, y + h - 1,	x +	w -	1, y + h - 1);
	draw_line(x, y,	x, y + h - 1);
	draw_line(x	+ w	- 1, y,	x +	w -	1, y + h - 1);
}

void set_clip_rect(int w, int h, int x,	int	y)
{
	clip_x_min = x;
	clip_y_min = y;
	if (clip_x_max < 0)
		clip_x_min = 0;
	if (clip_y_max < 0)
		clip_y_min = 0;
	clip_x_max = x + w;
	clip_y_max = y + h;
	if (clip_x_max > X_width)
		clip_x_max = X_width;
	if (clip_y_max > Y_width)
		clip_y_max = Y_width;

// for polygon routines
	ps.gc_xoffset =	0;
	ps.gc_yoffset =	0;
	ps.gc_xcliplo =	clip_x_min;
	ps.gc_ycliplo =	clip_y_min;
	ps.gc_xcliphi =	clip_x_max-1;
	ps.gc_ycliphi =	clip_y_max-1;

	ps.line	= draw_line;
	ps.scan	= draw_hline;
}

void __palette(unsigned col, unsigned rgb)
{
	outp((unsigned short)0x3c8,	(unsigned char)col);
	outp(0x3c9,	rgb	>> 16);
	outp(0x3c9,	rgb	>> 8);
	outp(0x3c9,	rgb);
}

void _palette(unsigned col,	unsigned rgb)
{
	__palette(col, rgb);
	_fgl_palette[col]=rgb&0x3F3F3F;
}

unsigned int get_palette(unsigned int i)
{
	return _fgl_palette[i]&0x3F3F3F;
}

void set_fcolor(unsigned int c)
{
	_CurrColor = c;
}

void set_bcolor(unsigned int c)
{
	_CurrBkColor = c;
}

int	get_fcolor(void)
{
	return _CurrColor;
}

int	get_bcolor(void)
{
	return _CurrBkColor;
}

void set_colors(unsigned int f,	unsigned int b)
{
	set_fcolor(f);
	set_bcolor(b);
}

void put_block(int x, int y, int w,	int	h, void	*p)
{
	int	a =	cx_max,	b =	cy_max;
	char *ptr =	Image;

	cx_max = w;
	cy_max = h;
	Image =	(char *)p;
	if (ppop==_GSET) RamToVideo(0, 0, x, y,	w, h);
	else RamToVideo2(0,	0, x, y, w,	h);
	cx_max = a;
	cy_max = b;
	Image =	ptr;
}

void get_block(int x, int y, int w,	int	h, void	*p)
{
	int	a =	cx_max,	b =	cy_max;
	char *ptr =	Image;

	cx_max = w;
	cy_max = h;
	Image =	(char *)p;
	VideoToRam(x, y, 0,	0, w, h);
	cx_max = a;
	cy_max = b;
	Image =	ptr;
}

unsigned int areasize(int x, int y)
{
	return x * y;
}

void clear_frame_buffer(unsigned int color)
{
	set_fcolor(color);
	set_ppop(_GSET);
	fill_box(0, 0, X_width, Y_width);
}

void set_linear(int	flag)
{
	linear =flag;
}

#ifdef __DJGPP__
/* memory access helper functions */
static int map_linear(unsigned long	adr, unsigned long len,
			  unsigned *sel, unsigned *la	)
{
  if(*sel==0xFFFFFFFF) {
	*sel = __dpmi_allocate_ldt_descriptors(1);
	if (*sel==0xFFFFFFFF)	return 0;
  }
  if(!*la) {
	__dpmi_meminfo meminfo;
	meminfo.address	= adr;
	meminfo.size	= len;
	if(__dpmi_physical_address_mapping(&meminfo)==-1) {
	   return 0;
	}
	if(__dpmi_set_segment_base_address(*sel,meminfo.address)==-1) {
	   return 0;
	}
	if(__dpmi_set_segment_limit(*sel,len-1)==-1) {
	   return 0;
	}
	*la=meminfo.address;
  }
  return 1;
}

static void	free_linear(unsigned *sel, unsigned	*la)
{
  if(*la) {
	  __dpmi_meminfo meminfo;
	  meminfo.address =	*(unsigned *)la;
	  __dpmi_free_physical_address_mapping(&meminfo);
	  *la =	0;
  }
  if(*sel != 0xFFFFFFFF)	{
	  __dpmi_free_ldt_descriptor(*sel);
	  *sel = 0xFFFFFFFF;
  }
}
#endif

static int exit_flag=0;
static int firsttime = 1;

//
// only for backing to previous console mode
//
void cleanup(void)
{
	if (exit_flag) return;
	exit_flag = 1;
	CloseUserInput();
	if (inGraph) graph_set_mode(0);
#ifdef __linux__
	if (svgalib) UnlinkSvgalib();
	svgalib = 0;
#endif
	exit_flag = 0;
	firsttime = 1;
}

void GetModeSize(int mode, int * m)
{
	switch (mode)
	{
		case G320x200:
			*m =	mode_tab[mode];
			X_width	= 320;
			Y_width	= 200;
			break;
		case G640x480:
			*m =	mode_tab[mode];
			X_width	= 640;
			Y_width	= 480;
			break;
		case G800x600:
			*m =	mode_tab[mode];
			X_width	= 800;
			Y_width	= 600;
			break;
		case G1024x768:
			*m =	mode_tab[mode];
			X_width	= 1024;
			Y_width	= 768;
			break;
		case G1280x1024:
			*m =	mode_tab[mode];
			X_width	= 1280;
			Y_width	= 1024;
			break;
		case G1600x1200:
			*m =	mode_tab[mode];
			X_width	= 1600;
			Y_width	= 1200;
			break;
		default:
			*m = 0;
			break;
	}
}

void _set_default_palette(void)
{
	int i;
	for (i=0; i<256; i++) _palette(i,_default_palette[i]);
	memmove(_fgl_palette, _default_palette, sizeof(_fgl_palette));
}

void _set_fgl_palette(void)
{
	int i;
	for (i=0; i<256; i++) _palette(i,_fgl_palette[i]);
}

int	graph_set_mode(int mode)
{
	int	m=1;

	if (mode == 0)
	{
		_set_default_palette();
#ifndef	__linux__
#ifdef __MSDOS__
#ifndef __WATCOMC__
		if (VideoLinear)  free_linear(&VideoSelector, &VideoLinear);
#endif
#endif
		_setvideomode(3);
#ifdef __MSDOS__
		if (VideoSelector!=0xFFFFFFFF)
			__dpmi_free_ldt_descriptor(VideoSelector);
		VideoSelector = 0xFFFFFFFF;
#endif
#else
		LinuxGraphClose();
#endif
		inGraph	= 0;
		return 1;
	}

	if (firsttime)
	{
		VideoSelector = 0xFFFFFFFF;
		VideoLinear = 0;
#ifdef __linux__
		if ((mode=LinuxStartup(mode)) == 0) return 0;
#else  
		if (driver < 0)
			driver = 0;			// no detect, force VESA
		else if	(driver	== 0)
			driver = detect_video(verbose);	// detect card
#endif	// linux		
#ifndef __WATCOMC__
		if (mmx < 0) mmx = 0;
		else test_mmx();
#endif		
	}
	m = mode_tab[mode];
#ifdef __MSDOS__
	if (mode >=	2)				// VESA paging ?
	{
		int	tmp;
		dpmir.x.ax = 0x4f00;
		dpmir.x.di = 0;
		dpmir.x.es = __dpmi_allocate_dos_memory(512	/ 16, &tmp);
		poke(tmp, 0, '2' * 0xffffff	+ 'E' *	65536 +	'B'	* 256 +	'V');
		__dpmi_int(16, &dpmir);
		if (dpmir.x.ax != 0x004F)
			IErrorText("Sorry, your card not support VESA standard!", 1);
		memorysize = (peek(tmp,	0x12) &	0xffff)	* 64;
		for(;;mode--) // find best mode
		{
			dpmir.x.cx = m = mode_tab[mode];
			dpmir.x.ax = 0x4f01;
			dpmir.x.di = 0;
			__dpmi_int(16, &dpmir);
			if (dpmir.x.ax != 0x004F && mode<=0)
				IErrorText("Sorry, your card not support this VESA mode !",	m);
			if (dpmir.x.ax == 0x004F) break;
			printf("Trying other mode than %d\n", mode);
		}
		if ((peek(tmp, 6) &	0xffff)	< 64)
			IErrorText("Sorry, your card not support 64 KB Window !", 1);
		videobasesegment = peek(tmp, 8)	& 0xffff;
		lfb	= (peek(tmp, 0)	& 0xffff)&128;
		granularity	= peek(tmp,	4) & 255;
		framebuffer	= peek(tmp,	0x28);
		lfb=0;
#ifndef __WATCOMC__
		if (lfb	&& framebuffer)
		{
			map_linear(framebuffer,	memorysize*1024, &VideoSelector, &VideoLinear);
			if (!(VideoSelector != 0xFFFFFFFF && VideoLinear)) linear = lfb = 0;
			videobase = 0;
		}
#endif
	}
#endif // msdos	
#ifdef __QNX__
	videobasesegment = 0xa000U;
	memorysize = 2048;
	lfb	= 0;
	granularity	= 64;
#endif
#ifdef __linux__
	memorysize = LinuxMemSize(m);
#endif
	if (memorysize <= 512 && mode >	2)
		mode = 2;
	if (memorysize <= 1024 && mode > 4)
		mode = 4;
	GetModeSize(mode, &m);
	if (!m) return 0; // bad mode
	if (firsttime)
	{
		atexit(cleanup);
		firsttime =	0;
	}
#ifndef	__linux__
	if (lfb || mode<2) driver = 0; // no banking
	if (_setvideomode(m) ==	0) return 0;
#else	
	if (LinuxSetMode(m,mode,linear)==0) return 0;
#endif
	inGraph	= m;
	X_max =	X_width	- 1;
	Y_max =	Y_width	- 1;
	set_clip_rect(X_width, Y_width,	0, 0);
	set_font(FONT0816);
	set_colors(0, 15);
	set_ppop(_GSET);
	_set_default_palette();
	return 1;
}

void set_palet(int cnt,	int	ind, int *pal)
{
	unsigned int color,	x =	0;

	for	(; cnt;	cnt--)
	{
		color =	(unsigned int) pal[x++];
		_palette(ind++,	color);
	}
}

int	set_font(int f)
{
	int	rc = fontn;

	switch (fontn =	f)
	{
		default:
		case FONT0406:
			font = miro0406x-(6*4*' ');
			fontw =	4;
			fonth =	6;
			break;
		case FONT0808:
			font = miro0808x;
			fontw =	8;
			fonth =	8;
			break;
		case FONT0816:
			font = miro0816x;
			fontw =	8;
			fonth =	16;
			break;
		case FONT1222:
			font = miro1220x-(12*20*' ');
			fontw =	12;
			fonth =	20;
			break;
		case FONT1625:
			font = miro1625x-(16*25*' ');
			fontw =	16;
			fonth =	25;
			break;
	}
	return rc;
}

#ifndef __linux__
void Snd(int a,	int	b)
{
	sound(a);
	delay(b);
	nosound();
}
#endif

void Puk(void)
{
	Snd(100,10);
}

void XWaitRetrace(void)
{
/* some prob here I'll fix it later */
	while ((inp(0x3da) & 0x08) != 0);
	while ((inp(0x3da) & 0x08) == 0);
}

void XWaitPeriod(void)
{
	while ((inp(0x3da) & 0x08) == 0);
	while ((inp(0x3da) & 0x08) != 0);
}

void WarningBeep(int which)
{
	switch (which)
	{
		default:
		case 0:
			Snd(1000, 100);
			break;
	}
}

void IErrorText(char *s, int flag)
{
	WarningBeep(0);
	if (flag)
	{
		printf("FATAL ERROR: %s\n",	s);
		getchar();
		exit(flag);
	}
	else
	{
		printf("WARNING: %s\n",	s);
		getchar();
	}
}

//
// A traditional printf in window form + position
//

int	gprintf(int	x, int y, const	char *format,...)
{
	char s[256];

	va_list	arglist;

	va_start(arglist, format);
	vsprintf(s,	format,	arglist);
	va_end(arglist);
	text_out(x,y,s);
	return strlen(s);
}

/**
 ** SCANCNVX.C ---- scan fill a convex polygon
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

void _FillPolygon(int n,	int	pt[][2], PolygonStruct * current)
{
	edge *edges, *ep;
	scan *scans, *sp, *points, *segments;
	int	xmin, xmax,	ymin, ymax;
	int	ypos, nedges;

	if ((n > 1)	&&
		(pt[0][0] == pt[n -	1][0]) &&
		(pt[0][1] == pt[n -	1][1]))
	{
		n--;
	}
	if (n <	1)
	{
		return;
	}
#ifdef __DJGPP__
	edges =	(edge *) __builtin_alloca(sizeof(edge) * (n	+ 2));
	scans =	(scan *) __builtin_alloca(sizeof(scan) * (n	+ 8));
#else
	edges =	(edge *) malloc(sizeof(edge) * (n +	2));
	scans =	(scan *) malloc(sizeof(scan) * (n +	8));
#endif	
	if (edges && scans)
	{
		int	prevx =	xmin = xmax	= pt[0][0];
		int	prevy =	ymin = ymax	= pt[0][1];

		nedges = 0;
		ep = edges;
		while (--n >= 0)
		{
			if (pt[n][1] >=	prevy)
			{
				ep->e.x	= prevx;
				ep->e.y	= prevy;
				ep->e.xlast	= prevx	= pt[n][0];
				ep->e.ylast	= prevy	= pt[n][1];
			}
			else
			{
				ep->e.xlast	= prevx;
				ep->e.ylast	= prevy;
				ep->e.x	= prevx	= pt[n][0];
				ep->e.y	= prevy	= pt[n][1];
			}
			if ((ep->e.y > (current->gc_ycliphi)) || (ep->e.ylast <	(current->gc_ycliplo)))
				continue;
			{
				if (ep->e.y	< current->gc_ycliplo)
				{
					ep->e.x	+= (((int) (((long)	(((int)	((ep->e.xlast -	ep->e.x)) << 1)) * (long) ((current->gc_ycliplo	- ep->e.y))) / (long) ((ep->e.ylast	- ep->e.y))) + (((int) ((ep->e.xlast - ep->e.x)) ^ (int) ((current->gc_ycliplo - ep->e.y)) ^ (int) ((ep->e.ylast - ep->e.y))) >> ((sizeof(int) * 8)	- 1)) +	1) >> 1);

					ep->e.y	= current->gc_ycliplo;;
				}
			};
			if (ymin > ep->e.y)
				ymin = ep->e.y;
			if (ymax < ep->e.ylast)
				ymax = ep->e.ylast;
			if (xmin > ep->e.x)
				xmin = ep->e.x;
			if (xmax < ep->e.xlast)
				xmax = ep->e.xlast;
			{
				(&ep->e)->dy = (&ep->e)->ylast - (&ep->e)->y;
				(&ep->e)->dx = (&ep->e)->xlast - (&ep->e)->x;
				if ((&ep->e)->dx < 0)
				{
					(&ep->e)->xstep	= (-1);
					(&ep->e)->dx = (-(&ep->e)->dx);
				}
				else
				{
					(&ep->e)->xstep	= 1;
				}
				if ((&ep->e)->dx > (&ep->e)->dy)
				{
					(&ep->e)->xmajor = 1;
					(&ep->e)->error	= (&ep->e)->dx >> 1;
				}
				else
				{
					(&ep->e)->xmajor = 0;
					(&ep->e)->error	= ((&ep->e)->dy	- ((1 -	(&ep->e)->xstep) >>	1))	>> 1;
				}
			};
			ep->status = inactive;
			nedges++;
			ep++;
		}
		if ((nedges	> 0) &&	(xmin <= (current->gc_xcliphi))	&& (xmax >=	(current->gc_xcliplo)))
		{
			if (xmin < (current->gc_xcliplo))
				xmin = (current->gc_xcliplo);
			if (ymin < (current->gc_ycliplo))
				ymin = (current->gc_ycliplo);
			if (xmax > (current->gc_xcliphi))
				xmax = (current->gc_xcliphi);
			if (ymax > (current->gc_ycliphi))
				ymax = (current->gc_ycliphi);

			for	(ypos =	ymin; ypos <= ymax;	ypos++)
			{
				sp = scans;
				points = 0;
				segments = 0;
				for	(n = nedges, ep	= edges; --n >=	0; ep++)
				{
					switch (ep->status)
					{
						case inactive:
							if (ep->e.y	!= ypos)
								break;
							if (ep->e.dy ==	0)
							{
								ep->status = passed;
								xmin = ep->e.x;
								xmax = ep->e.xlast;
								{
									if ((int) (xmin) > (int) (xmax))
									{
										int	_swap_tmpval_ =	(xmin);

										(xmin) = (xmax);
										(xmax) = _swap_tmpval_;
									}
								};
								{
									scan *prev = 0;
									scan *work = segments;
									int	overlap	= 0;

									while (work	!= 0)
									{
										if ((work->x1 <= xmax) && (xmin	<= work->x2))
										{
											overlap	= 1;
											if (xmin < work->x1)
												work->x1 = xmin;
											if (xmax > work->x2)
											{
												prev = work;
												while ((work = work->next) != 0)
												{
													if (work->x1 > xmax)
														break;
													if (work->x2 > xmax)
														xmax = work->x2;
												}
												prev->x2 = xmax;
												prev->next = work;
											}
											break;
										}
										if (work->x1 > xmax)
											break;
										prev = work;
										work = work->next;
									}
									if (!overlap)
									{
										sp->x1 = xmin;
										sp->x2 = xmax;
										sp->next = work;
										if (prev)
											prev->next = sp;
										else
											segments = sp;
									}
								};
								sp++;
								break;
							}
							ep->status = active;
						case active:
							xmin = xmax	= ep->e.x;
							if (ep->e.ylast	== ypos)
							{
								ep->status = passed;
								xmax = ep->e.xlast;
								{
									if ((int) (xmin) > (int) (xmax))
									{
										int	_swap_tmpval_ =	(xmin);

										(xmin) = (xmax);
										(xmax) = _swap_tmpval_;
									}
								};
								{
									scan *prev = 0;
									scan *work = points;

									while (work	!= 0)
									{
										if (work->x1 > xmin)
											break;
										prev = work;
										work = work->next;
									}
									sp->x1 = xmin;
									sp->x2 = xmax;
									sp->next = work;
									if (prev)
										prev->next = sp;
									else
										points = sp;
								};
								sp++;
							}
							else if	(ep->e.xmajor)
							{
								for	(;;)
								{
									(&ep->e)->x	+= (&ep->e)->xstep;
									if (((&ep->e)->error -=	(&ep->e)->dy) <	0)
									{
										(&ep->e)->error	+= (&ep->e)->dx;
										break;
									}
								};
								xmax = ep->e.x - ep->e.xstep;
								{
									if ((int) (xmin) > (int) (xmax))
									{
										int	_swap_tmpval_ =	(xmin);

										(xmin) = (xmax);
										(xmax) = _swap_tmpval_;
									}
								};
							}
							else
							{
								{
									if (((&ep->e)->error -=	(&ep->e)->dx) <	0)
									{
										(&ep->e)->x	+= (&ep->e)->xstep;
										(&ep->e)->error	+= (&ep->e)->dy;
									}
								};
							}
							{
								scan *prev = 0;
								scan *work = points;

								while (work	!= 0)
								{
									if (work->x1 > xmin)
										break;
									prev = work;
									work = work->next;
								}
								sp->x1 = xmin;
								sp->x2 = xmax;
								sp->next = work;
								if (prev)
									prev->next = sp;
								else
									points = sp;
							};
							sp++;
							break;
						default:
							break;
					}
				}
				while (points != 0)
				{
					scan *nextpt = points->next;

					if (!nextpt)
						break;
					xmin = points->x1;
					xmax = nextpt->x2;
					points = nextpt->next;
					{
						scan *prev = 0;
						scan *work = segments;
						int	overlap	= 0;

						while (work	!= 0)
						{
							if ((work->x1 <= xmax) && (xmin	<= work->x2))
							{
								overlap	= 1;
								if (xmin < work->x1)
									work->x1 = xmin;
								if (xmax > work->x2)
								{
									prev = work;
									while ((work = work->next) != 0)
									{
										if (work->x1 > xmax)
											break;
										if (work->x2 > xmax)
											xmax = work->x2;
									}
									prev->x2 = xmax;
									prev->next = work;
								}
								break;
							}
							if (work->x1 > xmax)
								break;
							prev = work;
							work = work->next;
						}
						if (!overlap)
						{
							nextpt->x1 = xmin;
							nextpt->x2 = xmax;
							nextpt->next = work;
							if (prev)
								prev->next = nextpt;
							else
								segments = nextpt;
						}
					};
				}
				while (segments	!= 0)
				{
					xmin = segments->x1;
					xmax = segments->x2;
					segments = segments->next;
					{
						if (xmin > current->gc_xcliphi)
						{
							continue;
						}
						if (xmax < current->gc_xcliplo)
						{
							continue;
						}
						if (xmin < current->gc_xcliplo)
						{
							xmin = current->gc_xcliplo;;
						}
						if (xmax > current->gc_xcliphi)
						{
							xmax = current->gc_xcliphi;;
						}
					};
					(*current->scan) (
										 (xmin + current->gc_xoffset),
										 (ypos + current->gc_yoffset),
										 (xmax - xmin +	1));
				}
			}
		}
	}
}

void _DrawPolygon(int n,	int	pt[][2], PolygonStruct * current)
{
	int	i, px, py, x1, y1, x2, y2, doClose=1;

	if (n <= 0)
		return;
	if (n == 1)
		doClose	= 1;
	x1 = x2	= pt[0][0];
	y1 = y2	= pt[0][1];
	for	(i = 1;	i <	n; i++)
	{
		int	*ppt = pt[i];

		if (x1 > ppt[0])
			x1 = ppt[0];
		if (x2 < ppt[0])
			x2 = ppt[0];
		if (y1 > ppt[1])
			y1 = ppt[1];
		if (y2 < ppt[1])
			y2 = ppt[1];
	}
	px = pt[n -	1][0];
	py = pt[n -	1][1];
	for	(i = 0;	i <	n; i++)
	{
		x1 = px;
		y1 = py;
		x2 = px	= pt[i][0];
		y2 = py	= pt[i][1];
		if (i |	doClose)
		{
			if (y1 > y2)
			{
				{
					int	_swap_tmpval_ =	(x1);

					(x1) = (x2);
					(x2) = _swap_tmpval_;
				};
				{
					int	_swap_tmpval_ =	(y1);

					(y1) = (y2);
					(y2) = _swap_tmpval_;
				};
			}
			{
				if (x1 < x2)
				{
					if (x2 < current->gc_xcliplo)
					{
						continue;
					}
					if (x1 > current->gc_xcliphi)
					{
						continue;
					}
					{
						if (x1 < current->gc_xcliplo)
						{
							y1 += (((int) (((long) (((int) ((y2	- y1)) << 1)) *	(long) (current->gc_xcliplo	- x1)) / (long)	((x2 - x1))) + (((int) ((y2	- y1)) ^ (int) (current->gc_xcliplo	- x1) ^	(int) ((x2 - x1))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							x1 = current->gc_xcliplo;
						}
					};
					{
						if (x2 > current->gc_xcliphi)
						{
							y2 -= (((int) (((long) (((int) ((y2	- y1)) << 1)) *	(long) (x2 - current->gc_xcliphi)) / (long)	((x2 - x1))) + (((int) ((y2	- y1)) ^ (int) (x2 - current->gc_xcliphi) ^	(int) ((x2 - x1))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							x2 = current->gc_xcliphi;
						}
					};
				}
				else
				{
					if (x1 < current->gc_xcliplo)
					{
						continue;
					}
					if (x2 > current->gc_xcliphi)
					{
						continue;
					}
					{
						if (x2 < current->gc_xcliplo)
						{
							y2 += (((int) (((long) (((int) ((y1	- y2)) << 1)) *	(long) (current->gc_xcliplo	- x2)) / (long)	((x1 - x2))) + (((int) ((y1	- y2)) ^ (int) (current->gc_xcliplo	- x2) ^	(int) ((x1 - x2))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							x2 = current->gc_xcliplo;
						}
					};
					{
						if (x1 > current->gc_xcliphi)
						{
							y1 -= (((int) (((long) (((int) ((y1	- y2)) << 1)) *	(long) (x1 - current->gc_xcliphi)) / (long)	((x1 - x2))) + (((int) ((y1	- y2)) ^ (int) (x1 - current->gc_xcliphi) ^	(int) ((x1 - x2))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							x1 = current->gc_xcliphi;
						}
					};
				}
				if (y1 < y2)
				{
					if (y2 < current->gc_ycliplo)
					{
						continue;
					}
					if (y1 > current->gc_ycliphi)
					{
						continue;
					}
					{
						if (y1 < current->gc_ycliplo)
						{
							x1 += (((int) (((long) (((int) ((x2	- x1)) << 1)) *	(long) (current->gc_ycliplo	- y1)) / (long)	((y2 - y1))) + (((int) ((x2	- x1)) ^ (int) (current->gc_ycliplo	- y1) ^	(int) ((y2 - y1))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							y1 = current->gc_ycliplo;
						}
					};
					{
						if (y2 > current->gc_ycliphi)
						{
							x2 -= (((int) (((long) (((int) ((x2	- x1)) << 1)) *	(long) (y2 - current->gc_ycliphi)) / (long)	((y2 - y1))) + (((int) ((x2	- x1)) ^ (int) (y2 - current->gc_ycliphi) ^	(int) ((y2 - y1))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							y2 = current->gc_ycliphi;
						}
					};
				}
				else
				{
					if (y1 < current->gc_ycliplo)
					{
						continue;
					}
					if (y2 > current->gc_ycliphi)
					{
						continue;
					}
					{
						if (y2 < current->gc_ycliplo)
						{
							x2 += (((int) (((long) (((int) ((x1	- x2)) << 1)) *	(long) (current->gc_ycliplo	- y2)) / (long)	((y1 - y2))) + (((int) ((x1	- x2)) ^ (int) (current->gc_ycliplo	- y2) ^	(int) ((y1 - y2))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							y2 = current->gc_ycliplo;
						}
					};
					{
						if (y1 > current->gc_ycliphi)
						{
							x1 -= (((int) (((long) (((int) ((x1	- x2)) << 1)) *	(long) (y1 - current->gc_ycliphi)) / (long)	((y1 - y2))) + (((int) ((x1	- x2)) ^ (int) (y1 - current->gc_ycliphi) ^	(int) ((y1 - y2))) >> ((sizeof(int)	* 8) - 1)) + 1)	>> 1);

							y1 = current->gc_ycliphi;
						}
					};
				}
			};
			(*current->line) (
								 (x1 + current->gc_xoffset),
								 (y1 + current->gc_yoffset),
								 (x2 + current->gc_xoffset),
								 (y2 + current->gc_yoffset));
		}
	}
}

void fill_convex(int num, int pole[][2])
{
	_FillPolygon(num, pole, &ps);
}

void draw_convex(int num, int pole[][2])
{
	_DrawPolygon(num, pole, &ps);
}

// ***********************************************************************

/* bez_split:
 *  Calculates a weighted average between x1 and x2.
 */
static float bez_split(float mu, float x1, float x2)
{
   return (1.0-mu) * x1	+ mu * x2;
}


/* bezval:
 *  Calculates a point on a bezier curve.
 */
static float bezval(float mu, int *coor)
{
   float work[4];
   int i; 
   int j;

   for (i=0; i<4; i++) 
	  work[i] =	(float)coor[i*2];

   for (j=0; j<3; j++)
	  for (i=0;	i<3-j; i++)
	 work[i] = bez_split(mu, work[i], work[i+1]);

   return work[0];
}

/* calc_spline:
 *  Calculates a set of pixels for the bezier spline defined by the four
 *  points specified in the points array. The required resolution
 *  is specified by the npts parameter, which controls how many output
 *  pixels will be stored in the x and y arrays.
 */
void calc_spline(int points[8],	int	npts, int *x, int *y)
{
   int i;
   float denom;

   for (i=0; i<npts; i++) {
	  denom	= (float)i/((float)npts-1.0);
	  x[i] = (int) bezval(denom, points);
	  y[i] = (int) bezval(denom, points+1);
   }
}


/* spline:
 *  Draws a bezier spline onto the specified bitmap in the specified color.
 */
void draw_spline(int points[8])
{
   #define NPTS	  64

   int xpts[NPTS], ypts[NPTS];
   int i;

   calc_spline(points, NPTS, xpts, ypts);

   for (i=1; i<NPTS; i++) {
	  draw_line(xpts[i-1], ypts[i-1], xpts[i], ypts[i]);

	  if (ppop == _GXOR)
		draw_point(xpts[i],	ypts[i]);
   }
}

int stricmp(const char	*s1, const char	*s2)
{
  while	(tolower(*s1) == tolower(*s2))
  {
	if (*s1	== 0)
	  return 0;
	s1++;
	s2++;
  }
  return (int)tolower(*s1) - (int)tolower(*s2);
}

int strnicmp(const	char *s1, const	char *s2, size_t n)
{

  if (n	== 0)
	return 0;
  do {
	if (tolower(*s1) !=	tolower(*s2++))
	  return (int)tolower(*s1) - (int)tolower(*--s2);
	if (*s1++ == 0)
	  break;
  }	while (--n != 0);
  return 0;
}

char * strupr(register char	*s)
{
	register int c;
	char *s2=s;
	while((c=*s)!=0)
	{
	if (islower(c))	*s = toupper(c);
	s++;
	}
	return s2;
}

#if ((defined(__GNUC__) && defined(__QNX__)))

// no MMX for QNX
int test_mmx(void)
{
	return 0;
}

void set_mmx(void)
{
}

void reset_mmx(void)
{
}
#endif


