/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// dynamic loader support object
//

#include <stdio.h>
#include "dll.h"

Dll::Dll(const char *libname, int flag)
{
	handle = dlopen(name=libname, flag);
	error = 0;
    if (!handle) {
        fputs(error = dlerror(), stderr);
        fputs(", cant't link SVGALIB\n", stderr);
    }
}

Dll::~Dll()
{
	if (handle) dlclose(handle);
}

void * Dll::GetAddr(const char *sym)
{
    void * addr = dlsym(handle, sym);
	
    if ((error = dlerror()) != NULL)  {
        fputs(error, stderr);
        fputc('\n', stderr);
		return (void *)-1;
    }
	return addr;
}

