/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    fastgl.cc - graphics engine

*/
#include <stdarg.h>
#include <stdlib.h>

#include "fastgl.h"
#include "_fastgl.h"

//
// Global definitions & declaration
//

int BaseGui::counter = 0;		// counter of all graph. objects
int Window::allControls = 0;	// numbers of all buttons
int Window::hresult = 0;		// numbers of all buttons
int Window::nWnd = 0;			// numbers of all windows
Window *Window::current = (Window *) 0;
Window *Window::first = (Window *) 0;
void (*App::DelayProc) (void) = 0;
void (*App::OnEverySecond)(int) = 0;
static Window *Colise = 0;
char EditBox::buf[128];
GuiEvent *App::event, *App::queque;
int App::quequeIndex = 0;
int WindowDatabase::xyCounter = 0;
WindowItem **WindowDatabase::endpointer;
WindowItem *WindowDatabase::first;
WindowDatabase *entryPoint;
App *cApp;
static BaseMenu *inmenu;
Widget call_handler = 0; // set if need call handler (in translateevent)
MenuWindow *MenuWindow::CurrentMenu=0;
Control *Control::cControl=0;
GuiHwnd MenuWindow::Proc=0;
static PolygonStruct psw;
Config *cCfg;
static unsigned int CRCTab[256];
static int	allBitmapCounter=0;
int MOVEABLE = 1, verbose;
Window *App::Root = 0;
static int DoRootWindow = 0;

static void PiktoMem(int xa, int ya, int x, int y);
static void InitCRC(void);

static ColorScheme _CS =
{
	CWHITED, CBLACK, // window colors
	CBLUELIGHT, // active title
	CBROWN,		// inactive title
	CWHITE,		// wnd border 1
	CBLACK,		// wnd border 2
	CGRAY2,		// wnd border 3
	CWHITED,	// statusbar
	CWHITE,		// menu bg
	CBLACK,		// menu fore
	CBLACK,		// menu bg active
	CWHITE,		// menu fore active
	CBLACK,		// pbutton fore
	CGRAY1,		// pbutton back
	CDARK,		// pbutton fore - pushed
	CGRAY2,		// pbutton back - pushed
	CWHITE,		// control::frame1
	CBLACK,		// control::frame2
	CGRAYED,	// control::frame3
	CWHITE,		// edit back
	CBLACK,		// edit fore
	CDARK, 		// edit bord1
	CGRAY3,		// edit bord2
	CGRAY1,		// slider
	CGRAY3,		// menuwindow back
	CBLACK,		// menuwindow fore
	CBLUELIGHT, // pdmenu back
	CWHITE,		// pdmenu fore
	CGRAY1,		// pdmenu gray
};

ColorScheme * CScheme = &_CS;

//
// Source code
// --------------------------------------------------------------------------

//
// Internal
//
void Window::Context(void)
{
	current = this;
	if (!this) return;
	Image = image;
	cx_max = GetW();
	cy_max = GetH();
	cx_work = xwrk;
	cy_work = ywrk;
	cx_maxwork = wwrk;
	cy_maxwork = hwrk;
}

// kresli ikonky na titulok okna
static void PiktoMem(int x, int y, int w, int h)
{
	RamToRam(0, 0, PICTOSIZE*2, PICTOSIZE, x, y, w,h, PICTOSIZE*2, PICTOSIZE, _internal_bitmap0, Image);
}

//
// A traditional printf in window form
//

int Window::printf(const char *format,...)
{
	char s[256];
	va_list arglist;

	va_start(arglist, format);
	vsprintf(s, format, arglist);
	va_end(arglist);
	puts(s);
	return strlen(s);
}

//
// A traditional printf in window form + position
//

int Window::printf(int x, int y, const char *format,...)
{
	char s[256];
	if (x<0 || x>GetW() || y<0 || y>GetH()) return 0;
	move(x, y);
	va_list arglist;

	va_start(arglist, format);
	vsprintf(s, format, arglist);
	va_end(arglist);
	puts(s);
	return strlen(s);
}

//
// Put char to window at current print position
//

void Window::wputc(int c)
{
	Window *tmp = current;

	Context();

	if (c == -1)
	{
		WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
		tmp->Context();
		return;
	}
	if (xpos == -1)
	{
		WindowScrollUp(0, fonth, wsur, hsur - fonth - hsur % fonth, fonth);
		xpos = 1;
	}
	if (xpos < (wsur - xwrk))
	{
		if (c == '\n')
		{
			if (ypos > (hsur - fonth * 2))
			{
				WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
				xpos = -1;
			}
			else
			{
				WindowRepaint(0 + xwrk, ypos + ywrk, xpos + xwrk, fonth);
				ypos += fonth;
				xpos = 1;
			}
		}
		else
		{
			Text(xpos + xwrk, ypos + ywrk, (char *) &c);
			xpos += fontw;
		}
	}
	else
	{
		xpos -= fontw;
		wputc('\n');
		wputc(c);
	}
	tmp->Context();
}

//
// Internal
//
void BaseGui::PositionCheck(int &xx, int &yy, int &ww, int &hh)
{
	if (ww > X_width)
		ww = X_width;
	if (hh > Y_width)
		hh = Y_width;
	if ((xx + ww) >= X_width)
		xx = X_width - ww;
	if (xx < 0)
		xx = 0;
	if ((yy + hh - 1) >= Y_width)
		yy = Y_width - hh;
	if (yy < 0)
		yy = 0;
}

/*
 * return 0 if in window area
 * else 1 for title
 * 2 for close
 * 3 for minimize
 * 4 for resize
 */
int Window::TitleFind(GuiEvent * e)
{
	if ((GetX() <= e->GetX()) && ((GetX() + GetW()) >= e->GetX()))
	{
		if (((GetX() + GetW() - 13) <= e->GetX()) &&
			((GetY() + GetH() - 13 <= e->GetY()) && ((GetY() + GetH()) >= e->GetY())) &&
			GetStatus() & WSIZEABLE)
			return 4;
		if (GetStatus() & WTITLED)
		{
			if ((GetY() <= e->GetY()) && ((GetY() + 3+TITLEH) >= e->GetY()))
			{
				if (!(GetStatus() & WNOPICTO))
				{
					if (e->GetX() >= (GetX() + GetW() - 3 - PICTOSIZE))
 						if (GetStatus()&WMINIMIZE) return 3;
						else return 0;
					if (e->GetX() >= (GetX() + GetW() - 3 - PICTOSIZE*2))
						return 2;
				}
				return 1;
			}
		}
		else if (GetStatus() & WUNMOVED) return 0;
		else if ((GetY() <= e->GetY()) && ((GetY() + TITLEH+3) >= e->GetY()))
			return 1;
	}
	return 0;
}

volatile void DestroyWindow(void)
{
	int c = Window::nWnd;
	if (c && verbose) printf("WARNING: %d window(s) not closed at exit\n", c);
}

void Window::WindowMove(int nx, int ny)
{
	Control *p = (Control *) GetCurrentControls();
	XWaitRetrace();
	WindowStatus(WHIDE);
	Relocate(nx, ny);
	while (p)
	{
		p->Relocate(nx, ny);
		p = (Control *) p->GetNext();
	}
	WindowStatus(WVISIBLE);
	SendEvent(this, WINDOWMOVEEVENT);
}

BaseGui *BaseGui::OverSprite(BaseGui * od, int xx, int yy, int ww, int hh)
{
	int xa1, xa2, ya1, ya2;
	BaseGui *v = 0;
	int xb1 = xx, xb2 = xx + ww, yb1 = yy, yb2 = yy + hh;

	while (od != this)
	{
		if (!(od->status & WHIDEN))
		{
			xa1 = od->x,
				xa2 = od->x + od->w,
				ya1 = od->y,
				ya2 = od->y + od->h;

			if ((xa1 <= xb1 && xa2 >= xb1) || (xa1 <= xb2 && xa2 >= xb2))	// x sa prekryva

			{
				if ((ya1 <= yb1 && ya2 >= yb1) || (ya1 <= yb2 && ya2 >= yb2))
				{
					v = od;
					break;
				}
				else if (yb1 <= ya1 && yb2 >= ya2)
				{
					v = od;
					break;
				}
			}
			else if ((xb1 <= xa1 && xb2 >= xa1) || (xb1 <= xa2 && xb2 >= xa2))
			{
				if ((yb1 <= ya1 && yb2 >= ya1) || (yb1 <= ya2 && yb2 >= ya2))
				{
					v = od;
					break;
				}
				else if (ya1 <= yb1 && ya2 >= yb2)
				{
					v = od;
					break;
				}
			}
		}
		od = od->last;
	}
	return v;
}

int Window::OdkryteOkno(Window * pokial, int x, int y, int w, int h)
{
	if (!IsVisible())
		return 0;				// je skryte

	if (!GetNext())
		return 1;				// je aktivne

	while (pokial != this)
	{
		if ((Colise = (Window *) OverSprite(pokial, x, y, w, h)) != 0)
		{
			return 2;
		}
		pokial = (Window *) pokial->GetLast();
	}
	return 1;
}

#define area(a,b,c,d) *out++=a,*out++=b,*out++=c,*out++=d;	//,Ladenie("a,b,c,d - %d,%d,%d,%d\n",a,b,c,d);

int Window::Rozporcuj(int X1, int Y1, int X2, int Y2, int *in, int *out)
{
	int x1, y1, x2, y2, f;

	if (*in == -1)
		return 0;
	while (*in != -1)
	{
		x1 = *in++;
		y1 = *in++;
		x2 = *in++;
		y2 = *in++;
		f = 0;
		if (x1 >= X1 && y1 >= Y1 && x2 <= X2 && y2 <= Y2)
			break;				// cely prekryty 

		if (x2 < X1 || y2 < Y1 || x1 > X2 || y1 > Y2)	// cely mimo

		{
			area(x1, y1, x2, y2);
			continue;
		}

		if (x1 <= X1 && x2 >= X1)
		{
			area(x1, y1, X1, y2);
			x1 = X1;
		}

		if (y1 <= Y1 && y2 >= Y1)
		{
			area(x1, y1, x2, Y1);
			y1 = Y1;
		}

		if (x2 >= X2 && x1 <= X2)
		{
			area(X2, y1, x2, y2);
		}

		if (y2 >= Y2 && y1 <= Y2)
		{
			area(x1, Y2, x2, y2);
		}
	}
	*out = -1;
	return 1;
}

//
// aktualizovane okno a relativne suradnice v tomto okne
//
void Window::WindowRepaint(int xr, int yr, int w, int h)
{
	static int zoznam1[320], zoznam2[320], *p1, *p2, *p3;
	BaseGui *posledne = current;

	if (GetStatus() & WLOCKED)
	{
		SetStatus(GetStatus() | WDIRTY);
		return;
	}
	for (; posledne->GetNext(); posledne = posledne->GetNext());
	if (xr < 0)
	{
		w += xr;
		xr = 0;
		if (w <= 0)
			return;
	}
	if (yr < 0)
	{
		h += yr;
		yr = 0;
		if (h <= 0)
			return;
	}
	switch (OdkryteOkno((Window *) posledne, GetX() + xr, GetY() + yr, w, h))
	{
		case 0:
			SetStatus(GetStatus() | WDIRTY);
			return;
		case 1:
			RepaintBlock(xr, yr, w, h);
			return;
		case 2:					// chyba je v okne Colise a mozno aj v oknach medzi nimy

			posledne = Colise;
			p1 = zoznam1;
			p1[0] = GetX() + xr;
			p1[1] = GetY() + yr;
			p1[2] = GetX() + xr + w;
			p1[3] = GetY() + yr + h;
			p1[4] = -1;
			p2 = zoznam2;		// inicializacia poli

			p2[0] = -1;
			SetStatus(GetStatus() | WDIRTY);
			for (;;)
			{
				if (!Rozporcuj(posledne->GetX(), posledne->GetY(), posledne->GetX() + posledne->GetW(), posledne->GetY() + posledne->GetH(), p1, p2))
					return;
				p3 = p1;
				p1 = p2;
				p2 = p3;
				posledne = posledne->GetLast();
				if (posledne == this)
					break;
				if (OdkryteOkno((Window *) posledne, GetX() + xr, GetY() + yr, w, h) != 2)
					break;
			}

			while (*p1 != -1)
			{
				RepaintBlock(p1[0] - GetX(), p1[1] - GetY(), p1[2] - p1[0], p1[3] - p1[1]);
				p1 += 4;
			}
			break;
	}
}

void Window::WindowHide(void)
{
	Window *pom = current;

	Context();
	Image = save;
	RamToVideo(0, 0, GetX(), GetY(), GetW(), GetH());
	pom->Context();
}

void Window::WindowShow(void)
{
	Window *pom = current;

	Context();
	Image = save;
	VideoToRam(GetX(), GetY(), 0, 0, GetW(), GetH());
	Image = image;
	RamToVideo(0, 0, GetX(), GetY(), GetW(), GetH());
	SetStatus(GetStatus() & (~WDIRTY));
	pom->Context();
}

void Window::WindowRecopy(void)
{
	if (!IsVisible())
		WindowHide();
	else
		WindowShow();
}


BaseGui *BaseGui::Over(BaseGui * od, BaseGui * po)
{
	int xa1, xa2, ya1, ya2;
	BaseGui *v = 0;
	int xb1 = po->GetX(), xb2 = po->GetX() + po->GetW(), yb1 = po->GetY(),
	  yb2 = po->GetY() + po->GetH();
	BaseGui *t;

	while (od != po && od)
	{
		if (od->IsVisible())
		{
			xa1 = od->GetX(),
				xa2 = od->GetX() + od->GetW(),
				ya1 = od->GetY(),
				ya2 = od->GetY() + od->GetH();

			if ((xa1 <= xb1 && xa2 > xb1) || (xa1 < xb2 && xa2 >= xb2))	// x sa prekryva
			{
				if ((ya1 <= yb1 && ya2 > yb1) || (ya1 < yb2 && ya2 >= yb2))
				{
					v = od;
					break;
				}
				else if (yb1 <= ya1 && yb2 >= ya2)
				{
					v = od;
					break;
				}
			}
			else if ((xb1 <= xa1 && xb2 > xa1) || (xb1 < xa2 && xb2 >= xa2))
			{
				if ((yb1 <= ya1 && yb2 > ya1) || (yb1 < ya2 && yb2 >= ya2))
				{
					v = od;
					break;
				}
				else if (ya1 <= yb1 && ya2 >= yb2)
				{
					v = od;
					break;
				}
			}
		}
		t = od;
		od = od->GetLast();
	}
	return v;
}

void Window::HideAll(void)
{
	BaseGui *pokial = Window::current;

	if (!first)
	{
		hresult = 0;
		return;
	}
	do
	{
		pokial->SetStatus(pokial->GetStatus() | WTEMPHIDEN);
		((Window *) pokial)->WindowRecopy();
		pokial = pokial->GetLast();
		if (pokial==first && DoRootWindow) break;
	}
	while (pokial);
	hresult = 1;
}

void Window::ShowAll(void)
{
	if (hresult)
		ZakryOkno();
}

/*
** Simply test to Window overloading
*/
int Window::OverWnd(void)
{
	BaseGui *pokial = current;

	if (!GetNext())	return 0;				// is active
	while (pokial != this && pokial)
	{
		if (Over(pokial, this) != 0) return 1;
		pokial = pokial->GetLast();
	}
	return 0; // no window over this
}

/*
** Odkryje okna ak treba a vrati vysledok, 1 = odkryvalo sa
** references from: WindowStatus(), ~Window() a WindowSwitch();
** call this fnc only after OverWnd()==1
*/
int Window::OdkryOkno(void)
{
	BaseGui *pom, *pokial = current;
	int one = 0;

	if (!GetNext())	return 0;				// je aktivne
	while (pokial != this && pokial)
	{
		if ((pom = Over(pokial, this)) != 0)
		{
			((Window *) pom)->OdkryOkno();
			pokial = pom;
			pokial->SetStatus(pokial->GetStatus() | WTEMPHIDEN);
			((Window *) pokial)->WindowRecopy();
			one |= 1;			// bude 1 ak sa odmazavalo
		}
		pokial = pokial->GetLast();
	}

	if (pokial)
	{
		pokial->SetStatus(pokial->GetStatus() | WTEMPHIDEN);
		((Window *) pokial)->WindowRecopy();
	}
	return one + 1;
}

void Window::ZakryOkno(void)
{
	BaseGui *p = Window::first;

	for (;;)
	{
		if (p->GetStatus() & WTEMPHIDEN)
		{
			p->SetStatus(p->GetStatus() & (~(WTEMPHIDEN)));
			if (((Window *) p)->IsVisible())
				((Window *) p)->WindowRecopy();
		}
		if (!p->GetNext())
			break;
		p = p->GetNext();
	}
}

long Window::WindowStatus(long stat)
{
	Window *pom = current;
	int tmp, flg=0;

	tmp = GetStatus();

	Context();
	switch (stat)
	{
		case WHIDE:
			if (OverWnd()) flg = OdkryOkno();
			if (!IsVisible()) break;
			SetStatus(GetStatus() | WHIDEN);
			WindowRecopy();
			if (flg)
				ZakryOkno();
			break;

		case WVISIBLE:
			if (OverWnd()) flg = OdkryOkno();
			if (IsVisible())
				break;
			SetStatus(GetStatus() & (~WHIDEN));
			WindowRecopy();
			if (flg)
				ZakryOkno();
			break;

		case WDEACTIVE:
			DrawTitleMem(CTITLE);
			break;

		case WACTIVE:
			DrawTitleMem(CTITLEACTIVE);
			break;
	}
	pom->Context();
	return tmp;
}

// prepne okno na popredie
void Window::WindowFocus(void)
{
	Window *old = current, *novy = this;
	int flg = 0;
	GuiEvent a1(LOSTFOCUSEVENT), a2(GETFOCUSEVENT);
	FlushInput();
	old->SendToWindow(&a1);
	old = current;
	if (nWnd <= 1) // no more window
		return;
	if (novy == old) // no more to switch
		return;
	old->WindowStatus(WDEACTIVE);	// deactive old
	if (OverWnd()) flg = novy->OdkryOkno();	// Skryvaj(old, novy);

	if (novy == first)				// if switch to first in queque
	{
		first = (Window *) novy->GetNext();
		first->SetLast(0);
	}
	else // switch to other than first
	{
		(novy->GetLast())->SetNext(novy->GetNext());
		(novy->GetNext())->SetLast(novy->GetLast());
	}
	old->SetNext((BaseGui *) novy);	  // exchange
	novy->SetLast((BaseGui *) old);
	novy->SetNext(0);
	if (flg) first->ZakryOkno();		// Ukazuj();

	novy->WindowStatus(WACTIVE); // active new
	novy->Context();			 // set context to this
	SendToWindow(&a2);
	oldidm = idm = 0;
	oldidw = idw = 0;
}

static char *skipstr(char *s)
{
	while (*s)
	{
		if (*s > ' ')
			return s;
		s++;
	}
	return s;
}

Control::Control(int xs, int ys, int typ, int keycode, int flag, Window * own, Bitmap * bm, Widget f):
  BaseGui(xs += own->xwrk, ys += own->ywrk, bm->GetWREAL() + 4, bm->GetH() + 4, 0, typ, 0, 0, flag | WBITMAP)
{
	owner = own;
	icon = bm;
	grp = 0;
	if (keycode >= 'a' && keycode <= 'z')
		keycode = toupper(keycode);
	key = keycode;
	fnc = f;
    Window::allControls++;
	local_id = owner->nControls++;
	xr = owner->GetX() + xs;
	yr = owner->GetY() + ys;
	SetLast(owner->lastButton);
	owner->lastButton = this;

	if (!owner->Buttony)		// first control
	{
		owner->Buttony = this;
	}
	else
	{
		GetLast()->SetNext(this);
	}
}

Control::Control(int xs, int ys, int ws, int hs, char *nm, int typ, int keycode, int flag, Window * own, Widget f, int p, int i):
  BaseGui(xs += own->xwrk, ys += own->ywrk, ws, hs, nm, typ, i, p, flag)
{
	owner = own;
	icon = 0;
	grp=0;
	if (keycode >= 'a' && keycode <= 'z')
		keycode = toupper(keycode);
	key = keycode;
	fnc = f;
    Window::allControls++;
	local_id = owner->nControls++;
	xr = owner->GetX() + xs;
	yr = owner->GetY() + ys;
	SetLast(owner->lastButton);
	owner->lastButton = this;
	if (!owner->Buttony)		// first control

	{
		owner->Buttony = this;
	}
	else
	{
		GetLast()->SetNext(this);
	}
}

Control::~Control()
{
	BaseGui *l, *n;

	if (!owner) return;
	if (this==cControl) cControl = 0; // no more valid
	l = GetLast();
	n = GetNext();

	if (icon)
		delete icon;

	if (n == (Control *) 0 && l == (Control *) 0)	// no more windows ...
	{
		owner->Buttony = 0;
	}
	else if (n == (BaseGui *) 0)	// last in queqe

	{
		owner->lastButton = l;
	}
	else if (l == (BaseGui *) 0)	// first in queqe
	{
		owner->Buttony = n;
	}
	else
	{
	}
    Window::allControls--;
	owner->nControls--;
	owner = 0;
}

void Control::Enable(void)
{
	Window *tmp = Window::GetCurrent();

	owner->Context();
	SetStatus((GetStatus() & (~7)) | BNORMAL);
	draw();
	tmp->Context();
}

void Control::Disable(void)
{
	Window *tmp = Window::GetCurrent();

	owner->Context();
	SetStatus((GetStatus() & (~7)) | BDISABLED);
	draw();
	tmp->Context();
}

void Control::ClickUp(int a)	// if TRUE, so call handler
{
	SetStatus(GetStatus() ^ WTRIGGER);
	draw();
	if (a) call_handler = GetHandler();
}

void BaseMenu::ClickUp(int a)	// if TRUE, so call handler
{
	draw();
	if (a) call_handler = GetHandler();
}

Control *Control::ButtonFind(GuiEvent * e, int n)
{
	Control *p = (Control *) Window::GetCurrent()->GetCurrentControls();
	int c;

	if (!p)
		return 0;				// niesu buttony

	if (e->Key() >= 'a' && e->Key() <= 'z')
		c = toupper(e->Key());
	else
		c = e->Key();
	if (e->Type() == KEYEVENT)
		for (;;)
		{
			if ((p->Key() == c) && (p->GetStatus() & n & 7) == n)
				return p;
			if ((p = (Control *) p->GetNext()) == 0)
				return 0;
		}
	else
		do
		{
			if ((p->owner->GetX() + p->owner->GetW() >= e->GetX()) && ((p->owner->GetY() + p->owner->GetH()) >= e->GetY()))
				if ((p->GetXr() <= e->GetX()) && ((p->GetXr() + p->GetW()) >= e->GetX()))
					if ((p->GetYr() <= e->GetY()) && ((p->GetYr() + p->GetH()) >= e->GetY()))
						if ((p->GetStatus() & n & 7) == n)
						{
							if (p->GetType() == MENUBUTTON || p->GetType() == MENUBUTTON2)
								inmenu = (BaseMenu *) p;
							return p;
						}
						else if (p->GetStatus() == BDISABLED)
						{
							return 0;
						}
		}
		while ((p = (Control *) p->GetNext()) != 0);
	return 0;
}

// najde okno, ktoremu patrila mysia udalost
Window *Window::WindowFind(GuiEvent * e)
{
	return (Window *) BaseGui ::Find(first, e);
}

BaseGui *BaseGui::Find(BaseGui * p, GuiEvent * e)
{
	BaseGui *x = 0;

	if (p->next)
			x = Find(p->next, e);
	if (x)
		return x;
	if ((p->x <= e->x) && ((p->x + p->w) >= e->x))
		if ((p->y <= e->y) && ((p->y + p->h) >= e->y))
			if (!(p->status & WHIDEN) && (p->type!=PSEUDOWINDOW))
				x = p;
	return x;
}

// najde okno podla nazvu
BaseGui *BaseGui::FindName(BaseGui * p, char *s)
{
	for (; p;)
	{
		if (!strcmp(p->name, s))
			break;
		if (p->next == (BaseGui *) 0)
			return (BaseGui *) 0;
		p = p->next;
	}
	return p;
}

// najde okno podla idw
BaseGui *BaseGui::FindId(BaseGui * p, int idw)
{
	for (; p;)
	{
		if (p->id == idw)
			break;
		if (p->next == (BaseGui *) 0)
			return (BaseGui *) 0;
		p = p->next;
	}
	return p;
}

void Control::frame(void)
{
	set_fcolor(CScheme->button_bord1);
	Vline(GetX(), GetY(), GetH());
	Hline(GetX(), GetY(), GetW());
	set_fcolor(CScheme->button_bord3); // CGRAYED;
	Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
	Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
	set_fcolor(CScheme->button_bord2); // CBLACK;
	Vline(GetX() + GetW() - 1, GetY() + 0, GetH() - 0);
	Hline(GetX() + 0, GetY() + GetH() - 1, GetW() - 1);
}

//
// nakresli button
//
void PushButton::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[128];
	unsigned dl=0, a = set_font(FONT0816), st;

	set_ppop(_GSET);
	owner->Context();
	if (GetName())
	{
		dl = (GetW() - 12) / 8;	// maximalny zobrazitelny pocet znakov

		strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
		str[dl] = 0;
	}
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			frame();
			if (st & WBITMAP)
			{
				owner->WindowPutBitmap(GetX() + 2 - cx_work, GetY() + 2 - cy_work, 0, 0, icon->GetWREAL(), icon->GetH(), icon);
			}
			else
			{
				set_fcolor(CScheme->button_back);
				Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
				set_bcolor(CScheme->button_back);
				set_fcolor(CScheme->button_fore);
				Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
				Underscore((GetW() / 2 - dl * fontw / 2) , 1 + GetH() / 2 - fonth / 2, CDARK);
			}
			break;

		case BPUSHED:
			set_fcolor(CScheme->button_bord2);
			Boxw(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_bord1);
			Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
			if (st & WBITMAP)
			{
				owner->WindowPutBitmap(GetX() + 2 - cx_work, GetY() + 2 - cy_work, 0, 0, icon->GetWREAL(), icon->GetH(), icon);
			}
			else
			{
				set_fcolor(CScheme->button_back);
				Boxw(GetX() + 2, GetY() + 2, GetW() - 4, GetH() - 4);
				set_bcolor(CScheme->button_back);
				set_fcolor(CScheme->button_fore_pushed);
				Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
			}
			break;

		case BDISABLED:
			set_fcolor(CScheme->button_bord1);
			Boxw(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_fore_pushed);
			Vline(GetX() + GetW() - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1, GetY() + GetH() - 2, GetW() - 2);
			Rect(GetX(), GetY(), GetW(), GetH());
			set_fcolor(CScheme->button_back);
			Boxw(GetX() + 2, GetY() + 2, GetW() - 4, GetH() - 4);
			set_bcolor(CScheme->button_back);
			set_fcolor(CScheme->button_bord3);
			Textw(GetX() + (GetW() / 2 - dl * fontw / 2), GetY() + 1 + (GetH() / 2 - fonth / 2), str);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void EditBox::MoveIn(void)
{
	owner->Context();
	set_fcolor(CYELLOW);
	set_ppop(_GSET);
	Rect(GetX() + w1, GetY(), w2, GetH());
	owner->WindowRepaint(GetX() + w1, GetY(), w2, GetH());
}

void EditBox::MoveOut(void)
{
	owner->Context();
	set_fcolor(CScheme->edit_bord1);
	set_ppop(_GSET);
	Rect(GetX() + w1, GetY(), w2, GetH());
	owner->WindowRepaint(GetX() + w1, GetY(), w2, GetH());
}

void PushButton::MoveIn(void)
{
	owner->Context();
	set_fcolor(CYELLOW);
	set_ppop(_GSET);
	Rect(GetX(), GetY(), GetW(), GetH());
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
}

void PushButton::MoveOut(void)
{
	owner->Context();
	frame();
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
}

void PushButton::Push(void)
{
	SetStatus((GetStatus() & (~7)) | BPUSHED | WTRIGGER);
	draw();
}

void PushButton::ClickDown(void)
{
	Push();
}

void PushButton::Release(void)
{
	SetStatus((GetStatus() & (~(7|WTRIGGER))) | BNORMAL);
	draw();
}

void PushButton::ClickUp(int a)	// if TRUE, so call handler
{
	Release();
	if (a) call_handler = GetHandler();
}

void CheckButton::draw(void)
{
	char *ptr = e_mask;
	static char str[40];
	unsigned dl, a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	dl = (GetW() - 12) / 8;		// maximalny zobrazitelny pocet znakov

	strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
	str[dl] = 0;
	set_bcolor(GetPaper());
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			set_fcolor(GetInk());
			Textw(GetX() + 24, GetY(), GetName());
			Underscore(24, 0, GetInk());
			break;
		case BDISABLED:
			set_fcolor(CGRAY1);
			Textw(GetX() + 24, GetY(), GetName());
			break;
	}
	if (GetStatus() & WTRIGGER)
	{
		ptr = c_mask;
		if (variable) *variable = 1;
	}
	else
	{
		ptr = d_mask;
		if (variable) *variable = 0;
	}
	RamToRam(0, 0, 14, 14, GetX(), GetY(), owner->GetW(), owner->GetH(), 14, 14, ptr, Image);
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void PointButton::draw(void)
{
	static char str[40];
	unsigned dl, a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	dl = (GetW() - 12) / 8;		// maximalny zobrazitelny pocet znakov

	strncpy(str, GetName(), strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl);
	str[dl] = 0;
	set_bcolor(GetPaper());
	set_fcolor(GetInk());
	Textw(GetX() + 24, GetY(), GetName());
	Underscore(24, 0, GetInk());
	int xx=GetX()+2, yy=GetY()+2;
	if (GetStatus() & WTRIGGER)
	{
		if (variable) *variable = 1;
		set_fcolor(CWHITE);
		Boxw(xx,yy,10,10);
		set_fcolor(CBLACK);
		Hline(xx,yy,10);
		Hline(xx+1,yy+1,8);
		Vline(xx,yy,10);
		Vline(xx+1,yy+1,8);
	}
	else
	{
		if (variable) *variable = 0;
		set_fcolor(CBLACK);
		Boxw(xx,yy,10,10);
		set_fcolor(CWHITE);
		Hline(xx,yy,10);
		Hline(xx+1,yy+1,8);
		Vline(xx,yy,10);
		Vline(xx+1,yy+1,8);
	}
	set_fcolor(CGRAY2);
	Boxw(xx+2,yy+2,6,6);
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s)
{
	Window *tmp = Window::current;

	x += xwrk;
	y += ywrk;

	set_fcolor(GetInk());
	set_bcolor(GetPaper());
	Context();
	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s, int color)
{
	Window *tmp = current;

	x += xwrk;
	y += ywrk;
	set_bcolor(GetPaper());
	set_fcolor(color);
	Context();
 	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowText(int x, int y, char *s, int color, int bk)
{
	Window *tmp = current;

	x += xwrk;
	y += ywrk;
	set_fcolor(color);
	set_bcolor(bk);
	Context();
	Text(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::WindowBox(int x, int y, int a, int b)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Box(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowBox(int x, int y, int a, int b, int c)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	set_fcolor(c);
	Box(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowRect(int x, int y, int a, int b)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Rect(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowRect(int x, int y, int a, int b, int c)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	set_fcolor(c);
	Rect(x, y, a, b);
	WindowRepaint(x, y, a, b);
	tmp->Context();
}

void Window::WindowLine(int x, int y, int a, int b, int c)
{
	Window *tmp = current;
	int x1, x2, y1, y2;

	set_fcolor(c);
	Context();
	x += xwrk;
	y += ywrk;
	a += xwrk;
	b += ywrk;
	x1 = (x < a) ? x : a;
	x2 = (x < a) ? a : x;
	y1 = (y < b) ? y : b;
	y2 = (y < b) ? b : y;
	Line(x, y, a, b);
	WindowRepaint(x1, y1, x2 - x1+1, y2 - y1 + 1);
	tmp->Context();
}

void Window::WindowLine(int x, int y, int a, int b)
{
	Window *tmp = current;
	int x1, x2, y1, y2;

	Context();
	x += xwrk;
	y += ywrk;
	a += xwrk;
	b += ywrk;
	x1 = (x < a) ? x : a;
	x2 = (x < a) ? a : x;
	y1 = (y < b) ? y : b;
	y2 = (y < b) ? b : y;
	Line(x, y, a, b);
	WindowRepaint(x1, y1, x2 - x1+1, y2 - y1 + 1);
	tmp->Context();
}

void Window::WindowPixel(int x, int y, int c)
{
	Window *tmp = current;

	set_fcolor(c);
	Context();
	x += xwrk;
	y += ywrk;
	Pixel(x, y);
	WindowRepaint(x, y, 1, 1);
	tmp->Context();
}

void Window::WindowPixel(int x, int y)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	Pixel(x, y);
	WindowRepaint(x, y, 1, 1);
	tmp->Context();
}

void Window::WindowDrawCircle(int x, int y, int r)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	DrawCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowDrawCircle(int x, int y, int r, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	DrawCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowFillCircle(int x, int y, int r)
{
	Window *tmp = current;

	Context();
	x += xwrk;
	y += ywrk;
	FillCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowFillCircle(int x, int y, int r, int c)
{
	Window *tmp = current;

	Context();
	set_fcolor(c);
	x += xwrk;
	y += ywrk;
	FillCircle(x, y, r);
	WindowRepaint(x - r, y - r, r + r + 1, r + r + 1);
	tmp->Context();
}

void Window::WindowScrollDown(int p1, int p2, int p3, int p4, int p5)
{
	Window *tmp = current;

	Context();
	p1 += xwrk;
	p2 += ywrk;
	RamToRamd(p1, p2, cx_max, cy_max, p1, p2 + p5, cx_max, cy_max, p3, p4, Image, Image);
	int a = get_fcolor();

	set_fcolor(GetPaper());
	Boxw(p1, p2, p3, p5);
	set_fcolor(a);
	WindowRepaint(p1, p2, p3, p4 + p5);
	tmp->Context();
}

void Window::WindowScrollUp(int p1, int p2, int p3, int p4, int p5)
{
	Window *tmp = current;
	int a;

	Context();
	p1 += xwrk;
	p2 += ywrk;
	RamToRam(p1, p2, cx_max, cy_max, p1, p2 - p5, cx_max, cy_max, p3, p4, Image, Image);
	a = get_fcolor();
	set_fcolor(GetPaper());
	Boxw(p1, p2 + p4 - p5, p3, p5);
	set_fcolor(a);
	WindowRepaint(p1, p2 - p5, p3, p4 + p5);
	tmp->Context();
}

void Window::WindowInvalidate(void)
{
	Window *tmp = current, *p = Window::first;

	while (p)
	{
		if (p->GetStatus() & WDIRTY && p->IsVisible())
		{
			p->SetStatus(p->GetStatus() & (~WDIRTY));
			p->Context();
			p->WindowRepaint(0, 0, p->GetW(), p->GetH());
		}
		p = (Window *) p->GetNext();
	}
	tmp->Context();
}

void Window::WindowUnLock(void)
{
	SetStatus(GetStatus() & (~WLOCKED));
	if (GetStatus() & WDIRTY && IsVisible())
	{
		Window *tmp = current;

		SetStatus(GetStatus() & (~WDIRTY));
		Context();
		WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
		tmp->Context();
	}
}

//
// Warning: do not reorder colors !!! (due to base.h colors definition)
//

void ColorSystem::ReservedColors(void)
{
	CreateColor(0, 0, 0); 		// cblack
	CreateColor(17, 17, 17);	// CDARK);
	CreateColor(22, 22, 22);	// CGRAYED);
	CreateColor(31, 32, 29);	// CGRAY1);
	CreateColor(26, 30, 33);	// CGRAY2);
	CreateColor(42, 46, 43);	// CGRAY3);
	CreateColor(0, 0, 32);		// CBLUE);
	CreateColor(0, 0, 62);		// CBLUELIGHT);
	CreateColor(0, 30, 0);		// CGREEN);
	CreateColor(0, 62, 0);		// CGREENLIGHT);
	CreateColor(53, 17,18);		// CRED);
	CreateColor(62, 0, 0);		// CREDLIGHT);
	CreateColor(26, 16, 10);	// CBROWN);
	CreateColor(63, 56, 00);	// CYELLOW);
	CreateColor(54, 52, 46);	// CWHITED);
	CreateColor(63, 63, 63);	// CWHITE);
	CreatePaletteEntry(63, 63, 63, 255); // for CWHITE - mouse rect when dragging ...
}

App::App(int m, int &argc, char **&argv, int background, int f)
{
	volatile int curr = 0, par = 0;
	char *apn=argv[0], *apn2, **cmdl=argv+1;
	video = m;
	driver = 0;

	flags = f;
	if (cApp)
		IError("Multiple App class not allowed !", 1);
	cApp = this;

	if (f&APP_WINDOWDATABASE) entryPoint = new WindowDatabase;

	apn2 = apn;
	apn = apn+strlen(apn)-1;
	if (strcmp(apn-3, ".exe")==0) { apn = apn-4; apn[1]=0; }
	while ((*apn!='/' && *apn!='\\' && *apn!=':') && apn2<=apn) apn--;
	apn++;
	cCfg = new Config(apn);
	event = new GuiEvent;
	queque = new GuiEvent[MAX_EVENT_QUEQUE];

	if (argc > 1)
	{
		while (curr<(argc-1))
		{
			curr++;
			if (argv[curr][0] == '-') switch (tolower(argv[curr][1]))
			{
				case 'r':
					if (!memcmp(&argv[curr][1], "res", 3))
					{
						curr++;
						if (argc)
							video = argv[curr][0] - '0';
						par += 2;
					}
					else *cmdl++ = argv[curr];
					break;
#ifndef __linux__
				case 'd':
					if (!memcmp(&argv[curr][1], "dri", 3))
					{
						curr++;
						if (argc)
							driver = atoi(&argv[curr][0]);
						if (driver == 0)
							driver = -1;	// no detect -> VESA
						par += 2;
					}
					else *cmdl++ = argv[curr];
					break;
#else
				case 's':
					if (!memcmp(&argv[curr][1], "svg", 3))
					{
						nofb = 1;	// no detect FRAMEBUFFER
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				case 'm':
					if (!memcmp(&argv[curr][1], "mode", 4))
					{
						curr++;
						if (argc)
						{
							strncpy(fb_modename, argv[curr], 31);
							par+=2;
						} else par++;
					}
					else *cmdl++ = argv[curr];
					break;
#endif
#ifndef __QNX__
				case 'n':
					if (!memcmp(&argv[curr][1], "nom", 3))
					{
						mmx = -1;
						printf("MMX instruction disabled\n");
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				case 'l':
					if (!memcmp(&argv[curr][1], "lin", 3))
					{
						set_linear(1);
						printf("Linear addresing enabled\n");
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
#endif
				case 'f':
					if (!memcmp(&argv[curr][1], "ful", 3))
					{
						fulldrag = 1;
						printf("Full window drag enabled\n");
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				case 'h':
					printf("\n\n\n\tGraphics Engine 'FastGL' (c) Copyright 1996,99 RUMSOFT\n\n\t\t\tVersion %s - %s\n\n  --------------------------------------------------------------------------\n\n\tcommand line options :\n\n", VERZIA, __DATE__);
					printf("-resolution n\n");
					printf("          force scr. resolution 'n', where 'n' = \n");
					printf("          1=320x200, 2=640x480, 3=800x600, 4=1024x768, 5=1280x1024\n");
					printf("          6=1600x1200\n\n");
#ifndef __linux__
					printf("-driver n\n");
					printf("          force display driver to 'n' (if autodetect failed), where 'n' = \n");
					printf("          0=vesa, 1=cirrus, 2=trident, 3=old s3, 4=new s3, 5=mxic\n");
					printf("          6=tseng3000, 7=ati, 8=tseng4000, 9=chips&tech, 10=wd, 11=banshee\n");
					printf("          12=riva 128, 13=matrox, 14=permedia, 15=intel\n\n");
#else
					printf("-svga     don't use FRAMEBUFFER\n");
					printf("-mode n   use 'name' monitor timings (/etc/fb.modes)\n");
#endif
					printf("-nommx    don`t use MMX instruction set\n");
					printf("-full     use full window dragging\n");
					printf("-verbose  verbose output\n");
					getchar();
					par++;
					break;
				case 'v':
					if (!memcmp(&argv[curr][1], "ver", 3))
					{
						verbose = 1;
						par++;
					}
					else *cmdl++ = argv[curr];
					break;
				default:
					*cmdl++ = argv[curr];
					break;
			}
			else *cmdl++ = argv[curr];
		}
	}
	argc -= par;
	Argv = argv;
	Argc = argc;

	if (video < 1 || video > 6)
		video = 1;
	if (driver < 0 || driver >= FG_LAST)
		driver = -1;

	if (!graph_set_mode(video))
	{
		printf("Fatal error: can't set graphics mode %d\n\a", video);
		exit(-2);
	}
	farby = new ColorSystem;
	if (verbose)
	{
		printf("Video mode %d\n", video);
		printf("VideoBase %x, VideoSelector %x\n", (int)videobase,(short)VideoSelector);
#ifndef __linux
		if (framebuffer) printf("framebuffer at addr 0x%x\n", framebuffer);
		else printf("framebuffer not found\n");
#endif
		printf("memory size %d KB\n", memorysize);
	}
	clear_frame_buffer(background);
	GuiEvent::InitUserEvent();
	SetDelayProc(0);
	SetTimerProc(0);
	farby->SetColorFuzzy(3);
	if (f&APP_ROOTWINDOW) Root = new Window(&Root);
}

App::~App()
{
	clear_frame_buffer(CBLACK);
	SetDelayProc(0);
	SetTimerProc(0);
        if (allBitmapCounter && verbose) IError("WARNING: Some non-released bitmaps encoutered !", 0);
	delete farby;
#ifndef __WATCOMC__
	if (mmx_state) printf("WARNING: MMX set/reset calling mismatch!\n");
#endif	
	if (flags&APP_WINDOWDATABASE) delete entryPoint;
	delete cCfg;
	if (Root) delete Root;
	DestroyWindow();
	delete [] queque;
	delete event;
	cApp = 0;
}

void App::Run(MainHwnd hwnd)
{
	for (;;)
	{
		event->GetUserEvent(1);	// do while ALT+X no pressed
		event->TranslateUserEvent();
		for (; quequeIndex;)
		{
			quequeIndex--;
			if (hwnd) hwnd(queque+quequeIndex);
			if (queque[quequeIndex].type == QUITEVENT)
				return; // force ret if QUITEVENT
			queque[quequeIndex].type = NOEVENT;
		}
	}
}

/*
   ** prepne na dalsie okno a ak treba tak aj na dalsiu aplikaciu
 */
void Window::nextwnd(void)
{
	BaseGui *p = 0;
	static int cnt = 0;

	if (nWnd <= 1 || current->GetStatus() & WMODAL)
	{
		WarningBeep(0);
		return;
	}
	for (;;)
	{
		if (BaseGui::counter > cnt) cnt++;
		else cnt = 0;
		p = BaseGui::FindId(first, cnt);
		if (!p)
			continue;
		if (current == p || p->GetType()==PSEUDOWINDOW)
			continue;
		break;
	}
	((Window *) p)->WindowFocus();
}

// draw only input text with/without cursor

void EditBox::draw(int f)
{
	char str[130];
	unsigned a = set_font(FONT0816);

	set_fcolor(CScheme->edit_back);
	Boxw(GetX() + 2 + w1, GetY() + 2, w2 - 4, GetH() - 4);
	strcpy(str, buf);
	if (passwd) 
	{
		char *x=str;
		while (*x)
		{
			if (*x != ' ') *x = '*';
			x++;
		}
	}
	set_colors(CScheme->edit_fore, CScheme->edit_back);
	str[maxpos+offset] = 0;
	if (f)
	{
		Textw(GetX() + w1 + pos * 8 + 2 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str + offset + pos);
		Boxw(GetX() + w1 + pos * 8 + 8, GetY() + 3, 2, GetH() - 6);
		str[pos+offset] = 0;
		Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str+offset);
	}
	else
	{
		Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), str+offset);
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
}

// draw all

void EditBox::draw(void)
{
	char str[130];
	char *spt=0;
	unsigned maxdl, ndl, dl, a = set_font(FONT0816), cp;
	Window *tmp = Window::GetCurrent();

	offset = pos = 0;
    TestRange();
	owner->Context();
	memset(str, ' ', sizeof(str));	// fill local buffer with spaces
	maxdl = dl = (w1 - 8) / 8;			// maximalny zobrazitelny pocet znakov
	ndl = strlen(GetName()) <= dl ? dl = strlen(GetName()) : dl;
	strncpy(str, GetName(), ndl);
	ndl = (maxdl-ndl)*8;
	str[dl] = 0;
	cp = ((GetStatus() == BDISABLED) ? CGRAY1 : (enum Colors)GetInk());
	set_colors(cp, GetPaper());
	Textw(GetX()+ndl, GetY() + 1 + (GetH() / 2 - fonth / 2), str);
	Underscore(ndl, 1 + GetH() / 2 - fonth / 2, GetPaper());
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			Underscore(ndl, 1 + GetH() / 2 - fonth / 2, GetInk());
		case BDISABLED:
			set_fcolor(CScheme->edit_fore);
			Boxw(GetX() + w1, GetY(), w2, GetH());
			set_fcolor(CScheme->edit_back);
			Vline(GetX() + w1 + w2 - 2, GetY() + 1, GetH() - 2);
			Hline(GetX() + 1 + w1, GetY() - 2 + GetH(), w2 - 2);
			set_fcolor(CGRAY3);
			Boxw(GetX() + 2 + w1, GetY() + 2, w2 - 4, GetH() - 4);
			set_fcolor(CScheme->edit_bord1);
			Rect(GetX() + w1, GetY(), w2, GetH());
			set_bcolor(CScheme->edit_bord2);
			set_fcolor(CScheme->edit_fore);
			switch (data_type)
			{
				case 0:
					sprintf(str, "%d", *(int *) ptr);
					spt = str;
					break;
				case 1:
					 strcpy(str,(char *)ptr);
					spt = str;
					break;
				case 2:
					sprintf(str, "%f", *(double *) ptr);
					spt = str;
					break;
			}
			spt[maxpos] = 0;	// print visible part only
			if (passwd) 
			{
				char *x=spt;
				while (*x)
				{
					if (*x != ' ') *x = '*';
					x++;
				}
			}
			Textw(GetX() + w1 + 8, GetY() + 1 + (GetH() / 2 - fonth / 2), spt);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
}

//
// vracia 1 na konci
//
int EditBox::inputproc(int c)
{
	char *s, *d;
	int i;

	draw(0); // cursor off
	if (first)
	{
		first = 0;
		if ((isprint(c) || c == DEL || c == BACKSP) && c < 256)
		{
			for (i = 0; i < size; buf[i++] = ' ');
			offset = pos = 0;
		}
	}

	switch (c)
	{
		case ESC:
			ininput = 0;
			SetStatus(BNORMAL);
			draw(); // draw final
			return -1;
		case CR:
			ininput = 0;
			switch (data_type)
			{
				case 0:
					int n;

					n = atoi(buf);
					{
						*(int *) ptr = n;
                        TestRange();
					}
					break;
				case 1:
					pos = size;
					while (pos)
					{
						if (buf[pos - 1] != ' ')
							break;
						pos--;
					}
					buf[pos]=0;
					strcpy((char *) ptr, buf);
					break;
				case 2:
					double d;

					d = atof(buf);
					{
						*(double *) ptr = d;
                        TestRange();
					}
					break;
			}
			SetStatus(BNORMAL);
			draw(); // draw final
			call_handler = GetHandler();
			return 1;
		case HOME:
			offset = pos = 0;
			break;
		case END:
			{
				pos = size;
				while (pos)
				{
					if (buf[pos - 1] != ' ')
						break;
					pos--;
				}
				offset = pos>maxpos?pos-maxpos:0;
				pos = pos-offset;
			}
			break;
		case BACKSP:
			if (pos+offset)
			{
				s = &buf[offset+pos--];
				d = s - 1;
				while (*s)
					*d++ = *s++;
				*d = ' ';
				if (offset) { offset--; pos++; }
			}
			break;
		case KLEFT:
			if (pos+offset)
			{
				if (pos) pos--;
				else if (offset) offset--;
			}
			break;
		case KRIGHT:
			if (pos+offset < size)
			{
				if (pos<maxpos) pos++;
				else { offset++; }
			}
			break;
		case DEL:
			if (pos+offset < size)
			{
				d = &buf[pos+offset];
				s = d + 1;
				while (*s)
					*d++ = *s++;
				buf[size - 1] = ' ';
			}
			break;

		default:
			if (pos+offset < size)
			{
				if ((c > 31) | (c < 128))
				{
					d = buf + sizeof(buf) -1;
					while(d>(buf+pos+offset))
					{
						*d = d[-1];
						d--;
					}
					*d = (char)c;
				}
				if (pos+offset < size)
				{
					if (pos<maxpos) pos++;
					else { offset++; }
				}
			}
			break;
	}
	buf[size] = 0;
	draw(1); // cursor on
	return 0;
}

// start input line
void EditBox::input(void)
{
	char str[130];
	int a = set_font(FONT0816);

	ininput = this;
	iline = GetY() + 1 + (GetH() / 2 - fonth / 2);
	icol = GetX() + w1 + 8;
	switch (data_type)
	{
		case 0:
			sprintf(str, "%d", *(int *) ptr);
			break;
		case 1:
			strcpy(str, (const char *) ptr);
			break;
		case 2:
			sprintf(str, "%f", *(double *) ptr);
			break;
	}
	// copy to buffer (and fill it) and find the end of line
	for (int j = 0, i = 0; i < (int)sizeof(buf);)
		if (str[j] == 0)
			buf[i++] = ' ';
		else
			buf[i++] = str[j++];
	buf[size] = 0;
	pos = size-1;
	while (pos >= 0)
	{
		if (buf[pos] > ' ')
			break;
		pos--;
	}
	pos++;
	offset = pos>maxpos?pos-maxpos:0;
	pos -= offset;
	first = 1;
	set_font(a);
}

EditBox::EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	int *pt, int ink, int paper, Widget f, int mn, int mx, int check)
	: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
    check_range = check;
	min= mn;
	max=mx;
	data_type=0;
	size = maxpos=(ws2-16)/fontw;
	offset = 0;
	passwd = 0;
	draw();
	set_font(a);
}
			
EditBox::EditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, Window	*w,	char *pt, int ink, int paper, Widget f)
: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
	data_type=1;
	size = maxpos=(ws2-16)/fontw;
	offset = 0;
	passwd = 0;
	draw();
	set_font(a);
}
			
EditBox::EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	double *pt, int	ink, int paper,	Widget f, double mn, double mx, int check)
: Control(xs, ys, ws1+ws2, 21, nm, EDITBOX,	key, BNORMAL, w, f,paper,ink)
{
	int a = set_font(FONT0816);
	w1 = ws1;
	w2 = ws2;
	ptr= pt;
    check_range = check;
	mind= mn;
	maxd=mx;
	data_type=2;
	size = maxpos=(ws2-16)/fontw;
	offset = 0;
	passwd = 0;
	draw();
	set_font(a);
}

void EditBox::ClickUp(int a)	// if TRUE, so call handler
{
	if (!a || ininput)
		return;
	Window *tmp = Window::GetCurrent();
	owner->Context();
	SetStatus(BPUSHED);
	input();
	draw(1);
	tmp->Context();
}

void BaseMenu::MoveOut(void)
{
	owner->Context();
	draw();
}

void BaseMenu::MoveIn(void)
{
	unsigned a = set_font(FONT0816);

	owner->Context();
	if (GetType() == MENUBUTTON)
	{
		set_fcolor(CScheme->menu_back_active);
		Boxw(GetX(), GetY()-2, GetW(), MENUH/*GetH()*/);
		set_bcolor(CScheme->menu_back_active);
		set_fcolor(CScheme->menu_fore_active);
		Textw(GetX()+4, GetY(), GetName());
		Underscore(4,0,CWHITE);
		set_font(a);
		owner->WindowRepaint(GetX()-4, GetY()-2, GetW()+8, MENUH);
	}
	else
	{
		set_fcolor(CScheme->pdmenu_back_active);
		Boxw(GetX()-4, GetY(), GetW()+8, GetH());
		set_bcolor(CScheme->pdmenu_back_active);
		set_fcolor(CScheme->pdmenu_fore_active);
		Textw(GetX()+4, GetY()+1, GetName());
		Underscore(4,1,CScheme->pdmenu_fore_active);
		set_font(a);
		owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
	}
}

void Control::Underscore(int xo, int yo, int c)
{
	char *s;
	if (key==0) return;
	set_fcolor(c);
	if ((s = strchr(GetName(), key)) != 0)
	{
		s = s - (int) GetName();
		Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
	}
	else if ((s = strchr(GetName(), key ^ 32)) != 0)
	{
		s = s - (int) GetName();
		Boxw(GetX() + (int) s * 8+xo-1, GetY()+13+yo, 9,1);
	}
}

void BaseMenu::draw(void)
{
	unsigned a = set_font(FONT0816);
	Window *tmp = Window::GetCurrent();

	owner->Context();
	switch (GetStatus() & 7)
	{
		case BNORMAL:
			set_fcolor(GetPaper());
			if (GetType() == MENUBUTTON)
			{
				Boxw(GetX(), GetY()-2, GetW(), MENUH/*GetH()*/);
				set_bcolor(GetPaper());
				set_fcolor(GetInk());
				Textw(GetX()+4, GetY(), GetName());
				Underscore(4,0,GetInk());
				owner->WindowRepaint(GetX()-4, GetY()-2, GetW()+8, MENUH);
			}
			else
			{
				Boxw(GetX()-4, GetY(), GetW()+8, GetH());
				set_bcolor(GetPaper());
				set_fcolor(GetInk());
				Textw(GetX()+4, GetY()+1, GetName());
				Underscore(4,1,GetInk());
				owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
			}
			break;
		case BDISABLED:
			set_bcolor(GetPaper());
			set_fcolor(CScheme->pdmenu_gray);
			Textw(GetX()+4, GetY(), GetName());
			Underscore(4,0,GetPaper());
			Underscore(4,1,GetPaper());
			owner->WindowRepaint(GetX()-4, GetY(), GetW()+8, GetH());
			break;
	}
	set_font(a);
	tmp->Context();
}

int Window::GetXM(int a)
{
	if (!(GetStatus() & WMENU))
	{
		cprintf("You must use WMENU option for this window\n");
	}
	c_menupos += a;
	return c_menupos - a;
}

int Window::GetYM()
{
	return -(MENUH-1);
}

void Window::WindowResize(int dx, int dy)
{
	int w = GetW(), h = GetH();

	c_menupos = 1;
	if (w + dx > X_width || w + dx < 32 || h + dy > Y_width || h + dy < (BASEBORDER*2+TITLEH+MENUH+STATUSBARH))
	{
		return;
	}

	SetStatus(GetStatus() | WHIDEN);
	XWaitRetrace();
	draw();
	delete image;
	delete save;

	assert(image = new char[areasize(w + dx, h + dy)]);
	assert(save = new char[areasize(w + dx, h + dy)]);

	Resize(dx, dy);
	wwrk += dx;
	hwrk += dy;
	wsur += dx;
	hsur += dy;
	xpos = 1;
	ypos = 0;
	Context();
	SetStatus(GetStatus() & (~WHIDEN));
	draw();
	XWaitPeriod();
}

void Bitmap::turn_bitmap(int cnt, char *from, char *to)
{
	char *p = new char[w];

	for (int i = 0; i < cnt; i++)
	{
		memmove(p, to - (i * w), w);
		memmove(to - (i * w), from + (i * w), w);
		memmove(from + (i * w), p, w);
	}
	delete p;
}

Bitmap::Bitmap(int ww, int hh, int color)
{
	type = BMP_MEM;
	cUsedTable = 0;
	name = 0;
	allBitmapCounter++;
	memset(&bmih, color, sizeof(bmih));
	w = w_real = (ww+3)&0xfffc;
	h = hh;
	assert(bitmap = (char *) calloc(w * h, 1));
}

Bitmap::Bitmap(Window *wPtr)
{
	type = BMP_MEM;
	cUsedTable = 0;
	name = 0;
	allBitmapCounter++;
	memset(&bmih, 0, sizeof(bmih));
	w = w_real = (wPtr->GetW()+3)&0xfffc;
	h = wPtr->GetH();
	assert(bitmap = (char *) malloc(w * h));
	memcpy(bitmap, wPtr->GetArray(), w*h);
}

void Window::WindowPutBitmap(int x, int y, int xs, int ys, int w, int h, Bitmap * p)
{
	Window *tmp = current;
	int ww, hh;

	if (p->type == BMP_NONE) return;
	x += xwrk;
	y += ywrk;
   	if (y >= hwrk || x >= wwrk)
   		return;
   	if ((y + h) <= ywrk || (x + w) <= xwrk)
   		return;
	Context();
	if (w <= p->GetWREAL() && h <= p->GetH()) // cielove okno je mensie nez bitmapa
	{
	    if ((x + w) > cx_maxwork)
		   w -= ((x + w) - cx_maxwork);
        if ((y + h) > cy_maxwork)
		   h -= ((y + h) - cy_maxwork);
       	if ((x + w) > cx_work && x < cx_work)
	    {
		    w = ((x + w) - cx_work);
          	xs+= (cx_work-x);
		    x = cx_work;
        }
	    if ((y + h) > cy_work && y < cy_work)
	    {
		    h = ((y + h) - cy_work);
          	ys+= (cy_work-y); // kresli sa menej aj z bitmapy
		    y = cy_work;
        }
		RamToRam(xs, ys, p->GetWREAL(), p->GetH(), x, y, GetW(), GetH(), w, h, p->GetArray(), image);
	}
	else
	{
		for (int i = 0; i <= (h / p->GetH()); i++)
			for (int j = 0; j <= (w / p->GetWREAL()); j++)
			{
				ww = j == (w / p->GetWREAL())? w % p->GetWREAL() : p->GetWREAL();
				hh = i == (h / p->GetH())? h % p->GetH() : p->GetH();
				RamToRam(xs, ys, p->GetW(), p->GetH(), x + j * p->GetWREAL(), y + i * p->GetH(), GetW(), GetH(), ww, hh, p->GetArray(), image);
			}
	}
	WindowRepaint(x, y, w, h);
	tmp->Context();
}

void Window::WindowGetBitmap(int x, int y, int xs, int ys, int w, int h, Bitmap * p)
{
	Window *tmp = current;

	if (p->type == BMP_NONE)
		return;
	Context();
	x += xwrk;
	y += ywrk;
	RamToRam(x, y, GetW(), GetH(), xs, ys, p->GetW(), p->GetH(), w, h, image, p->GetArray());
	tmp->Context();
}

int Bitmap::BitmapSave(char *nazov)
{
	char tmpname[40];
	int i;

	if (type == BMP_NONE) return 0;
	sprintf(tmpname, "%s.bmp", nazov);

	bmfh.usType = 'M'*256 + 'B';
	bmfh.cbSize = w*h+1024+0x36;
	bmfh.reserve1 = 0;
	bmfh.reserve2 = 0;

	bmi.imageOffset = 0x36+0x400;
	bmi.reserve = 0;

	bmih.bmih2.size = 0x28;
	bmih.bmih2.cx   = w;
	bmih.bmih2.cy   = h;
	bmih.bmih2.cPlanes = 1;
	bmih.bmih2.cBitCount = 8;
	bmih.bmih2.ulCompression = 0;
	bmih.bmih2.cbImage = w*h;
	bmih.bmih2.cxResolution = 0;
	bmih.bmih2.cyResolution = 0;
	bmih.bmih2.cclrUsed = 256;
	bmih.bmih2.cclrImportant = 256;

	for (i=0; i<256; i++)
	{
	 	rgb.rgb4[i].fcOptions = 0;
	 	GetColor(rgb.rgb4[i].bRed,	rgb.rgb4[i].bGreen, rgb.rgb4[i].bBlue, i);
	 	rgb.rgb4[i].bRed <<= 2;
		rgb.rgb4[i].bGreen <<= 2;
 		rgb.rgb4[i].bBlue <<= 2;
	}

	FILE *fp = fopen(tmpname, "wb");
	if (fp == 0) return 0;
	fwrite(&bmfh, sizeof(bmfh), 1, fp);
	fwrite(&bmi, sizeof(bmi), 1, fp);
	fwrite(&bmih, sizeof(bmih.bmih2), 1, fp);
	fwrite(&rgb, sizeof(rgb.rgb4), 1, fp);
	turn_bitmap(h / 2, bitmap, bitmap + w * (h - 1));
	fwrite(bitmap, w*h, 1, fp);
	turn_bitmap(h / 2, bitmap, bitmap + w * (h - 1));
	fclose(fp);

	return 1;
}

Window *errWindow = 0;

void myOk(void)
{
	delete errWindow;
	errWindow = 0;
}

void myAbort(void)
{
	delete errWindow;
	errWindow = 0;
	App::AppDone();
}

void IError(char *s, int flag)
{
	int w = (strlen(s) + 8) * 4;

	if (errWindow) return;
	if (inGraph)
	{
		int a =set_font(FONT0816);
		w = w < 75 ? 75 : w;
		WarningBeep(0);
		new Window(&errWindow, 0, 0, w * 2, 78, "Error", GuiHwnd(0), CWHITE, CREDLIGHT, WMODAL | WMODAL | WCENTRED);
		if (flag) errWindow->WindowText(w - 70, 8, "* * * ERROR * * *", CYELLOW);
		else errWindow->WindowText(w - 78, 8, "* * * WARNING * * *", CYELLOW);
		errWindow->WindowText(32, 28, s, CWHITE);
		errWindow->WindowRect(0,0,2*w,78,0);
		if (flag) errWindow->AddPushButton(w - 40, 48, 80, 21, "Abort", CR, myAbort);
		else errWindow->AddPushButton(w - 40, 48, 80, 21, "Ok", CR, myOk);
		set_font(a);
	}
	else IErrorText(s, flag);
#ifndef __MSDOS__
	if (verbose) printf("IError:: %s\n", s);
#endif	
}

static FILE *f;

WindowDatabase::WindowDatabase()
{
    ::f = fopen("windowxy.db", "rb");
    if (::f)
	{
		fread(&xyCounter, sizeof(int), 1,::f);
		if (xyCounter<1 || xyCounter>100) 
		{
			remove("windowxy.db");
			endpointer = &first;
			return; // possibly damaged config
		}
		WindowItem **previous = &first;

		for (int i = 0; i < xyCounter; i++)
		{
			*previous = new WindowItem();
			previous = &((*previous)->next);
		}
		*previous = 0;
		endpointer = previous;
		fclose(::f);
	}
	else
	{
		endpointer = &first;
	}
}

WindowDatabase::~WindowDatabase()
{
	if (xyCounter <= 0)
		return;
    ::f = fopen("windowxy.db", "wb");
    if (::f)
	{
		WindowItem *p = first, *pp;
		fwrite(&xyCounter, sizeof(int), 1,::f);

		for (int i = 0; i < xyCounter; i++)
		{
			pp = p->next;
			delete p;
			p = pp;
		}
		fclose(::f);
	}
}

WindowItem *WindowDatabase::find(char *s)
{
	WindowItem *p = first;

	for (int i = xyCounter; i; --i)
	{
		if (!strcmp(p->name, s))
			return p;
		p = p->next;
	}
	return 0;
}

WindowItem::WindowItem()
{
	char s[80],*p=s;
	int	c;
	fread(&x,sizeof(int),1,::f);
	fread(&y,sizeof(int),1,::f);
	fread(&w,sizeof(int),1,::f);
	fread(&h,sizeof(int),1,::f);
	while ((c=fgetc(::f)) != 0)	*p++=(char)c;
	*p=0;
	name = new char[strlen(s)+1];
	strcpy(name,s);
}
WindowItem::WindowItem(int xx, int yy, int ww, int hh, char	*s)
{
	x=xx;
	y=yy;
	w=ww;
	h=hh;
	name = new char[strlen(s)+1];
	strcpy(name,s);
}

WindowItem::~WindowItem()
{
	fwrite(&x,sizeof(int),1,::f);
	fwrite(&y,sizeof(int),1,::f);
	fwrite(&w,sizeof(int),1,::f);
	fwrite(&h,sizeof(int),1,::f);
	fputs(name,::f);
	fputc(0,::f);
	delete name;
}

void WindowDatabase::Add(int &xx, int &yy, int &ww, int &hh, char *s, int fl)
{
	WindowItem *w;

	if (!(cApp->flags&APP_WINDOWDATABASE)) return;

	if (strlen(s) == 0)
		return;

	if ((w = find(s))==0)
	{
		*endpointer = new WindowItem(xx, yy, ww, hh, s);
		endpointer = &((*endpointer)->next);
		*endpointer = 0;
		xyCounter++;
	}
	else if (fl&WUSELAST)
	{
		xx = w->x;
		yy = w->y;
		if (fl&WSIZEABLE)
		{
			ww = w->w;
			hh = w->h;
		}
	}
}

void WindowDatabase::DatabaseResize(int xx, int yy, char *s)
{
	WindowItem *w = find(s);

	if (w)
	{
		w->w = xx;
		w->h = yy;
	}
}

void WindowDatabase::DatabaseRelocate(int xx, int yy, char *s)
{
	if (!(cApp->flags&APP_WINDOWDATABASE)) return;

	WindowItem *w = find(s);

	if (w)
	{
		w->x = xx;
		w->y = yy;
	}
}

//  WARNING colors are in range 0..63 !!!

int ColorSystem::CreateColor(int r, int g, int b)
{
	// first we look at current colors for identical (+-3%) color
	int i, r0, g0, b0, first = 0;

	r &= 0x3F;
	g &= 0x3F;
	b &= 0x3F;
	for (i = 0; i < 256; i++)
	{
		r0 = ColorsArray[i].r;
		g0 = ColorsArray[i].g;
		b0 = ColorsArray[i].b;
		if (ColorsArray[i].alfa)	// is existing colors ?
		{
			if ((r0 - range <= r && r0 + range >= r)
				&& (g0 - range <= g && g0 + range >= g)
				&& (b0 - range <= b && b0 + range >= b))
			{
				// WOW !!! we founds loved color ...
				first = i;
				if (r0 == r && g0 == g && b0 == b)	// must be equivalent
				{
					ColorsArray[i].alfa++;
					return i;	// return palette index
				}
			}
		}
	}

	if (first)
	{
		ColorsArray[first].alfa++;
		return first;			// return palette index
	}

	// we must create new palette entry for your color

	if (colorsFree == 0)
		return -1;				// ERROR I haven't any palette entry for one

	colorsFree--;
	for (i = startFree; i < 256; i++)
	{
		if (ColorsArray[i].alfa == 0)	// is free color ?
		{
			CreatePaletteEntry(r, g, b, i);
			return i;
		}
	}
	return -2;					// ERROR - data mismatch !!!
}

//  WARNING colors are in range 0..63 !!!

int ColorSystem::CreateColor(int r, int g, int b, int ind)
{
	r &= 0x3F;
	g &= 0x3F;
	b &= 0x3F;
	CreatePaletteEntry(r, g, b, ind);
	if (ColorsArray[ind].alfa>1)	return ind;	// return palette index

	if (colorsFree == 0)
		return -1;				// ERROR I haven't any palette entry for one

	colorsFree--;
	return ind;					// ERROR - data mismatch !!!
}

void GetColor( char &r, char &g, char &b, int i)
{
	cApp->farby->GetPaletteEntry(r, g, b, i);
}

int CreateColor(int r, int g, int b)
{
	return cApp->farby->CreateColor(r, g, b);
}

int CreateColor(int r, int g, int b, int index)
{
	return cApp->farby->CreateColor(r, g, b, index);
}

void DeleteColor(int r)
{
	cApp->farby->DeleteColor(r);
}

int GetFreeColors(void)
{
	return cApp->farby->GetFreeColors();
}

void SetColorFuzzy(int a)
{
	cApp->farby->SetColorFuzzy(a);
}

void Bitmap::BitmapDraw(int a, int b, int c, int d)
{
	int ww, hh;

	if (type)
	{
		if (c == -1)
		{
			c = w_real;
			d = h;
		}
		int a1 = cx_max, b1 = cy_max;
		void *ptr = Image;

		cx_max = w;
		cy_max = h;
		Image = bitmap;
		if (c <= w_real && d <= h)
		{
			RamToVideo(0, 0, a, b, c, d);
		}
		else
		{
			for (int i = 0; i <= (d / h); i++)
				for (int j = 0; j <= (c / w_real); j++)
				{
					ww = j == (c / w_real) ? c % w_real : w_real;
					hh = i == (d / h) ? d % h : h;
					RamToVideo(0, 0, a + j * w_real, b + i * h, ww, hh);
				}
		}
		cx_max = a1;
		cy_max = b1;
		Image = (char *) ptr;
	}
}

// vykresli titulok okna
void Window::DrawTitleMem(int color)
{
	int a = set_font(FONT0816), fr = 0;

	set_ppop(_GSET);
	if (GetStatus() & WFRAMED)
		fr = BASEBORDER-1;
	set_fcolor(color);
	set_bcolor(color);

	if (GetStatus() & WTITLED) // modry/hnedy titulok
	{
		Boxw(fr, fr, GetW() - (fr + fr)-(GetStatus() & WNOPICTO?0:40), TITLEH);
		set_fcolor(CWHITE);
		Boxw(fr, fr+TITLEH-1, GetW() - (fr + fr)-(GetStatus() & WNOPICTO?0:40), 1);
		Boxw(GetW()-((GetStatus() & WNOPICTO) ? ((GetStatus() & WFRAMED) ?4:0) : PICTOSIZE*2+4), fr, 1, TITLEH);
		Textw(5 + fr, fr + 2, skipstr(GetName()));
		if (!(GetStatus() & WNOPICTO))
		{
			PiktoMem(GetW() - PICTOSIZE*2-3, fr, GetW(), GetH());
		}
		if (IsVisible()) RepaintBlock(0, 0, GetW(), BASEBORDER+TITLEH);
	}
	else if (GetStatus() & WFRAMED) // bez titulku
	{
		Rect(0, 0, GetW(), GetH());
		Rect(1, 1, GetW()-2, GetH()-2);
		if (IsVisible())
		{
			RepaintBlock(0, 0, GetW(), 2);
			RepaintBlock(0, 0, 2, GetH());
			RepaintBlock(GetW()-2, 0, 2, GetH());
			RepaintBlock(0, GetH()-2, GetW(), 2);
		}
	}
	set_font(a);
}

// nakresli okno
void Window::draw(void)
{
    int ff = GetStatus() & WFRAMED;
	int	tt = GetStatus() & WTITLED;
	int	pp = GetStatus() & WNOPICTO;
	int	mm = GetStatus() & WMENU;
	int	mw = GetStatus() & WMENUWINDOWTYPE;
	int	ss = GetStatus() & WSTATUSBAR;
	int vs = BASEBORDER, vrch;

	set_ppop(_GSET);
	if (IsVisible())			// ak nieje hiden
	{
		Image = save;
		VideoToRam(GetX(), GetY(), 0, 0, GetW(), GetH());	// snimaj obrazovku
		Image = image;
		if (tt) vs+=(TITLEH+2);
		if (mm) vs+=MENUH;
		vrch=vs;
		if (ss) vs+=STATUSBARH;

        if (!ff)  // ak nemas FRAME, potom urob podklad pod titulok
        {
        	vs -= 2;
        	vrch -= BASEBORDER;
        	if (tt) memset(Image+cx_max * TITLEH, 0, cx_max); // standard
        	else memset(Image+cx_max * TITLEH, GetPaper(), cx_max); // standard
        }
		if (!ff && !pp && tt)
		{
			memset(Image, BORD3, cx_max * TITLEH); // standard
		}
    	else if (!tt) memset(Image, GetPaper(), cx_max * TITLEH);

		if (ff)
		{
			memset(Image, BORD3, cx_max * cy_max); // standard
		    set_fcolor(BORD1);
		    Boxw(0, 0, GetW()-1, 1);
		    Boxw(0, 0, 1, GetH()-1);
		    set_fcolor(BORD2);
		    Boxw(0, GetH()-1, GetW(), 1);
		    Boxw(GetW()-1, 0, 1, GetH()-1);
		    set_fcolor(GetPaper());
			if (!mw)
			{
			    Boxw(BASEBORDER, vrch, GetW()-BASEBORDER*2, GetH()-BASEBORDER-vs);
			    set_fcolor(CWHITE);
		    	Rectw(BASEBORDER-1, vrch-1, GetW()-BASEBORDER*2+2, GetH()-BASEBORDER-vs+2);
			    set_fcolor(CBLACK);
			    Boxw(BASEBORDER-1, vrch-1, GetW()-BASEBORDER*2+2,1);
			    Boxw(BASEBORDER-1, vrch-1, 1, GetH()-BASEBORDER-vs+2);
			}
			else Boxw(BASEBORDER-2, vrch-2, GetW()-BASEBORDER*2+4, GetH()-BASEBORDER-vs+4);
		}
	    else memset(Image+cx_max*TITLEH +cx_max, GetPaper(), cx_max * (cy_max-TITLEH-1)); // standard

		DrawTitleMem(CTITLEACTIVE);

		if (GetStatus() & WSIZEABLE && ff)
		{
			set_fcolor(CYELLOW);
			Boxw(GetW() - 13, GetH() - 3, 12, 2);
			Boxw(GetW() - 3, GetH() - 13, 2, 12);
		}

		if (mm)
		{
			if (ff)
			{
				set_fcolor(CBLACK);
				Boxw(xwrk-1, ywrk - MENUH-2, GetW() - xwrk * 2+2, MENUH+2);
				set_fcolor(CWHITE);
			    Boxw(wwrk, vrch-MENUH, 1, MENUH+2);
			}
			else
			{
				set_fcolor(CBLACK);
				Boxw(xwrk, ywrk - MENUH-1-(tt?1:0), GetW() - xwrk * 2, MENUH+1+(tt?1:0));
			}
			set_fcolor(MENUBG);
			Boxw(xwrk, ywrk - MENUH-1, GetW() - xwrk * 2, MENUH);
		}
		if (ss)
		{
			if (ff)
			{
                set_fcolor(BORD2);
                Boxw(xwrk-1, GetH()-BASEBORDER-STATUSBARH+1, GetW() - xwrk * 2+1, STATUSBARH);
			    set_fcolor(BORD1);
			    Boxw(xwrk, GetH()-BASEBORDER-STATUSBARH+2, GetW() - xwrk * 2+1, STATUSBARH-1);
			    set_fcolor(statuscolor);
			    Boxw(xwrk, GetH()-BASEBORDER-STATUSBARH+2, GetW() - xwrk * 2, STATUSBARH-2);
            }
            else
			{
			    set_fcolor(statuscolor);
			    Boxw(0, GetH()-STATUSBARH, GetW(), STATUSBARH);
            }
		}
		BaseGui *pt = Buttony;

		while (pt)
		{
			((Control *) pt)->draw();
			pt = pt->GetNext();
		}
		RamToVideo(0, 0, GetX(), GetY(), GetW(), GetH());
	}
	else
	{
		Image = save;
		RamToVideo(0, 0, GetX(), GetY(), GetW(), GetH());
		Image = image;
	}
}

void Window::WindowStatusBar(int x, char *s, int color)
{
	Window *tmp = current;
	int y;
	x += (BASEBORDER+1);
	y  = GetH()-STATUSBARH+2-(GetStatus()&WFRAMED?BASEBORDER:0);
	set_bcolor(statuscolor);
	set_fcolor(color);
	Context();
	Textw(x, y, s);
	WindowRepaint(x, y, strlen(s) * fontw, fonth);
	tmp->Context();
}

void Window::Iconize(void)
{
	WindowStatus(WHIDE);
	if (GetLast()) ((Window *)GetLast())->WindowFocus();
}

void Window::WindowFillPolygon(int n, int p[][2], int col)
{
	Window *tmp = current;

	Context();
	psw.gc_xoffset = xwrk;
	psw.gc_yoffset = ywrk;
	psw.gc_xcliplo = 0; //xwrk;
	psw.gc_ycliplo = 0; //ywrk;
	psw.gc_xcliphi = GetWW();
	psw.gc_ycliphi = GetHW();

	psw.line = Line;
	psw.scan = Hline;

	if (col!=-1) set_fcolor(col);
	_FillPolygon(n, p, &psw);
	WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
	tmp->Context();
}

void Window::WindowDrawPolygon(int n, int p[][2], int col)
{
	Window *tmp = current;

	Context();
	psw.gc_xoffset = xwrk;
	psw.gc_yoffset = ywrk;
	psw.gc_xcliplo = 0; //xwrk;
	psw.gc_ycliplo = 0; //ywrk;
	psw.gc_xcliphi = GetWW();
	psw.gc_ycliphi = GetHW();

	psw.line = Line;
	psw.scan = Hline;

	if (col!=-1) set_fcolor(col);
	_DrawPolygon(n, p, &psw);
	WindowRepaint(xwrk,ywrk,GetWW(),GetHW());
	tmp->Context();
}

Bitmap::Bitmap(void *n)
{
	long i, one;
	unsigned long c;

	type = BMP_NONE;
	name = 0;
	cUsedTable = 0;
	n = (char *)n + sizeof(long);	// skip size of file
	memcpy(&bmfh, n, sizeof(bmfh));
	if (bmfh.usType != (unsigned short) ('M'*256 + 'B'))
	{
		IError("No BITMAP file!", 1);
		return;
	}
	memcpy(&bmi, (char *) n + sizeof(bmfh), sizeof(bmi));
	memset(&bmih, 0, sizeof(bmih));
	memcpy(&bmih, (char *) n + sizeof(bmfh) + sizeof(bmi), *((long *) ((char *) n + sizeof(bmfh) + sizeof(bmi))));
	if (bmih.bmih1.size == 0x0C)
		one = 3;
	else
		one = 4;

	c = (bmi.imageOffset - (bmih.bmih1.size + 14)) / one;	// compute numbers of used colors

	if (c == 0)
	{
		IError("True colors BMP not supported!", 1);
		return;
	}

	if (one == 3)
	{
                if (bmih.bmih1.ulCompression)
		{
			IError("No compressed BMP supported!", 1);
			return;
		}
		memcpy(&rgb, (char *) n + (sizeof(bmfh) + sizeof(bmi) + bmih.bmih1.size), sizeof(RGB3) * c);
		w = (bmih.bmih1.cx+3) & 0xFFFC;
		w_real = bmih.bmih1.cx & 0xFFFC;
		h = bmih.bmih1.cy;
		if (bmih.bmih1.cPlanes != 1 || bmih.bmih1.cBitCount != 8)
		{
			IError("Only 256 colors BMP supported!", 1);
			return;
		}
	}
	else if (one == 4)
	{
                if (bmih.bmih2.ulCompression)
		{
			IError("No compressed BMP supported!", 1);
			return;
		}
		memcpy(&rgb, (char *) n + sizeof(bmfh) + sizeof(bmi) + bmih.bmih2.size, sizeof(RGB4) * c);
		w = (bmih.bmih2.cx + 3) & 0xFFFC;
		w_real = bmih.bmih2.cx & 0xFFFC;
		h = bmih.bmih2.cy;
		if (bmih.bmih2.cPlanes != 1 || bmih.bmih2.cBitCount != 8)
		{
			IError("Only 256 colors BMP supported!", 1);
			return;
		}
	}

	type = BMP_IMAGE;
        
	bitmap = (char *) n + (bmfh.cbSize - w * h - 1);
	if (bmi.reserve!=2) turn_bitmap(h / 2, bitmap, bitmap + w * (h - 1));
	bmi.reserve = 2;  	// mark as turned

	cUsedTable = new long[256]; // init color table
	int sz = w * h, d;
	char *bm = bitmap;
	memset(cUsedTable, 0, sizeof(long) * 256);

	// calculate which colors is used in image

	for (i = 0; i < sz; i++)
	{
		cUsedTable[*bm++]++;
	}

	bm = bitmap;
	for (i = 0; i < 256; i++)
		if (cUsedTable[i])
		{
			d = *((long *) ((char *) &rgb + i * one));
			d >>= 2;
			d &= 0x3f3f3f;
			cUsedTable[i] = (char) CreateColor((char) (d >> 16), (char) (d >> 8), (char) d);	// white
		}
		else cUsedTable[i] = -1;
	// remapping colors

	for (i = 0; i < sz; i++)
	{
		bm[i] = (char)cUsedTable[bm[i]];
	}
	allBitmapCounter++;
}

/* read_RLE8_compressed_image:
 *  For reading the 8 bit RLE compressed BMP image format.
 */
static void read_RLE8_compressed_image(FILE *f, char *bmp, int w, int h)
{
   unsigned char count, val, val0;
   int j, pos, line;
   int eolflag, eopicflag;

   eopicflag = 0;
   line = h - 1;

	while (eopicflag == 0) {
    pos = 0;                               /* x position in bitmap */
    eolflag = 0;                           /* end of line flag */

    while ((eolflag == 0) && (eopicflag == 0)) {
	count = (char)getc(f);
	val = (char)getc(f);

	if (count > 0) {                    /* repeat pixel count times */
	    for (j=0;j<count;j++) {
	       bmp[line*w+pos] = val;
	       pos++;
	    }
	}
	else {
	    switch (val) {
	       case 0:                       /* end of line flag */
			  eolflag=1;
			  break;
	       case 1:                       /* end of picture flag */
			  eopicflag=1;
			  break;
	       case 2:                       /* displace picture */
			  count = (char)getc(f);
			  val = (char)getc(f);
			  pos += count;
			  line += val;
			  break;
	       default:                      /* read in absolute mode */
			  for (j=0; j<val; j++) {
			     val0 = (char)getc(f);
		    	 bmp[line*w+pos] = val0;
			     pos++;
			  }

			  if (j%2 == 1) val0 = (char)getc(f);    /* align on word boundary */
			  break;
	    }
	 }
	 if (pos > w) eolflag=1;
   }

   line--;
   if (line < 0) eopicflag = 1;
   }
}



Bitmap::Bitmap(char *n)
{
	long ys, i, one, compressed=0;
	unsigned long c;
	FILE *f;
	char nm[40], *n2 = n;

	type = BMP_NONE;
	cUsedTable = 0;				// no type , no table

	if (!strstr(n, ".bmp") && !strstr(n, ".BMP"))
	{
		strcpy(nm, n);
		strcat(nm, ".bmp");
		n = nm;
	}
	f = fopen(n, "rb");
	if (!f)
	{
		sprintf(nm, "Bitmap '%s' not found!", n2);
		IError(nm, 1);
		return;
	}
	name = new char[strlen(n) + 1];

	strcpy(name, n);

	fread(&bmfh, sizeof(bmfh), 1, f);	// read first 10 bytes

	// return if no BMP
	if (bmfh.usType != (unsigned short) ('M'*256 + 'B'))
	{
		delete name;

		fclose(f);
		IError("No BITMAP file!", 1);
		return;
	}

	fread(&bmi, sizeof(bmi), 1, f);		// read next 4 bytes

	memset(&bmih, 0, sizeof(bmih));
	fread(&bmih, 4, 1, f);		// read size of bitmap info header

	fread(&bmih.bmih1.cx, bmih.bmih1.size - 4, 1, f);	// if 0x0c then OS/2 bitmap

	if (bmih.bmih1.size == 0x0C)
		one = 3;
	else
		one = 4;

	c = (bmi.imageOffset - (bmih.bmih1.size + 14)) / one;	// compute numbers of used colors

	if (c == 0)
	{
		delete name;

		fclose(f);
		IError("True colors BMP not supported!", 1);
		return;
	}

	if (one == 3)
	{
		if ((compressed = bmih.bmih1.ulCompression)>1)
		{
			IError("No this compressed BMP supported!", 1);
			return;
		}
		fread(&rgb, sizeof(RGB3), c, f);
		w = (bmih.bmih1.cx+3) & 0xFFFC;
		w_real = bmih.bmih1.cx & 0xFFFC;
		h = bmih.bmih1.cy;
		if (bmih.bmih1.cPlanes != 1 || bmih.bmih1.cBitCount != 8)
		{
			delete name;
			fclose(f);
			IError("Only 256 colors BMP supported!", 1);
			return;
		}
	}
	else if (one == 4)
	{
		if ((compressed = bmih.bmih2.ulCompression)>1)
		{
			IError("No this compressed BMP supported!", 1);
			return;
		}
		fread(&rgb, sizeof(RGB4), c, f);
		w = (bmih.bmih2.cx + 3) & 0xFFFC;
		w_real = bmih.bmih2.cx & 0xFFFC;
		h = bmih.bmih2.cy;
		if (bmih.bmih2.cPlanes != 1 || bmih.bmih2.cBitCount != 8)
		{
			delete name;
			fclose(f);
			IError("Only 256 colors BMP supported!", 1);
			return;
		}
	}

	type = BMP_FILE;
	assert(bitmap = (char *) calloc(w * h, 1));

	if (!compressed) for (ys = h; ys; ys--)
	{
		fread(bitmap + (ys - 1) * w, w, 1, f);
	}
	else read_RLE8_compressed_image(f,bitmap,w,h);

	fgetc(f);
	fclose(f);

	cUsedTable = new long[256];
	int sz = w * h, d;
	char *bm = bitmap;
	memset(cUsedTable, 0, sizeof(long) * 256);	// reset color table

	// calculate which colors is used in image

	for (i = 0; i < sz; i++)
	{
		cUsedTable[*bm++]++;
	}

	bm = bitmap;
	// allocating colors

	for (i = 0; i < 256; i++)
		if (cUsedTable[i])
		{
			d = *((long *) ((char *) &rgb + i * one));
			d >>= 2;
			d &= 0x3f3f3f;
			cUsedTable[i] = (char) CreateColor((char) (d >> 16), (char) (d >> 8), (char) d);	// white
		}
		else cUsedTable[i] = -1;

	// remapping colors

	for (i = 0; i < sz; i++)
	{
		bm[i] = (char)cUsedTable[bm[i]];
	}
	allBitmapCounter++;
}

Bitmap::~Bitmap()
{
	if (type)
	{
		if (cUsedTable)
		{
			for (int i=0;i<256;i++) if (cUsedTable[i]!=-1) DeleteColor(cUsedTable[i]);
			delete cUsedTable;
		}
		if (name) delete name;
		if (type!=BMP_IMAGE) free(bitmap);
	}
	type = 0;
	allBitmapCounter--;
}

void Window::WindowSpline(int points[8])
{
	Window *tmp = current;
    #define NPTS   64

    int xpts[NPTS], ypts[NPTS];
    int i;

	Context();
	calc_spline(points, NPTS, xpts, ypts);

	for (i=1; i<NPTS; i++) 
	{
    	Line(xpts[i-1]+xwrk, ypts[i-1]+ywrk, xpts[i]+xwrk, ypts[i]+ywrk);
        if (ppop == _GXOR) Pixel(xpts[i]+xwrk, ypts[i]+ywrk);
	}
	WindowRepaint(xwrk, ywrk, wwrk, hwrk);
	tmp->Context();
}

void Window::FlushInput(void)
{
	if (ininput) // if input then emulate 'ENTER'
	{
		GuiEvent e(INPUTEVENT1, ininput->GetId());

		ininput->inputproc(CR);
		SendToWindow(&e);
	}
}

Window::Window(Bitmap *p) :
  BaseGui(0, 0, p->GetWREAL(), p->GetH(), 0, PSEUDOWINDOW, 0, 15, WLOCKED|WHIDEN)
{
	image  = p->GetArray();
	save = 0;
	itself = 0;
	handler = 0;
	Buttony = 0;
	lastButton = 0;
	nControls = 0;
	c_menupos = 1;
	cx_max = p->GetW();
	cy_max = p->GetH();
	xpos = 1;
	ypos = 0;
	ywrk = 0;
	xwrk = 0;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
}

Window::Window(int x, int y, int w, int h) :
  BaseGui(x, y, w, h, 0, PSEUDOWINDOW, 0, 15, WLOCKED|WHIDEN)
{
	save = 0;
	itself = 0;
	handler = 0;
	Buttony = 0;
	lastButton = 0;
	nControls = 0;
	c_menupos = 1;
	cx_max = w;
	cy_max = h;
	xpos = 1;
	ypos = 0;
	ywrk = 0;
	xwrk = 0;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
}

void SendEvent(Window *w, int event, int key, int x, int y)
{
	GuiEvent e(event,key,x,y);
	w->SendToWindow(&e);
}

void App::Timer(void)
{
	static unsigned int last=0,sec=0;
	if ((unsigned int)time(0) != last)
	{
		last = time(0);
		if (OnEverySecond) OnEverySecond(sec++);
	}
}

static void InitCRC(void)
{
  int I, J;
  unsigned int C;

  for (I=0;I<256;I++)
  {
    for (C=I,J=0;J<8;J++)
      C=(C & 1) ? (C>>1)^0xEDB88320L : (C>>1);
    CRCTab[I]=C;
  }
}

unsigned int CalculateCRC(unsigned StartCRC, void *Addr, unsigned Size)
{
  unsigned I;
  if (!StartCRC) InitCRC();
  for (I=0; I<Size; I++)
    StartCRC = CRCTab[(unsigned char)StartCRC ^ ((unsigned char*)Addr)[I]] ^ (StartCRC >> 8);
  return(StartCRC);
}

void Window::WindowSetWorkRect(int x,int y,int w,int h)
{
    int flag = GetStatus();
	xpos = 1;
	ypos = 0;
	ywrk = y;
	xwrk = x;
	wwrk = w + xwrk;
	hwrk = h + ywrk;
	hsur = hwrk - ((flag & WFRAMED) ? BASEBORDER : 0) + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk - ((flag & WFRAMED) ? BASEBORDER : 0);
}

void Window::WindowGetWorkRect(int& x,int& y,int& w,int& h)
{
	x = xwrk;
	y = ywrk;
	w = wwrk - xwrk;
	h = hwrk - ywrk;
}

//
// Configuration file handling	   (for fastgl)
//

int Config::find(char * s)
{
	for (int i=0;i<entries;i++)
	{
		if (!strcmp(pole[i].name,s)) return i;
	}
	return -1;
}

void Config::CreateEmpty(void)
{
	char s[100] = "; ";
	strcat(s,name);
	WriteComment(s);
	WriteComment(";<.......name of item..........> t <...body of item... (LF)");
	WriteComment("; where 'name' is string up to 32 chars length");
	WriteComment("; where 't' is one of 's'(tring), 'i(nt)' or 'd'(ouble)");
	WriteComment("; Warning! don't use TABs! & STRING MUST be enclosed in double \"\"");
	WriteComment("|..............................| T |.............................");
}

Config::Config(char * s)
{
	strncpy(name, s, 30);
	strcat(name, ".rc");
	change = 0;
	entries = 0;
	if (cApp->flags&APP_CFG && verbose) cprintf("Opening config file '%s'\n", name);
	f = fopen(name,"r");
	if (f)
	{
		ReadConfig();
		fclose(f);
	}
	else 
	{
		CreateEmpty();
	}
}
		
Config::~Config()
{
	if (cApp->flags&APP_CFG) WriteConfig();
}

void  Config::WriteComment(char * s)
{
	int i;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((i=find(s))==-1) pole[entries++].ModifyNode(s);
	else  pole[i].ModifyNode(s);
	change = 1;
}

void  Config::WriteInt(char * s, int i)
{
	int ii;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void  Config::WriteString(char * s, char * i)
{
	int ii;
	if (strlen(i)>127) return;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void  Config::WriteDouble(char * s, double i)
{
	int ii;
	if (entries>=MAX_CONF_ITEMS) return;
	if ((ii=find(s))==-1) pole[entries++].ModifyNode(s,i);
	else  pole[ii].ModifyNode(s,i);
	change = 1;
}

void Config::ReadConfig(void) 
{
	char s[256], *p, n[33], *t;
	int typ,i;
	double d;
	
	for(;entries<MAX_CONF_ITEMS;)
	{
		*s = 0;
		fgets(s,255,f);
		if (!*s) break;
		*(s+strlen(s)-1) = 0;
		p = s;
		t = n;
		if (!isalpha(s[0]) && *s != '_') 
		{
			pole[entries].ModifyNode(s);
		}
		else
		{
			while(isalnum(*p) || *p=='_') (*t++) = (*p++);
			*t = 0;
			switch(typ = s[33])
			{
				case _DOUBLE:
					d = atof(s+35);
					pole[entries].ModifyNode(n,d);
					break;
				case _INT:
					i = atoi(s+35);
					pole[entries].ModifyNode(n,i);
					break;
				case _STRING:
					t = s+36;
					while(*t!='"') t++;
					*t = 0;
					pole[entries].ModifyNode(n,s+36);
					break;
			}
		}
		entries++;
	}
}

void Config::WriteConfig(void) 
{
	char s[256];
	
	if (change==0) return;
	if (verbose) printf("Writing config file '%s'\n", name);
	f = fopen(name,"w");
	for(int i=0;i<entries;i++)
	{
		switch(pole[i].type)
		{
			case _COMMENT:
				fputs(pole[i].s,f);
				break;
			case _STRING:
				sprintf(s, "%-32s %c \"%s\"", pole[i].name, pole[i].type, pole[i].s);
				fputs(s,f);
				break;
			case _INT:
				sprintf(s, "%-32s %c %d", pole[i].name, pole[i].type, pole[i].i);
				fputs(s,f);
				break;
			case _DOUBLE:
				sprintf(s, "%-32s %c %f", pole[i].name, pole[i].type, pole[i].d);
				fputs(s,f);
				break;
		}
		fputc('\n',f);
	}
	fclose(f);
}

BaseGui::BaseGui(int xs, int ys, int ws, int hs, char *nm, int typ, int i, int p, long flag)
{
	assert(inGraph);
	set_ppop(_GSET);
	if (nm)
	{
		assert(name	 = new char[strlen(nm)+1]);
		strcpy(name,nm);
	}
	else
	{
		assert(name	 = new char[1]);
		*name=0;
	}
	if (typ==WINDOW	&& flag&WUSELAST) WindowDatabase::Add(xs, ys, ws, hs, name,flag);
	if (typ	!= PSEUDOWINDOW) PositionCheck(xs, ys, ws, hs);
	if (typ==WINDOW	&& flag&WCENTRED)
	{
		xs = (X_width-ws)/2;
		ys = (Y_width-hs)/2;
	}
	x =	xs;
	y =	ys;
	w =	ws;
	h =	hs;
	type = typ;
	if (flag&WSOLID)
	{
		paper=CWHITED;
		ink	 =CBLACK;
	}
	else
	{
		ink	= i;
		paper =	p;
	}
	if (!MOVEABLE) flag	|= WUNMOVED;
	status = flag;
	id = counter++;
	next = (BaseGui	*)0;
	parameter1 = -1;
}

void BaseGui::Rechain(BaseGui *l, BaseGui *n)  // place to object chain
{
	if (!n && !l) // no more windows ...
	{
	}
	else if	(n==(BaseGui *)0)	// last in queqe
	{
		l->next	= (BaseGui *)0;
	}
	else if	(l==(BaseGui *)0)	// first in queqe
	{
		n->last	= (BaseGui *)0;
	}
	else if	(n && l)
	{
		l->next	= n;
		n->last	= l;
	}
}

BaseGui::~BaseGui()
{
	BaseGui	*l,	*n;
	if (type ==	PSEUDOWINDOW) return;
	counter--;
	if (name) delete name;
	l =	last;
	n =	next;
	Rechain(l,n);
}

void Window::SendToWindow(GuiEvent *p)
{
	if (image==0) IError("Internal Error 1 (SendToWindow)",	1);
	else if	(handler)
	{
		p->wnd = this;
		handler(p);
	}
}

void MenuWindow::MenuWindowHandler(GuiEvent *p)
{
	if (Proc) Proc(p);
	if (CurrentMenu==0) return;
	switch(p->Type())
	{
		case KEYEVENT:
			if (p->Key() ==	KUP)
			{
			}
			if (p->Key() ==	KDOWN)
			{
			}
			if (p->Key() ==	CR)
			{
			}
			if (p->Key() !=	ESC) break;
			delete CurrentMenu;
			break;
		case ACCELEVENT:
			if (!(p->guiType ==	PUSHBUTTON || p->guiType ==	MENUBUTTON || p->guiType == MENUBUTTON2))  break;
		case LOSTFOCUSEVENT:
		case TERMINATEEVENT:
			delete CurrentMenu;
			break;
	}
}

Window::Window(Window **wp, int xs, int ys, int ws, int hs, char *nm, GuiHwnd hnd, int i, int p, int flag):
  BaseGui(xs, ys, ws, hs, nm, flag & WMENUWINDOWTYPE ? MENUWINDOW : WINDOW, i, p, flag|WEXIST)
{
	Window *lst;

	if (current) current->FlushInput();
	if (current) if (current->GetStatus()&WMENUWINDOWTYPE && GetCnt()>1)
	{
		GuiEvent e(TERMINATEEVENT);
		current->SendToWindow(&e);
	}
	assert(image = new char[areasize(GetW(), GetH())]);
	assert(save = new char[areasize(GetW(), GetH())]);

	if (wp) *wp = this;			// save pointer to itself
	itself = wp;
	
	handler = hnd;
	if (GetCnt() != 1)			// first window
	{
		lst = current;
	}
	else
	{
		lst = (Window *) 0;		// get addr of previous
		first = this;
	}
	current = this;
	nWnd++;
	Buttony = 0;
	lastButton = 0;
	nControls = 0;
	c_menupos = 1;
	SetLast(lst);
	Image = image;
	cx_max = GetW();
	cy_max = GetH();
	statuscolor = CScheme->statusbar;
	xpos = 1;
	ypos = 0;
	ywrk = 0;
	if (flag & WFRAMED)
		ywrk += BASEBORDER;
	if (flag & WTITLED)
		ywrk += (TITLEH+2);
	if (flag & WMENU)
		ywrk += (MENUH+1);

	xwrk = 0;
	if (flag & WFRAMED)
		xwrk += BASEBORDER;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	if (flag & WSTATUSBAR)
		hwrk -= STATUSBARH;

	hsur = hwrk - ((flag & WFRAMED) ? BASEBORDER : 0) + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
    
	wsur = wwrk - ((flag & WFRAMED) ? BASEBORDER : 0);
	if (lst)
	{
		GuiEvent e(LOSTFOCUSEVENT);
		lst->SendToWindow(&e);
		lst->WindowStatus(WDEACTIVE);
		lst->SetNext(this);
	}
	Context();
	draw();
	GuiEvent e(INITEVENT);
	set_fcolor(i);
	set_bcolor(p);
	SendToWindow(&e);
	if ((lst && flag & WLASTFOCUS) || (lst && lst->GetStatus() & WMODAL) && nWnd)
		lst->WindowFocus();
	set_fcolor(i);
	set_bcolor(p);
	idm = oldidm = 0;
	idw = oldidw = 0;
}

Window::Window(Window **wp):
  BaseGui(0, 0, X_width, Y_width, "Root", PSEUDOWINDOW, get_fcolor(), get_bcolor(), WEXIST)
{
	Window *lst;
	assert(!current);		// must be first
	assert(image = new char[areasize(GetW(), GetH())]);
	memset(image, 0, areasize(GetW(), GetH()));

	if (wp) *wp = this;			// save pointer to itself
	itself = wp;
	
	handler = 0;
	lst = (Window *) 0;		// get addr of previous
	first = this;
	current = this;
	nWnd++;
	Buttony = 0;
	lastButton = 0;
	nControls = 0;
	c_menupos = 1;
	SetLast(lst);
	Image = image;
	cx_max = GetW();
	cy_max = GetH();

	xpos = 1;
	ypos = 0;
	ywrk = 0;
	xwrk = 0;
	wwrk = cx_max - xwrk;
	hwrk = cy_max - xwrk;
	hsur = hwrk + xwrk - ywrk;
	if (hsur<fonth*2) hsur=fonth*2;
	wsur = wwrk;
	Context();
	DoRootWindow = 1;
}

void Window::RemoveControls(void)
{
	BaseGui *butony = Buttony, *butony2;
	while (butony)
	{
		butony2 = butony->GetNext();
		delete butony;
		butony = butony2;
	}
	GuiEvent::AutoRepeatEnd();
}

Window::~Window()
{
	BaseGui *l, *n;
	BaseGui *last, *novy;
	int flg=0;

	if (GetType() == PSEUDOWINDOW || image == 0) return;

	FlushInput();
	SetStatus(GetStatus()& ~WEXIST);
	GuiEvent e(TERMINATEEVENT);
	SendToWindow(&e);

	if (itself) *itself = 0;
	RemoveControls();
	last = GetLast();
	if (GetNext())				// mazane okno nieje posledne v retazci
	{
		if (OverWnd()) flg = OdkryOkno();
		WindowStatus(WHIDE);
		SetStatus(0);			// no anythings
		if (flg)
			ZakryOkno();
	}
	else if (nWnd>1 && last) // rusim neposledne aktivne okno
	{
		novy = last;
		WindowStatus(WHIDE);
		novy->SetNext(0);
		((Window *) novy)->WindowStatus(WACTIVE);
	}
	else
	{
		SetStatus(WHIDEN);
		WindowHide();
		delete image;
		image = 0;
		delete save;
		first = current = 0;
		nWnd  = 0;
		return;
	}
	nWnd--;
	l = GetLast();
	n = GetNext();
	if (n == (Window *) 0)		// last in queqe
	{
		current = (Window *) l;
	}
	else if (l == (Window *) 0)	// first in queqe
	{
		first = (Window *) n;
	}
	else
	{
	}
	delete image;
	image = 0;
	delete save;
	WindowInvalidate();
	idm = oldidm = 0;
	idw = oldidw = 0;
}

void ButtonGroup::AddToGroup(Control *p, int activ)
{
	int i;
	if (count>=32) return; // maximum numbers reached
	i = p->GetType();
	if (i!=BaseGui::POINTBUTTON && i!=BaseGui::CHECKBUTTON && i!=BaseGui::PUSHBUTTON) return; // bad type
	if (type==0) 
	{
	    if (i==BaseGui::CHECKBUTTON || i==BaseGui::POINTBUTTON) type=1;
	    else type=2;
	}
	else if (type==1 && i==BaseGui::PUSHBUTTON) IError("ButtonGroup mismatch",0);
	else if (type==2 && (i==BaseGui::POINTBUTTON || i==BaseGui::CHECKBUTTON)) IError("ButtonGroup mismatch",0);
	array[count++] = p;
	p->RegisterToGroup(this); // say to button for group members
	if (activ && !curr) 
	{
	    curr = p;
	    if (type==1) p->SetTrigger(1);
	    else ((PushButton *)p)->Push();
	}
}

void Control::RefreshGroup(void) 
{ 
	if (grp) 
		grp->RefreshGroup(this); 
	idm = oldidm = 0;
}

void ButtonGroup::RefreshGroup(Control *c)
{
	PushButton *pb1=(PushButton *)c;
	switch(type)
	{
		case 1:
			if (curr) curr->SetTrigger(0);
			if (curr == c) // to same
			{
				curr->SetTrigger(1);
			}
			break;
		case 2:
			if (curr) ((PushButton *)curr)->Release();
			pb1->Push();
			break;
	}
	curr = c;
}

void Slider::frame(int x, int y, int w, int h, int f)
{
	set_fcolor(f?CWHITE:CBLACK);
	Vline(x, y, h);
	Hline(x, y, w);
	set_fcolor(CGRAYED);
	Vline(x + w - 2, y + 1, h - 2);
	Hline(x + 1, y + h - 2, w - 2);
	set_fcolor(f?CBLACK:CWHITE);
	Vline(x + w - 1, y + 0, h - 0);
	Hline(x + 0, y + h - 1, w - 1);
}

void SlideBarH::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[40];
	unsigned dl=0, a = set_font(FONT0808), st;
	set_ppop(_GSET);
	owner->Context();
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			set_fcolor(CScheme->slider);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),dl=(maxv-minv)/steps+16+6,GetH());
			frame(GetX()+dl,GetY(),GetW()-dl,GetH());
			frame(GetX()+3+((*val-minv)/steps),GetY()+2,16,12,1);
			set_colors(CBLACK, CScheme->slider);
			sprintf(str, "%3d", *val);
			Textw(GetX()+dl+2,GetY()+4,str);
			break;

		case BDISABLED:
			set_fcolor(CGRAY2);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),dl=(maxv-minv)/steps+16+6,GetH());
			frame(GetX()+dl,GetY(),GetW()-dl,GetH());
			frame(GetX()+3+((*val-minv)/steps),GetY()+2,16,12,1);
			set_colors(CGRAY1, CGRAY2);
			sprintf(str, "%3d", *val);
			Textw(GetX()+dl+2,GetY()+4,str);
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
	if (fnc) fnc();
}

void SlideBarH::ClickMove(int dx, int)
{
	int value = dx-GetX()-3;
	if (value>= 0)
	{
	    *val = maxv;
	}
	else if (value < (maxv-minv)/steps+8)
	{
	    *val = minv;
	}
	if (value>= 0 && value < (maxv-minv)/steps)
	{
	    *val = minv+value*steps;
	}
	draw();
}

void SlideBarH::ClickDown(void)
{
	int dx=GetMouseX()-wnd->GetX();
	int value = dx-GetX()-3-8;
	if (value>= 0)
	{
	    *val = maxv;
	}
	else if (value < (maxv-minv)/steps+8)
	{
	    *val = minv;
	}
	if (value>= 0 && value < (maxv-minv)/steps)
	{
	    *val = minv+value*steps;
	}
	draw();
}

void SlideBarV::draw(void)
{
	Window *tmp = Window::GetCurrent();
	static char str[40];
	unsigned dl=0, a = set_font(FONT0808), st;
	set_ppop(_GSET);
	owner->Context();
	st = GetStatus();
	switch (st & 7)
	{
		case BNORMAL:
			set_fcolor(CScheme->slider);
			Boxw(GetX() + 1, GetY() + 1, GetW() - 3, GetH() - 3);
			frame(GetX(),GetY(),GetW(), dl=(maxv-minv)/steps+16+6);
			frame(GetX(),GetY()+dl,GetW(),GetH()-dl);
			frame(GetX()+2, GetY()+3+((*val-minv)/steps),12,16,1);
			set_colors(CBLACK, CScheme->slider);
			str[0] = char((*val%1000)/100+'0');
			str[1] = 0;
			str[2] = char((*val%100)/10+'0');
			str[3] = 0;
			str[4] = char(*val%10+'0');
			str[5] = 0;
			str[6] = char((*val%10000)/1000+'0');
			str[7] = 0;
			Textw(GetX()+4,GetY()+dl+3,str+6);
			Textw(GetX()+4,GetY()+dl+11,str);
			Textw(GetX()+4,GetY()+dl+19,str+2);
			Textw(GetX()+4,GetY()+dl+27,str+4);
			break;

		case BDISABLED:
			break;

		case BUNVISIBLE:
			set_fcolor(GetPaper());
			Boxw(GetX(), GetY(), GetW(), GetH());
			break;
	}
	set_font(a);
	owner->WindowRepaint(GetX(), GetY(), GetW(), GetH());
	tmp->Context();
	if (fnc) fnc();
}

void SlideBarV::ClickMove(int, int dy)
{
	int value = dy-GetY()-3;
	if (value>= 0)
	{
	    *val = maxv;
	}
	else if (value < (maxv-minv)/steps+8)
	{
	    *val = minv;
	}
	if (value>= 0 && value < (maxv-minv)/steps)
	{
	    *val = minv+value*steps;
	}
	draw();
}

void SlideBarV::ClickDown(void)
{
	int dy=GetMouseY()-wnd->GetY();
	int value = dy-GetY()-3-8;
	if (value>= 0)
	{
	    *val = maxv;
	}
	else if (value < (maxv-minv)/steps+8)
	{
	    *val = minv;
	}
	if (value>= 0 && value < (maxv-minv)/steps)
	{
	    *val = minv+value*steps;
	}
	draw();
}

int Config::ReadInt(char * s)
{
	int	n =	find(s);
	if (n>=0) return pole[n].i;
	return 0;
}

char const * Config::ReadString(char * s)
{
	int	n =	find(s);
	if (n>=0) return (char	const *)pole[n].s;
	return "";
}

double Config::ReadDouble(char * s)
{
	int	n =	find(s);
	if (n>=0) return pole[n].d;
	return 0.0;
}
	
int	   Config::ReadInt(char	* s, int &p)
{
	int	n =	find(s);
	if (n>=0) return p = pole[n].i, 1;
	return 0;
}

int	   Config::ReadString(char * s,	char *p, int max)
{
	int	n =	find(s);
	if (max>128) max = 128;
	if (n>=0)
	{
	 	strncpy(p,pole[n].s,max);
		return 1;
	}
	return 0;
}

int	   Config::ReadString(char * s,	char **p)
{
	int	n =	find(s);
	if (n>=0)
	{
	 	*p = pole[n].s;
		return 1;
	}
	return 0;
}

int	   Config::ReadDouble(char * s,	double &p)
{
	int	n =	find(s);
	if (n>=0) return p = pole[n].d, 1;
	return 0;
}

void ColorSystem::CreatePaletteEntry(int	rc,	int	gc,	int	bc,	int	idx)
{
 	ColorsArray[idx].r = (char)rc;
	ColorsArray[idx].g = (char)gc;
	ColorsArray[idx].b = (char)bc;
	ColorsArray[idx].alfa++; // incr used counter
	_palette(idx,bc+gc*256+rc*65536);
}

void ColorSystem::RefreshPalette(void)
{
	_set_fgl_palette();
}

PushButton *Window::AddPushButton(int xs, int ys, int ws, int hs, char *nm,	int	key, void	(*f)(void), int flag)
{
	return new PushButton(xs, ys, ws, hs, nm, key, flag,this,f);
}

PushButton *Window::AddPushButton(int xs, int ys, int key, Bitmap *bm, void	(*f)(void), int flag)
{
	if (bm->type==0) return	0;
	return new PushButton(xs, ys, key, flag,this,bm,f);
}

SlideBarH *Window::AddSlideBarH(int xs, int ys, int min, int max, int step, int *val, Widget f)
{
	return new SlideBarH(xs, ys, min, max, step, val, this,f);
}

SlideBarV *Window::AddSlideBarV(int xs, int ys, int min, int max, int step, int *val, Widget f)
{
	return new SlideBarV(xs, ys, min, max, step, val, this,f);
}

CheckButton	*Window::AddCheckButton(int	xs,	int	ys,	char *nm, int key, int * variable, void	(*f)(void), int flag)
{
	return new CheckButton(xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*Window::AddPointButton(int	xs,	int	ys,	char *nm, int key, int * variable, void	(*f)(void), int flag)
{
	return new PointButton(xs, ys, nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, char *p, Widget f)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f, double min, double max)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
}

EditBox	*Window::AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f)
{
	return new EditBox(xs, ys, ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0); // no checking
}

BaseMenu *Window::AddBaseMenu(char *nm,	int	key, Widget f)
{
	return new BaseMenu(GetXM(strlen(nm)*8+8), GetYM(),	strlen(nm)*8+8,	16,	nm,	key, this, CScheme->menu_back, CScheme->menu_fore, f, MENUBUTTON);
}

BaseMenu *MenuWindow::AddMenu(char *nm,	int	key, Widget f)
{
	return new BaseMenu(GetXM(), GetYM(18),	GetWW()-8, 18, nm, key,	this, GetPaper(), GetInk(), f, MENUBUTTON2);
}

CheckButton	*MenuWindow::AddCheckButton(char *nm, int key, int * variable, Widget f, int flag)
{
	return new CheckButton(GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

PointButton	*MenuWindow::AddPointButton(char *nm, int key, int * variable, Widget f, int flag)
{
	return new PointButton(GetXM(),	GetYM(18), nm, key,	flag,this,GetInk(),GetPaper(),f,variable);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max)
{
	return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(), f, min, max, 1);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f)
{
	return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this, p, GetInk(),GetPaper(), f, 0, 0, 0);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, char *p, Widget f)
{
	return new EditBox(GetXM(),	GetYM(24), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f, double min, double max)
{
	return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, min,	max, 1);
}

EditBox	*MenuWindow::AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f)
{
	return new EditBox(GetXM(),	GetYM(23), ws1,	ws2, nm, key, this,	p, GetInk(),GetPaper(),	f, 0, 0, 0);
}

void MenuWindow::Separator(void)
{
	int i;
	WindowBox(GetXM(), i=GetYM(7)+3, GetWW()-8, 1, CGRAYED);
	WindowBox(GetXM(), i+1, GetWW()-8, 1, CWHITED);
}

