
/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	fastgl.h   - declarations of many objects for FastGL 

*/
#ifndef	__WINDOW_H
#define	__WINDOW_H

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#ifdef __QNX__
#include <signal.h>
#include <process.h>
#include <sys/mouse.h>
#include <sys/dev.h>
#include <sys/proxy.h>
#include <sys/kernel.h>	
#include <unistd.h>	
#endif

#include "base.h"

#define	TRUE   1
#define	FALSE  0

#ifndef	M_PI
#define	M_PI	3.1415926
#endif

#ifdef __MSDOS__
#define	BACKSP	0x08
#define	KLEFT	0x24b
#define	KUP		0x248
#define	KDOWN	0x250
#define	KRIGHT	0x24d

#define	INSERT	0x252
#define	DEL		0x253
#define	HOME	0x247
#define	END		0x24f
#define	PGUP	0x249
#define	PGDOWN	0x251

#define ALT_A	286
#define ALT_B	304
#define ALT_C	302
#define ALT_D	288
#define ALT_E	274
#define ALT_F	289
#define ALT_G	290
#define ALT_H	291
#define ALT_I	279
#define ALT_J	292
#define ALT_K	293
#define ALT_L	294
#define ALT_M	306
#define ALT_N	305
#define ALT_O	280
#define ALT_P	281
#define ALT_Q	272
#define ALT_R	275
#define ALT_S	287
#define ALT_T	276
#define ALT_U	278
#define ALT_V	303
#define ALT_W	273
#define ALT_X	301
#define ALT_Y	277
#define	ALT_Z	300

#define	F01		315
#define	F02		316
#define	F03		317
#define	F04		318
#define	F05		319
#define	F06		320
#define	F07		321
#define	F08		322
#define	F09		323
#define	F10		324
#define	F11		389
#define	F12		390

#define	ALT_F01		360
#define	ALT_F02		(ALT_F01+1)
#define	ALT_F03		(ALT_F01+2)
#define	ALT_F04		(ALT_F01+3)
#define	ALT_F05		(ALT_F01+4)
#define	ALT_F06		(ALT_F01+5)
#define	ALT_F07		(ALT_F01+6)
#define	ALT_F08		(ALT_F01+7)
#define	ALT_F09		(ALT_F01+8)
#define	ALT_F10		(ALT_F01+9)
#define	ALT_F11		395
#define	ALT_F12		396

#define	CTRL_F01		350
#define	CTRL_F02		(CTRL_F01+1)
#define	CTRL_F03		(CTRL_F01+2)
#define	CTRL_F04		(CTRL_F01+3)
#define	CTRL_F05		(CTRL_F01+4)
#define	CTRL_F06		(CTRL_F01+5)
#define	CTRL_F07		(CTRL_F01+6)
#define	CTRL_F08		(CTRL_F01+7)
#define	CTRL_F09		(CTRL_F01+8)
#define	CTRL_F10		(CTRL_F01+9)
#define	CTRL_F11		393
#define	CTRL_F12		394

#define	ALT_UP		408
#define	ALT_DOWN	416
#define	ALT_RIGHT 	413
#define	ALT_LEFT	411

#define	ALT_TAB			421
#define	ALT_INSERT		418
#define	ALT_DEL			419
#define	ALT_HOME		407
#define	ALT_END			415
#define ALT_PGUP		409
#define ALT_PGDOWN		417

#define	CTRL_UP		(KUP+0x100)
#define	CTRL_DOWN	(KDOWN+0x100)
#define	CTRL_RIGHT 	(KRIGHT+0x100)
#define	CTRL_LEFT	(KLEFT+0x100)

#define	CTRL_TAB	0x194
#define	CTRL_INSERT		658
#define	CTRL_DEL		659
#define	CTRL_HOME		631
#define	CTRL_END		629
#define CTRL_PGUP	631
#define CTRL_PGDOWN	629
#endif

#ifdef	__linux__
#define	BACKSP		0x8
#define	KUP		0x232
#define	KDOWN	0x233
#define	KRIGHT	0x235
#define	KLEFT	0x234

#define	INSERT	0x222
#define	DEL		0x7F
#define	HOME		0x238
#define	END		0x239
#define	PGUP	0x236
#define	PGDOWN	0x237

#define ALT_A	0x1061
#define ALT_B	(ALT_A+1)
#define ALT_C	(ALT_A+2)
#define ALT_D	(ALT_A+3)
#define ALT_E	(ALT_A+4)
#define ALT_F	(ALT_A+5)
#define ALT_G	(ALT_A+6)
#define ALT_H	(ALT_A+7)
#define ALT_I	(ALT_A+8)
#define ALT_J	(ALT_A+9)
#define ALT_K	(ALT_A+10)
#define ALT_L	(ALT_A+11)
#define ALT_M	(ALT_A+12)
#define ALT_N	(ALT_A+13)
#define ALT_O	(ALT_A+14)
#define ALT_P	(ALT_A+15)
#define ALT_Q	(ALT_A+16)
#define ALT_R	(ALT_A+17)
#define ALT_S	(ALT_A+18)
#define ALT_T	(ALT_A+19)
#define ALT_U	(ALT_A+20)
#define ALT_V	(ALT_A+21)
#define ALT_W	(ALT_A+22)
#define ALT_X	(ALT_A+23)
#define ALT_Y	(ALT_A+24)
#define	ALT_Z	(ALT_A+25)

#define	F01		0x301
#define	F02		(F01+1)
#define	F03		(F01+2)
#define	F04		(F01+3)
#define	F05		(F01+4)
#define	F06		(F01+5)
#define	F07		(F01+6)
#define	F08		(F01+7)
#define	F09		(F01+8)
#define	F10		(F01+9)
#define	F11		(F01+10)
#define	F12		(F01+11)

#define	ALT_F01		0x1201
#define	ALT_F02		0x1202
#define	ALT_F03		0x1203
#define	ALT_F04		0x1204
#define	ALT_F05		0x1205
#define	ALT_F06		0x1206
#define	ALT_F07		0x1207
#define	ALT_F08		0x1208
#define	ALT_F09		0x1209
#define	ALT_F10		0x120a
#define	ALT_F11		0x120b
#define	ALT_F12		0x120c

#define	CTRL_F01		0x401
#define	CTRL_F02		0x402
#define	CTRL_F03		0x403
#define	CTRL_F04		0x404
#define	CTRL_F05		0x405
#define	CTRL_F06		0x406
#define	CTRL_F07		0x407
#define	CTRL_F08		0x408
#define	CTRL_F09		0x409
#define	CTRL_F10		0x40a
#define	CTRL_F11		0x40b
#define	CTRL_F12		0x40c

#define	ALT_UP		(KUP+0x1000)
#define	ALT_DOWN	(KDOWN+0x1000)
#define	ALT_RIGHT 	(KRIGHT+0x1000)
#define	ALT_LEFT	(KLEFT+0x1000)

#define	ALT_TAB			4105
#define	ALT_INSERT		4642
#define	ALT_DEL			4223
#define	ALT_HOME		4664
#define	ALT_END			4665
#define ALT_PGUP		4662
#define ALT_PGDOWN		4663

#define	CTRL_UP		(KUP+0x100)
#define	CTRL_DOWN	(KDOWN+0x100)
#define	CTRL_RIGHT 	(KRIGHT+0x100)
#define	CTRL_LEFT	(KLEFT+0x100)

#define	CTRL_TAB		0xFFF
#define	CTRL_INSERT		802
#define	CTRL_DEL		0x7F
#define	CTRL_HOME		824
#define	CTRL_END		825
#define CTRL_PGUP	(PGUP+0x100)
#define CTRL_PGDOWN	(PGDOWN+0x100)
#endif // linux

#ifdef __QNX__
#define	BACKSP	0x7f
#define	KUP		417
#define	KDOWN	425
#define	KRIGHT	422
#define	KLEFT	420

#define	INSERT	427
#define	DEL		428
#define	HOME	416
#define	END		424
#define	PGUP	418
#define	PGDOWN	426

#define ALT_A	481
#define ALT_B	(ALT_A+1)
#define ALT_C	(ALT_A+2)
#define ALT_D	(ALT_A+3)
#define ALT_E	(ALT_A+4)
#define ALT_F	(ALT_A+5)
#define ALT_G	(ALT_A+6)
#define ALT_H	(ALT_A+7)
#define ALT_I	(ALT_A+8)
#define ALT_J	(ALT_A+9)
#define ALT_K	(ALT_A+10)
#define ALT_L	(ALT_A+11)
#define ALT_M	(ALT_A+12)
#define ALT_N	(ALT_A+13)
#define ALT_O	(ALT_A+14)
#define ALT_P	(ALT_A+15)
#define ALT_Q	(ALT_A+16)
#define ALT_R	(ALT_A+17)
#define ALT_S	(ALT_A+18)
#define ALT_T	(ALT_A+19)
#define ALT_U	(ALT_A+20)
#define ALT_V	(ALT_A+21)
#define ALT_W	(ALT_A+22)
#define ALT_X	(ALT_A+23)
#define ALT_Y	(ALT_A+24)
#define	ALT_Z	(ALT_A+25)

#define	F01		385
#define	F02		386	
#define	F03		387	
#define	F04		388	
#define	F05		389	
#define	F06		390	
#define	F07		391	
#define	F08		392	
#define	F09		393	
#define	F10		394	
#define	F11		430	
#define	F12		431

#define	ALT_F01		465
#define	ALT_F02		(ALT_F01+1)
#define	ALT_F03		(ALT_F01+2)
#define	ALT_F04		(ALT_F01+3)
#define	ALT_F05		(ALT_F01+4)
#define	ALT_F06		(ALT_F01+5)
#define	ALT_F07		(ALT_F01+6)
#define	ALT_F08		(ALT_F01+7)
#define	ALT_F09		(ALT_F01+8)
#define	ALT_F10		(ALT_F01+9)
#define	ALT_F11		462
#define	ALT_F12		463

#define	CTRL_F01		405
#define	CTRL_F02		(CTRL_F01+1)
#define	CTRL_F03		(CTRL_F01+2)
#define	CTRL_F04		(CTRL_F01+3)
#define	CTRL_F05		(CTRL_F01+4)
#define	CTRL_F06		(CTRL_F01+5)
#define	CTRL_F07		(CTRL_F01+6)
#define	CTRL_F08		(CTRL_F01+7)
#define	CTRL_F09		(CTRL_F01+8)
#define	CTRL_F10		(CTRL_F01+9)
#define	CTRL_F11		446
#define	CTRL_F12		447

#define	ALT_UP	449
#define	ALT_DOWN	457
#define	ALT_RIGHT 454
#define	ALT_LEFT	 452

//#define	ALT_TAB		// not defined
#define	ALT_INSERT		459
#define	ALT_DEL			460
#define	ALT_HOME		448
#define	ALT_END			456
#define ALT_PGUP		450
#define ALT_PGDOWN		458

#define	CTRL_UP		433
#define	CTRL_DOWN	441
#define	CTRL_RIGHT 	438
#define	CTRL_LEFT	436

#define	CTRL_TAB		415
#define	CTRL_INSERT		443
#define	CTRL_DEL		444
#define	CTRL_HOME		432
#define	CTRL_END		440
#define CTRL_PGUP		434
#define CTRL_PGDOWN		442
#endif

#define CTRL_A	1
#define CTRL_B	2
#define CTRL_C	3
#define CTRL_D	4
#define CTRL_E	5
#define CTRL_F	6
#define CTRL_G	7
#define CTRL_H	8
#define CTRL_I	9
#define CTRL_J	10
#define CTRL_K	11
#define CTRL_L	12
#define CTRL_M	13
#define CTRL_N	14
#define CTRL_O	15
#define CTRL_P	16
#define CTRL_Q	17
#define CTRL_R	18
#define CTRL_S	19
#define CTRL_T	20
#define CTRL_U	21
#define CTRL_V	22
#define CTRL_W	23
#define CTRL_X	24
#define CTRL_Y	25
#define	CTRL_Z	26

#define	CR		13
#define	ESC		27
#define	TAB		9
#define	LF		10

enum typ_item {	_DOUBLE='d', _INT='i', _STRING='s',	_COMMENT='c' };

#define	MAX_CONF_ITEMS	500

enum events	{ NOEVENT, KEYEVENT, MOUSEEVENT, QUITEVENT, ACCELEVENT,
	  TERMINATEEVENT, RESIZEEVENT, INPUTEVENT1, INPUTEVENT2,
	  MOVEEVENT, CLICKRIGHTEVENT, CLICKLEFTEVENT, DRAGLEFTEVENT, 
	  DRAGRIGHTEVENT, GETFOCUSEVENT, LOSTFOCUSEVENT, INITEVENT,
	  BUTTONHOLDEVENT, WINDOWMOVEEVENT, STARTDRAGLEFTEVENT, STARTDRAGRIGHTEVENT,
	  // NOTE> this must be at end
 	  LASTEVENT};
enum bs	{ BDOWN, BUP, WHIDE, WVISIBLE, WDEACTIVE, WACTIVE};
enum BmpType { BMP_NONE, BMP_FILE, BMP_IMAGE, BMP_MEM };

#define	IM		 	CScheme->window_fore // CBLACK standard menu fore & background colors
#define	PM			CScheme->window_back

#define	BNORMAL		7
#define	BPUSHED		3
#define	BDISABLED	5
#define	BUNVISIBLE	6

#define	WFRAMED		0x0001
#define	WTITLED		0x0002
#define	WMODAL		0x0004
#define	WSOLID		0x0008
#define	WHIDEN		0x0010
#define	WUNMOVED	0x0020
#define	WMENU		0x0040
#define	WNOPICTO	0x0080
#define	WBITMAP		0x0100
#define	WCLICKABLE	0x0200
#define	WDIRTY		0x0400
#define	WTEMPHIDEN	0x0800
#define	WLOCKED		0x1000
#define	WTRIGGER	0x2000
#define	WLASTFOCUS	0x4000
#define	WSIZEABLE	0x8000
#define	WUSELAST	0x00010000
#define	WMINIMIZE	0x00020000
#define	WSTATUSBAR	0x00040000
#define	WEXIST		0x00080000
#define	WHORIZONTAL	0x00100000
#define	WVERTICAL	0x00200000
#define	WLINEMENU	0x00400000
#define	WCENTRED	0x00800000

#define	WMENUWINDOWTYPE	   0x80000000

#define	WSTANDARD	(WCLICKABLE|WTITLED|WFRAMED)

#define	APP_WINDOWDATABASE		1
#define	APP_CFG					2
#define	APP_ENABLEALTX			4
#define	APP_MAGNIFIER			8
#define	APP_ROOTWINDOW			16
#define APP_ALL					0x1F

// some global fnc

extern "C" void	IError(char	*s,	int	flag);
extern "C" int GetMouseX(void);
extern "C" int GetMouseY(void);
extern "C" void	RemoveMousePointer(void);

int	 GetFreeColors(void);
void SetColorFuzzy(int a);
extern "C++" int	 CreateColor(int,int,int);
extern "C++" int	 CreateColor(int,int,int,int);
void GetColor( char	&, char	&, char	&, int);
void DeleteColor(int);
void SetRepeatDelay(int	c1,	int	c2);
void SaveScreen(void);

extern long IntCounter; // counter of userevent pass

class BaseGui;
class Control;
class Window;
class Bitmap;
class EditBox;
class ButtonGroup;

typedef struct
{
	int		window_back, window_fore;
	int		active_title;
	int		inactive_title;
	int		wnd_bord1;
	int		wnd_bord2;
	int		wnd_bord3;
	int		statusbar;
	int		menu_back;
	int		menu_fore;
	int		menu_back_active;
	int		menu_fore_active;
	int		button_fore;
	int		button_back;
	int		button_fore_pushed;
	int		button_back_pushed;
	int		button_bord1;
	int		button_bord2;
	int		button_bord3;
	int		edit_back;
	int		edit_fore;
	int		edit_bord1;
	int		edit_bord2;
	int		slider;
	int		menuwindow_back;
	int		menuwindow_fore;
	int		pdmenu_back_active;
	int		pdmenu_fore_active;
	int		pdmenu_gray;
} ColorScheme;

extern ColorScheme * CScheme;

class Node {
	friend class Config;
	typ_item type;
	char name[36];
	int	i;
	char  s[132];
	double d;
	void ModifyNode(char * comment)	// Modify comment
	{
		type = _COMMENT;
		*name =	0;
		strncpy(s, comment, 128);
	}
	void ModifyNode(char * meno, char *	val) // Modify string
	{
		type = _STRING;
		strncpy(name, meno, 32);
		strncpy(s, val, 128);
	}
	void ModifyNode(char * meno, int val) // Modify integer
	{
		type = _INT;
		strncpy(name, meno, 32);
		i	 = val;
	}
	void ModifyNode(char * meno, double	val) // Modify double
	{
		type = _DOUBLE;
		strncpy(name, meno, 32);
		d	 = val;
	}
};
	
class Config {
	protected:
		int	find(char *	s);
		void CreateEmpty(void);
		char name[36];
		FILE *f;
		int	entries;
		int	change;
		Node pole[MAX_CONF_ITEMS];
		void ReadConfig(void);
		void WriteConfig(void);
		void WriteComment(char * s);
	public:
		
		int	   ReadInt(char	* s);
		char const * ReadString(char * s);
		double ReadDouble(char * s);
		int	   ReadInt(char	* s, int &p);
		int	   ReadString(char * s,	char *p, int max);
		int	   ReadString(char * s,	char **p);
		int	   ReadDouble(char * s,	double &p);
		void   WriteInt(char * s, int);
		void   WriteString(char	* s, char *);
		void   WriteDouble(char	* s, double);

		Config(char	*);
		~Config();
};

//
//  Create a palette entry at 'index'
//

struct Palette {
		char	b;
		char    g;
		char    r;
		char alfa;
	public:
		Palette(void)
		{
		 	r =	g =	b =	alfa = 0;
		}
		Palette(unsigned p)
		{
		 	*((unsigned *)this) = p;
		}
};

class ColorSystem {
		Palette ColorsArray[256];
		int	 colorsFree, startFree;
		int	 range;
	public:
		void SetColorFuzzy(int a) {	range =	a&15; }
		int	 GetFreeColors(void) { return colorsFree; }
		void ReservedColors(void);
		~ColorSystem()
		{
			_set_default_palette();
		}
		ColorSystem()
		{
			startFree =	0;
			range =	0;
			colorsFree=	256-startFree;
			ReservedColors();
		}
		void CreatePaletteEntry(int	rc,	int	gc,	int	bc,	int	idx);
		void GetPaletteEntry(char &rc, char	&gc, char &bc, int i)
		{
		 	rc = ColorsArray[i].r;
			gc = ColorsArray[i].g;
			bc = ColorsArray[i].b;
		}
		void DeleteColor(int idx)
		{
			if (ColorsArray[idx].alfa==1) // is free
			{
			 	ColorsArray[idx].r = (char)idx;	// create an gray color
				ColorsArray[idx].g = (char)idx;
				ColorsArray[idx].b = (char)idx;
				ColorsArray[idx].alfa=0;
				colorsFree++;
			}
			else if	(ColorsArray[idx].alfa>1) ColorsArray[idx].alfa--;
		}
		void RefreshPalette(void);
		int	CreateColor(int	r, int g, int b); //return -1 if no space ...
		int	CreateColor(int	r, int g, int b, int index); // force color
};


//
//	data structure to event-driven ...
//

class GuiEvent {
	protected:
		static	int	ismouse, user_pid;
		static	char *eventName[];
		int		type;
		int		key;
		int		buttons, x,	y, w, h;
		friend class BaseGui;
		friend class App;
		void AutoRepeatStart(Control *);
		void AutoRepeatDo(void);
	public:
		static void AutoRepeatEnd(void);
		Window	*wnd;	// address of destination
		int		guiType;
		Control *accel;
		GuiEvent(int a=NOEVENT,	int	b=0, int c=0, int d=0)
		{ 
			type= a;
			key	= b;
			x	= c;
			y	= d;
			accel = 0;
		}
		int	Key(void) {	return key;	}
		char 	*Name(void) { if (type<0 || type>=LASTEVENT) return eventName[LASTEVENT]; return eventName[type]; }
		int	GetX(void) { return	x; }
		int	GetY(void) { return	y; }
		int	GetW(void) { return	w; }
		int	GetH(void) { return	h; }
		int	Type(void) { return	type; }
		int	Buttons(void) {	return buttons;	}
		GuiEvent * GetUserEvent(int);
		void   TranslateUserEvent(void);
		static void	InitUserEvent(void);
		static void	CloseUserEvent(void);
		static void	GetDragVector(int &a, int &b, int &c, int &d);
		static void	SetDragShape(void(*a)(int,int,int,int)=0);
};

typedef	void (*Widget)(void);

typedef	void (*GuiHwnd)(GuiEvent *);

typedef	int	(*MainHwnd)(GuiEvent *);

typedef	void (*PCHARFNC)(char *);

//
//	base objects for all graphics objects
//

class WindowItem
{
	public:
		int	x,y,w,h;
		char *name;
		WindowItem *next;
		WindowItem();
		WindowItem(int xx, int yy, int ww, int hh, char	*s);
		~WindowItem();
};

class WindowDatabase {
		static int xyCounter;
		friend class WindowItem;
		static WindowItem *first;
		static WindowItem **endpointer;
	public:
		WindowDatabase();
		~WindowDatabase();
		static void	Add(int	&, int &, int &, int &,	char *,int);
		static void	DatabaseResize(int , int , char	*);
		static void	DatabaseRelocate(int , int , char *);
		static WindowItem *	find(char *s);
};

class BaseGui {
	protected:
		int		 id;
		int 	 parameter1;
		int		 type;
		char 	*name;
		int		 ink, paper;
		int		 x,y,w,h;
		unsigned long	status;
		BaseGui	*last, * next;
		void	 PositionCheck(int &x, int &y, int &w, int &h);
	public:
		virtual	void MoveIn(void){}
		virtual	void MoveOut(void){}
		void         SetColors(void) { set_colors(ink, paper); }
		void		 SetParam(int a) { parameter1 = a; }
		int			 GetParam(void)  { return parameter1; }
		void		 SetLast(BaseGui *l) { last	= l; }
		void		 SetNext(BaseGui *l) { next	= l; }
		BaseGui(const BaseGui &)
		{
			printf("No COPY Constructor defined!\n");
			exit(-1);
		}
		static	  	int	counter;
		void	  	Resize(int dx, int dy)	 { w +=	dx;	h += dy; WindowDatabase::DatabaseResize(w,h,name); }
		void	  	Relocate(int xx, int yy) { x +=	xx;	y += yy; WindowDatabase::DatabaseRelocate(x,y,name); }
		int		  	GetX(void) { return	x; }
		int		  	GetY(void) { return	y; }
		int		  	GetW(void) { return	w; }
		int		  	GetH(void) { return	h; }
		int		  	IsVisible(void)	{ return !(status&(WHIDEN|WTEMPHIDEN));	}
		int		  	GetId(void)	{ return id; }
		int		  	GetType(void) {	return type; }
		char	* 	GetName(void) {	return name; }
		void	  	SetName(char *s) { delete name;	name = new char[strlen(s)+1]; strcpy(name,s); }
		int		  	GetCnt(void) { return counter; }
		char	  	GetInk(void) { return (char)ink; }
		char	  	GetPaper(void) { return	(char)paper; }
		void 	  	SetStatus(long s) {	status = s;	}
		long	  	GetStatus(void)	{ return status; }
		BaseGui	* 	Over(BaseGui *od, BaseGui *po);
		BaseGui	* 	OverSprite(BaseGui *od,	int	x, int y, int w, int h);
		BaseGui	* 	GetNext(void) {	return next; }
		BaseGui	* 	GetLast(void) {	return last; }
		static	  	BaseGui	* FindId(BaseGui *,	int	idw);
		BaseGui	* 	FindName(BaseGui *,	char *);
		static	  	BaseGui	* Find(BaseGui *p,GuiEvent *e);
		BaseGui	* 	FindEvent(BaseGui *p,GuiEvent *e);
		BaseGui(int	xs,	int	ys,	int	ws,	int	hs,	char *nm, int typ, int i, int p, long flag);
		enum Type {	WINDOW,	CHECKBUTTON, PUSHBUTTON, POINTBUTTON, EDITBOX,
			MENUBUTTON, MENUBUTTON2, MENUWINDOW, SLIDEBAR, PSEUDOWINDOW, LISTBOX};
		void Rechain(BaseGui *l, BaseGui *n);  // place to object chain
		virtual	~BaseGui();
};

#pragma	pack(1);

class Bitmap {
	struct RGB3
	{
		char bBlue;				 /* Blue component of the color definition */
		char bGreen;			 /* Green component of the color definition*/
		char bRed;				 /* Red component of the color definition  */
	};
	struct RGB4
	{
		char bBlue;				 /* Blue component of the color definition */
		char bGreen;			 /* Green component of the color definition*/
		char bRed;				 /* Red component of the color definition  */
		char fcOptions;			 /* Reserved, must be zero                 */
	};
	struct bitmap_file_header
	{
		unsigned short	usType;
		unsigned long	cbSize;
		short			reserve1, reserve2;
	};
	struct bitmap_info
	{
		unsigned short	imageOffset;
		short			reserve;
	};
	struct bitmap_info_header1
	{
	  unsigned long	 size;
	  unsigned short cx;			   /* Bit-map width in pels                  */
	  unsigned short cy;			   /* Bit-map height in pels                 */
	  unsigned short cPlanes;		   /* Number of bit planes                   */
	  unsigned short cBitCount;		   /* Number of bits per pel within a plane  */
	  unsigned long	 ulCompression;	   /* Compression scheme used to store the bitmap */
	  unsigned long	 cbImage;		   /* Length of bit-map storage data in chars*/
	  unsigned long	 cxResolution;	   /* x resolution of target device          */
	  unsigned long	 cyResolution;	   /* y resolution of target device          */
	  unsigned long	 cclrUsed;		   /* Number of color indices used           */
	  unsigned long	 cclrImportant;	   /* Number of important color indices      */
	};
	struct bitmap_info_header2
	{
	  unsigned long	 size;
	  unsigned long	 cx;			   /* Bit-map width in pels                  */
	  unsigned long	 cy;			   /* Bit-map height in pels                 */
	  unsigned short cPlanes;		   /* Number of bit planes                   */
	  unsigned short cBitCount;		   /* Number of bits per pel within a plane  */
	  unsigned long	 ulCompression;	   /* Compression scheme used to store the bitmap */
	  unsigned long	 cbImage;		   /* Length of bit-map storage data in chars*/
	  unsigned long	 cxResolution;	   /* x resolution of target device          */
	  unsigned long	 cyResolution;	   /* y resolution of target device          */
	  unsigned long	 cclrUsed;		   /* Number of color indices used           */
	  unsigned long	 cclrImportant;	   /* Number of important color indices      */
	};

	protected:
		bitmap_file_header	bmfh;
		bitmap_info			bmi;
		union {
			bitmap_info_header1	bmih1;
			bitmap_info_header2	bmih2;
		} bmih;
		union {
			RGB3 rgb3[256];
			RGB4 rgb4[256];
		} rgb;

		char		 *name;
		int			 w,h;
		int			 w_real;  // unaligned real widtht
		long		 *cUsedTable;
		void		 turn_bitmap(int cnt, char *from, char *to);
		char		 *bitmap;

	public:
		int			 type;
		Bitmap(char	*name);
		Bitmap(void	*memimage);
		Bitmap(Window *);
		Bitmap(int,int,int color=CBLACK);
		void		 BitmapDraw(int	a=0, int b=0, int c=-1,	int	d=-1);
		~Bitmap();
		int		  BitmapSave(char *);
		int		  GetW(void) { return w; }
		int		  GetWREAL(void) { return w_real; }
		int		  GetH(void) { return h; }
		char *	  GetArray(void) {return bitmap;}
		void		clear(int c) { memset(bitmap, c, w*h); }
};

#pragma	pack();

//
//	Base object fo controls (some buttons, menu & input boxes ..
//

class ButtonGroup
{
		int		count;
		int		type; // 1-check,point; 2-push; 0 undefined
		Control * 	curr;
		Control *	array[32];
	public:
		ButtonGroup()
		{
			count = type = 0;
			curr = 0;
		}
		void AddToGroup(Control *p, int activ = 0);
		void RefreshGroup(Control *c);
};

class Control :	public BaseGui {
	protected:
		Widget		fnc;			// handler
		Window		*owner;			// owner of this
		ButtonGroup 	*grp;		// if is group members
		int		key;			// hotkey
		int		xr,	yr;			 // x,y real coordinates
		int		local_id;
		Bitmap		*icon;
		Control(int	xs,	int	ys,	int	ws,	int	hs,	char *nm, int typ, int key,	int	flag, Window *,	Widget f=0,	int	p=CGRAY1, int i=CDARK);
		Control(int	xs,	int	ys,	int	typ, int key, int flag,	Window *, Bitmap *,	Widget f=0);
		~Control();
		void		Underscore(int xo, int yo, int c);
		static		Control	*cControl; // current activated control
		Widget	 	GetHandler(void) { cControl	= this;	return fnc;	}
		void 		frame(void);
	public:
		void		RegisterToGroup(ButtonGroup *g) { grp = g;}
		void		RemoveFromGroup(void) { grp = 0; }
		virtual		void SetName(char *s) {	BaseGui::SetName(s); draw(); }
		void		SetKey(int k) {	if (k>='a' && k<='z') k	= toupper(k); key=k; draw(); }
		virtual		void draw(void)	{}
		void		Enable(void);
		void		Disable(void);
		void		Relocate(int xx, int yy) { xr += xx; yr	+= yy; }
		virtual		void ClickUp(int a);  // if TRUE, so call handler
		virtual		void ClickDown(void) {}
		virtual		void ClickMove(int,int) {}
		void		SetTrigger(int a) {	if (a) SetStatus(GetStatus()|WTRIGGER);	else	SetStatus(GetStatus()&(~WTRIGGER));	draw();}
		int	   		GetTrigger(void) { return GetStatus()&WTRIGGER?1:0;	}
		static 		Control * ButtonFind(GuiEvent *e,int	n);
		int			Key(void) {	return key;	}
		int	   		GetXr(void)	{ return xr; }
		int	   		GetYr(void)	{ return yr; }
		Window		*GetOwner(void)	{ return owner;	}
		static 		Control *GetLastActive(void)	{ return cControl; }
		void		RefreshGroup(void);
		int			GetLocalId() { return local_id; }
};

class PushButton : public Control {
	protected:
			virtual	void draw(void);
	public:
		PushButton(int xs, int ys, int ws, int hs, char	*nm, int key, int flag,	Window *w, Widget f=0)
			: Control(xs, ys, ws, hs, nm, PUSHBUTTON, key, flag, w,	f)
			{
			 	draw();
			}
		PushButton(int xs, int ys, int key,	int	flag, Window *w, Bitmap	*bm, Widget f=0)
			: Control(xs, ys,PUSHBUTTON, key, flag,	w, bm, f)
			{
			 	draw();
			}
		void ClickDown(void);
		void ClickUp(int);
		void MoveIn(void);
		void MoveOut(void);
		void Push(void);
		void Release(void);
};

class CheckButton :	public Control {
			virtual	void draw(void);
			int		* variable;
	public:
		CheckButton(int	xs,	int	ys,	char *nm, int key, int flag, Window	*w,	int	fg,	int	bg,	Widget f=0, int *var=0)
			: Control(xs, ys, strlen(nm)*8+24, 16, nm, CHECKBUTTON,	key, flag, w, f,bg,fg)
			{
				variable = var;
				if (variable) SetTrigger(*variable); else draw();
			}
		void ChangeItem(int *v) { variable = v; SetTrigger(*v); draw(); }
};

class PointButton :	public Control {
			virtual	void draw(void);
			int		* variable;
	public:
		PointButton(int	xs,	int	ys,	char *nm, int key, int flag, Window	*w,	int	fg,	int	bg,	Widget f=0, int *var=0)
			: Control(xs, ys, strlen(nm)*8+24, 16, nm, POINTBUTTON,	key, flag, w, f,bg,fg)
			{
				variable = var;
				if (variable) SetTrigger(*variable); else draw();
			}
		void ChangeItem(int *v) { variable = v; SetTrigger(*v); draw(); }
};

extern EditBox *ininput;

class EditBox :	public Control {
	protected:
		virtual	void draw(void);
		void	draw(int);
		int		w1,w2,min,max,data_type,first,passwd,check_range;
		double	mind,maxd;
		void  *	ptr;
		static char	buf[128];
		int	 pos, maxpos, iline, icol, offset,size;
		void TestRange(void)
		{
			if (check_range==0) return;
			if (data_type==0)
			{
				int	dato = *(int *)ptr;
				if (dato<min) *(int	*)ptr =	min;
				else if	(dato>max) *(int *)ptr = max;
			}
			else if	(data_type==2)
			{
				double dato	= *(double *)ptr;
				if (dato<mind) *(double	*)ptr =	mind;
				else if	(dato>maxd)	*(double *)ptr = maxd;
			}
		}
	public:
		~EditBox()
		{
			if (ininput	== this)
				ininput	= 0;
		}
		void MoveIn(void);
		void MoveOut(void);
		void ClickUp(int);
		int	 inputproc(int);
		void input(void);
		void PasswdMode(int m) { passwd = m; draw(); }
		void ChangeItem(int	*p)
		{
			assert(data_type==0);
			ptr	= p;
			draw();
		}
		void ChangeItem(char *p)
		{
			assert(data_type==1);
			ptr= p;
			draw();
		}
		void ChangeItem(double *p)
		{
			assert(data_type==2);
			ptr	= p;
			draw();
		}
		void SetSize(int ns)
		{
			pos = offset = 0;
			assert(ns>0 && ns<128);
			size = ns;
			draw();
		}
		EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	int *pt, int ink, int paper, Widget f, int mn, int mx, int check);
		EditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, Window	*w,	char *pt, int ink, int paper, Widget f);
		EditBox(int xs,	int ys,	int ws1, int ws2, char *nm, int	key, Window *w,	double *pt, int	ink, int paper,	Widget f, double mn, double mx, int check);
};

class BaseMenu : public	Control	{
			virtual	void draw(void);
	public:
		void MoveIn(void);
		void MoveOut(void);
		virtual	void ClickUp(int a);  // if TRUE, so call handler
		BaseMenu(int x,	int	y, int ww, int hh, char	*nm, int key, Window *w, int bg, int fg, Widget	f, int type)
			: Control(x,y,ww, hh, nm, type, key, BNORMAL, w, f,bg,fg)
			{
				draw();
			}
};

class Slider  : public Control
{
	protected:
		virtual void draw(void) {}
		int		minv,maxv,*val,steps,smer; // 0 je vodorovny, 1 zvysly
		Widget  fnc;
		Window	*wnd;
		void 	frame(int,int,int,int,int f=0);
	public:
		Slider(Window *win, int xs, int ys, int ws, int hs, int minimal, int maximal, int s, int *v, Widget f=0) :
			Control(xs, ys, ws, hs, 0, SLIDEBAR, 0, BNORMAL, win, f)
		{
			wnd  = win;
			if (minimal>maximal)
			{
				minv = maximal;
				maxv = minimal;
			}
			else
			{
				minv = minimal;
				maxv = maximal;
			}
			if (*v<minv) *v=minv;
			if (*v>maxv) *v=maxv;
			val  = v;
			steps= s;
			smer = h>w;
			fnc  = f;
		}
};

class SlideBarH : public Slider 
{
// 3 - 16 - val - 3 - 38
	public:
		SlideBarH(int x, int y, int min, int max, int step, int *val, Window *win, Widget f=0):
			Slider(win,x,y,(max-min)/step+16+6+38,16,min,max,step,val,0)
		{
			draw();
			fnc = f;
		}
		void    redraw(void)
		{
			Widget tmp = fnc;
			fnc = 0;
			draw();
			fnc = tmp;
		}
		virtual void draw(void);
		virtual void ClickMove(int dx, int dy);
		virtual void ClickDown(void);
};

class SlideBarV : public Slider
{
// 3 - 16 - val - 3 - 38
	public:
		SlideBarV(int x, int y, int min, int max, int step, int *val, Window *win, Widget f=0):
			Slider(win,x,y,16,(max-min)/step+16+6+38,min,max,step,val,0)
		{
			draw();
			fnc = f;
		}
		void    redraw(void)
		{
			Widget tmp = fnc;
			fnc = 0;
			draw();
			fnc = tmp;
		}
		virtual void draw(void);
		virtual void ClickMove(int dx, int dy);
		virtual void ClickDown(void);
};

class Window : public BaseGui {
	protected:
		int		c_menupos;
		char 	*save;
		char 	*image;
		int		statuscolor;
		Window	**itself;
		void 	(*handler)(GuiEvent	*);
		BaseGui	*Buttony;
		BaseGui	*lastButton; // last in list
		int		nControls;	 // pocet buttonov priradenych oknu
		static	int	nWnd;
		int		wsur,hsur,xpos,ypos;
		int		xwrk,ywrk,wwrk,hwrk;
		static	int	allControls;
		static	int	hresult;
		static	Window *current, *first;  // last in list of all windows
		virtual	void draw(void);
		virtual	void DrawTitleMem(int color);
		int		OverWnd(void);
		static void	RepaintBlock(int x,	int	y, int w, int h)
		{
			RamToVideo(x,y,current->GetX()+x,current->GetY()+y,w,h);
		}
		void	init(void);
		long	WindowStatus(long status);
		void	WindowHide(void);
		void	WindowShow(void);
		void	WindowRecopy(void);
		int		OdkryOkno(void);
		static	void ZakryOkno(void);
		int		OdkryteOkno(Window *pokial,	int	x, int y, int w, int h);
		int		Rozporcuj(int X1, int Y1, int X2, int Y2, int *in, int *out);
		int		GetXM(int);
		int		GetYM(void);
		friend	volatile void DestroyWindow(void);
		friend	void   GuiEvent::TranslateUserEvent(void);
		friend	int	isgmkey(int	k);
	public:
		char *	  GetArray(void) {return image;}
		static	int	TestNullHandler(void)
		{
			if (current->GetStatus()&WNOPICTO)
			{
				IError("Can`t close this window",0);
				return 1;
			}
			return 0;
		}
		void	  wputc(int);
		void	  move(int x=0,	int	y=0) { wputc(-1); xpos=x; ypos=y; }
		int		  GetWW(void) {	return wsur; }
		int		  GetHW(void) {	return hsur; }
		static	  Window * GetCurrent(void)	{ return current; }
		BaseGui	* GetCurrentControls(void) { return	Buttony; }
		void	  WindowRepaint(int	xr,	int	yr,	int	w, int h);
		void	  Context(void);
		static void	HideAll(void);
		static void	ShowAll(void);
		friend class Control;
		Window(Window **, int xs, int ys, int ws, int hs, char *nm,	GuiHwnd=0, int i=IM, int p=PM, int flag=WTITLED|WFRAMED|WCLICKABLE);
		Window(Bitmap *);
		Window(int x, int y, int w, int h);
		Window(Window **);	// root window
		~Window();
		PushButton *AddPushButton(int xs, int ys, int ws, int hs, char *nm,	int	key=0, void	(*f)(void)=0, int flag=BNORMAL);
		PushButton *AddPushButton(int xs, int ys, int key, Bitmap *bm, void	(*f)(void)=0, int flag=BNORMAL);
		SlideBarH *AddSlideBarH(int xs, int ys, int min, int max, int step, int *val, Widget f=0);
		SlideBarV *AddSlideBarV(int xs, int ys, int min, int max, int step, int *val, Widget f=0);
		CheckButton	*AddCheckButton(int	xs,	int	ys,	char *nm, int key=0, int * variable=0, void	(*f)(void)=0, int flag=BNORMAL);
		PointButton	*AddPointButton(int	xs,	int	ys,	char *nm, int key=0, int * variable=0, void	(*f)(void)=0, int flag=BNORMAL);
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max);
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, int *p, Widget f=0);
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, char *p, Widget f=0);
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f, double min, double max);
		EditBox	*AddEditBox(int	xs,	int	ys,	int	ws1, int ws2, char *nm,	int	key, double *p, Widget f=0);
		BaseMenu *AddBaseMenu(char *nm,	int	key=0, Widget f=0);
		void WindowMove(int,int);
		void WindowFocus(void);
		void WindowText(int	x, int y, char *s);
		void WindowText(int	x, int y, char *s, int color);
		void WindowText(int	x, int y, char *s, int color, int bk);
		void WindowBox(int x, int y, int a,	int	b);
		void WindowBox(int x, int y, int a,	int	b, int c);
		void WindowPixel(int x,	int	y, int c);
		void WindowPixel(int x,	int	y);
		unsigned WindowGetPixel(int	x, int y)
		{
			if (x<0	|| y<0 || x>wwrk ||	y>hwrk)	return 256;
			return image[(x+xwrk)+(y+ywrk)*GetW()];
		}
		void WindowRect(int	x, int y, int a, int b);
		void WindowRect(int	x, int y, int a, int b,	int	c);
		void WindowLine(int	x, int y, int a, int b);
		void WindowLine(int	x, int y, int a, int b,	int	c);
		void WindowDrawCircle(int x, int y,	int	r, int c);
		void WindowDrawCircle(int x, int y,	int	r);
		void WindowFillCircle(int x, int y,	int	r, int c);
		void WindowFillCircle(int x, int y,	int	r);
		void WindowScrollDown(int p1, int p2, int p3, int p4 ,int p5);
		void WindowScrollUp(int	p1,	int	p2,	int	p3,	int	p4 ,int	p5);
		void WindowStatusBar(int, char *s, int c=IM);
		int	 TitleFind(GuiEvent	*e);
		static void	WindowInvalidate(void);
		static Window *	WindowFind(GuiEvent	*e);
		int	 printf(const char *, ...);
		int	 printf(int,int,const char *, ...);
		void SendToWindow(GuiEvent *p);
		static void	nextwnd(void);
		void WindowLock(void) {	SetStatus(GetStatus()|WLOCKED);	}
		void WindowUnLock(void);
		void WindowResize(int, int);
		void puts(char *s) { while(*s) wputc(*s++);	}
		void WindowPutBitmap(int x,	int	y, int xs, int ys,	int	w, int h, Bitmap *p);
		void WindowGetBitmap(int x,	int	y,	int	xs,	int	ys,	int	w, int h, Bitmap *p);
		void SetName(char *s) {	BaseGui::SetName(s); WindowStatus(WACTIVE);	}
		void Iconize(void);
		void WindowFillPolygon(int,	int	[][2], int col=-1);
		void WindowDrawPolygon(int,	int	[][2], int col=-1);
		void WindowSpline(int points[8]);
		void FlushInput(void);
		void WindowSetWorkRect(int,int,int,int);
		void WindowGetWorkRect(int&,int&,int&,int&);
		void RemoveControls(void);
};

#define	MAX_EVENT_QUEQUE	10	 // numbers of events to app per one user event ...

class App {
		static	GuiEvent *event, *queque;
		static	void (*DelayProc)(void);
		static	int	quequeIndex;
		static	void (*OnEverySecond)(int);
		static  Window *Root;
	public:
		int		flags;
		int		video;
		ColorSystem	*farby;
		int		Argc;
		char	**Argv;
		friend void	GetColor( char &, char &, char &, int);
		friend void	DeleteColor(int);
		friend int GetFreeColors(void);
		friend void	SetColorFuzzy(int);
		void   RefreshPalette(void)
		{
			farby->RefreshPalette();
		}
		static	void SetDelayProc(void (*fnc)(void))
		{
			DelayProc =	fnc;
		}
		static	void CallDelayProc(void)
		{
			if (DelayProc) DelayProc();
			else delay(10);
		}
		App(int, int &,	char **	&, int b, int f=APP_ENABLEALTX);
		~App();
		static	void SendToApp(GuiEvent	*x)
		{
			if (quequeIndex<MAX_EVENT_QUEQUE)
			{
				memcpy(queque+quequeIndex++,x,sizeof(GuiEvent));
			}
		}
		void	Run(MainHwnd hwnd=0);
		static	void AppDone(void)
		{
			GuiEvent e(QUITEVENT);
			SendToApp(&e);
		}
		static	void Timer(void);
		static void	SetTimerProc(void ((*p)(int)))
		{
			OnEverySecond =	p;
		}
		Window * GetRootWindow(void)
		{
			assert(Root);
			return Root;
		}
};

extern App *cApp; // current app
extern Widget call_handler;
extern Config *cCfg;
extern Window *oldidw, *idw;
extern Control *oldidm,*idm;
extern int fulldrag;

class MenuWindow : public Window {
		static GuiHwnd Proc;
		static MenuWindow *	CurrentMenu;
		static void	MenuWindowHandler(GuiEvent *p);
		int		offset;
		int		cid;
	public:
		MenuWindow(int x, int y, int w,	int	h, char	*name="MenuWindow", GuiHwnd proc=0, int bg=CScheme->menuwindow_back):
			Window(0,x,y,w,h,name,MenuWindowHandler,CScheme->menuwindow_fore,bg,WFRAMED|WCLICKABLE|WNOPICTO|WMENUWINDOWTYPE)
		{
			offset = 0;
			cid = -1;
			Proc = proc;
			CurrentMenu	= this;
		}
		~MenuWindow()
		{
			CurrentMenu	= 0;
		}
		int	GetXM(void)
		{
			return 4;
		}
		int	GetYM(int a)
		{
			return (offset+=a,offset-a);
		}
		BaseMenu *AddMenu(char *nm,	int	key=0, Widget f=0);
		CheckButton	*AddCheckButton(char *nm, int key=0, int * variable=0, Widget f=0, int flag=BNORMAL);
		PointButton	*AddPointButton(char *nm, int key=0, int * variable=0, Widget f=0, int flag=BNORMAL);
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f, int min, int max);
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, int *p, Widget f=0);
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, char *p, Widget f=0);
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f, double min, double max);
		EditBox	*AddEditBox(int	ws1, int ws2, char *nm,	int	key, double	*p,	Widget f=0);
		void Separator(void);
};

void SendEvent(Window *w, int event, int key=0,	int	x=0, int y=0);
int RegisterJob(Widget w);
unsigned int CalculateCRC(unsigned StartCRC, void *Addr, unsigned Size);
#endif
