/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include "fastgl.h"
#include "widgets.h"
#include "_fastgl.h"

#ifdef __WATCOMC__
#define	random rand
#define	srandom srand
#endif

#ifdef __linux__
#include <sys/io.h>
#endif

extern int rnd(int);
#define rnd(a) (random()%(a+1))  // macro for randomize fnc

int a, b;
char s[80];

Window *w1, *w2, *w3, *w4, *w5;
ButtonGroup *grp;

extern "C"
{
	void __crt0_load_environment_file(char *)
	{
	}
	char **__crt0_glob_function(char *)
	{
		return 0;
	}
}

#define PCI_CONF_ADDR  0xcf8
#define PCI_CONF_DATA  0xcfc


static int pci_read_header (unsigned char bus, unsigned char device,
        unsigned char fn, unsigned long *buf)
{
  int i;
  unsigned long bx = ((fn&7)<<8) | ((device&31)<<11) | (bus<<16) |
                        0x80000000;

  for (i=0; i<16; i++) {
        outpl (PCI_CONF_ADDR, bx|(i<<2));
        buf[i] = inpl (PCI_CONF_DATA);
  }

  return 0;
}


/* find a vga device of the specified vendor, and return
   its configuration (16 dwords) in conf 
   return zero if device found.
   */ 
int pci_find_vendor(void)
{ unsigned long buf[16];
  int bus,device,cont;
  
  cont=1;
#ifdef __linux__
  if (getenv("IOPERM") == 0) {
        if (iopl(3) < 0) {
	    printf("svgalib: vgapci: cannot get I/O permissions\n");
	    exit(1);
	}
  }
#endif
  for(bus=0;(bus<16)&&cont;bus++)              
    for(device=0;(device<256)&&cont;device++){
      pci_read_header(bus,device,0,buf);
//	  printf("%08x \n", *buf);
      if (((buf[2]>>16)&0xffff)==0x0300)
	  {
		  	return buf[0]&0xffff;
	  }
    };
#ifdef __linux__
  if (getenv("IOPERM") == 0)
  	iopl(0);
#endif
  return 0;
}

int cas()
{
	static int a = 0, b;

	b = a;
	return ((a = clock()) - b);
}

void rondo()
{
	volatile int i = X_width / 8 / 6, j = Y_width / 16;
	char *s1 = "Rondo ", *s2 = " Rondo";

	for (; j >= 0; j--)
		for (int a = i; a >= 0; a--)
			text_out(a * 8 * 6, j * 16, j & 1 ? s1 : s2);
}

int test2(int x)
{
	int pp[][2] =
	{{10, 10}, {100, 60}, {50, 500}, {100, 400}, {500, 490}, {800, 100}, {10, 10}};
	int i, f;
	void *p;

	p = malloc(X_width * Y_width);
	f = clock();
	for (i = 0; i < 10; i++)
	{
		clear_frame_buffer(i);
	}
	if (x)
		set_ppop(_GXOR);
	for (i = 0; i < 50; i++)
	{
		set_fcolor(i);
		fill_convex(7, pp);
	}
	for (i = 0; i < 1000; i++)
	{
		set_fcolor(i);
		draw_line(0, 0, X_width, i);
		draw_line(0, i, X_width, 0);
	}
	set_ppop(_GSET);
	for (i = 0; i < 600; i++)
	{
		set_fcolor(i);
		fill_box(rnd(X_width), rnd(Y_width),100, 65);
	}
	if (x)
		set_fcolor(_GXOR);
	get_block(0, 0, X_width, Y_width, p);
	for (i = 0; i < 600; i += 5)
	{
		put_block(i, i, X_width, Y_width, p);
	}
	put_block(0, 0, X_width, Y_width, p);
	for (i = 0; i < 600; i += 5)
	{
		put_block(i, 600 - i, X_width, Y_width, p);
	}
	put_block(0, 0, X_width, Y_width, p);
	for (i = 0; i < 600; i += 5)
	{
		put_block(600 - i, 600 - i, X_width, Y_width, p);
	}
	put_block(0, 0, X_width, Y_width, p);
	for (i = 0; i < 600; i += 5)
	{
		put_block(-i, i, X_width, Y_width, p);
	}
	if (x)
		set_ppop(_GAND);
	for (i = 20; i < 130; i++)
	{
		set_fcolor(i);
		draw_circle(X_width / 2, Y_width / 2 - 20, i);
		fill_circle(X_width / 2, Y_width / 2 + 20, i);
	}
	for (i = 45; i < 60; i++)
	{
		set_fcolor(i);
		set_bcolor(i + 16);
		if (x)
			set_ppop(i & 3);
		rondo();
	}
	free(p);
	return clock() - f;
}

int test3()
{
	int i, j, f;

	set_ppop(0);
	f = clock();
	for (j = 0; j < 6000; j++)
	{
		w1->WindowFillCircle(rnd(w1->GetW()), rnd(w1->GetH()), rnd(100), rnd(255));
		w2->WindowText(rnd(w2->GetW()), rnd(w2->GetH()), "Hello", rnd(255), rnd(255));
		set_fcolor(rnd(255));
		w3->WindowBox(rnd(w3->GetW()), rnd(w3->GetH()), 40, 30);
	}
	for (j = 0; j < 256; j++)
		for (i = 0; i < 256; i++)
	  w1->WindowPixel(i, j, i + j);
	  w1->WindowLine(0,0,w1->GetWW(),w1->GetHW());
	  w1->WindowLine(0,100,w1->GetWW(),w1->GetHW());
	  w1->WindowLine(100,0,w1->GetWW(),w1->GetHW());

	return clock() - f;
}

void test()
{
	Window *w = Window::GetCurrent();

	cas();
    Window::HideAll();
	set_ppop(_GSET);
	a = test2(0);
	b = test2(1);
	set_ppop(_GSET);
    Window::ShowAll();
	sprintf(s, "Graph mark - %d (redraw mode)", a);
	set_ppop(_GSET);
	w->WindowText(20, 140, s);
	sprintf(s, "Graph mark - %d (xor mode)", b);
	w->WindowText(20, 160, s);
#ifndef __QNX__
	sprintf(s, "MMX Extension : %s", mmx ? "Yes" : "No");
	w->WindowText(20, 200, s);
#endif
	set_ppop(_GSET);
}

void test1()
{
	Window *w = Window::GetCurrent();

	cas();
	a = test3();
	sprintf(s, "Graph WinMark - %d", a);
	w->WindowText(20, 180, s);
	set_ppop(_GSET);
}

int AppProc(GuiEvent *)		// if return 0 = exit
{
	return 1;
}

void boxes_remove(GuiEvent *p)
{
	if (p->Type()==TERMINATEEVENT) cApp->SetDelayProc(0);
}

void boxes(void)
{
	static int a=0;
	if (a<300)
	{
		set_fcolor(rnd(255));
		cApp->GetRootWindow()->WindowBox(rnd(X_max), rnd(Y_max), 40, 30);
		cApp->GetRootWindow()->WindowLine(rnd(X_max), rnd(Y_max), 40, 30);
//		a++;
	}
//	w2=0;
//	w2->WindowBox(rnd(X_max), rnd(Y_max), 40, 30);
//	w2->WindowLine(rnd(X_max), rnd(Y_max), 40, 30);
}

void myexit()
{
  App::AppDone();
}

void aaa(int)
{
	Puk();
}

void xxx()
{
	new MenuWindow(130, 20, 100, 130, "dfghkl 2");
}

void hand5(GuiEvent * )
{
//	if (e->Type() == BUTTONHOLDEVENT) Puk();
//	if (e->Type() == KEYEVENT) e->wnd->printf(0,0,"%d %x\n", e->Key(), e->Key());
//		printf("{%d,%d},\n", e->GetX(), e->GetY());
}

extern char mystery[];			// bitmap in exe

void kresli1(int x, int y, int c, int ako, void *)
{
	set_colors(ako==0?CWHITED:CWHITE,CBLACK);
	w2->printf(x,y," %03d \n", c);
}

void select_file(char *s)
{
	w1->SetName(s);
}

int main(int argc, char **argv)
{
	App MyApp(3, argc, argv, 0, APP_ENABLEALTX|APP_WINDOWDATABASE|APP_MAGNIFIER|APP_ROOTWINDOW);
	int i, j = 7, h = (Y_width / 100) * 40, w = (X_width / 100) * 40;
	double jjj = .88;
	char jj[32] = "majo      ";
	Control *eb;

	CScheme->menu_back = 1;
	CScheme->menu_fore = 14;
	
	new Window(&w1, 20, 20, w, h, "Okienko 1", GuiHwnd(NULL), CBLACK, CWHITED, WTITLED);
	new Window(&w2, 20, Y_width / 2 + 20, w, h, "Okienko 2", boxes_remove, 7, 5, WSIZEABLE | WMENU | WTITLED/* |WFRAMED*/);
	new Window(&w3, X_width / 2 + 20, 20, w, h, "Okienko 3", GuiHwnd(NULL), 7, 0, WNOPICTO | WTITLED );
	new Window(&w4, X_width / 2 + 20, Y_width / 2 + 20, w, h, "Okienko 4", GuiHwnd(NULL), CWHITED, CGREEN-CGREEN, WFRAMED | WSIZEABLE | WUSELAST|WMENU);
	new Window(&w5, 0, 0, w, h, "Okienko 5", hand5, 7, 0, WSOLID|WSTANDARD | WSIZEABLE | WUSELAST | WCENTRED);

	w1->WindowText(10, 8, "WFILLED|WTITLED|WNOPICTO", CBLACK);
	w2->WindowText(10, 8, "WFILLED|WFRAMED|RESIZEABLE", CWHITE);
	w3->WindowText(-40, -4, "WNOPICTO|WTITLED|WFILLED");
	w4->WindowText(10, 8, "(default)", CWHITE);

	sprintf(s, "framebuffer 0x%x", framebuffer);
	w3->WindowText(20, 45, s);
	sprintf(s, "memory size %d KB", memorysize);
	w3->WindowText(20, 60, s);
	sprintf(s, "Resolution %dx%d", X_width, Y_width);
	w3->WindowText(20, 90, s);
	sprintf(s, "Display Driver : %s", GetDriverName());
	w3->WindowText(20, 105, s);
	eb = w4->AddEditBox(20, 40, 70, 60, "Input :", 'I', &j, 0, 5, 10);
	((EditBox *) eb)->ChangeItem(&i);
	EditBox *ebb = w4->AddEditBox(20, 70, 70, 80, "Input", 'N', jj, 0);
	ebb->SetSize(4);
	w4->AddEditBox(20, 100, 70, 60, "Input :", 'P', &jjj, 0, .5, 1.5);
	eb = w5->AddPushButton(20, 10, 190, 24, "Start Test for Base", 'B', test);
	eb = w5->AddPushButton(20, 40, 190, 24, "Start Test for Window", 'W', test1);
//	eb->Disable();
	grp = new ButtonGroup;
	eb = w5->AddCheckButton(20, 90, "Check Button", 'C');
	grp->AddToGroup(eb, 1);
	eb = w5->AddPointButton(170, 90, "Point Button", 'P');
	grp->AddToGroup(eb);
	eb = w5->AddPushButton(w - 70, 10, 60, 24, "Exit", 'E', myexit);
	eb->SetName("Quit");
	eb->SetKey('Q');
	w3->WindowLine(10, 100, 100, 10, 0);
	w3->WindowLine(100, 100, 10, 10);
	w1->WindowLock();
	set_ppop(_GNOT);
	for (i = 0; i < 300; i++)
	{
		set_fcolor(i);
		w1->WindowLine(0, 0, w, i);
		w1->WindowLine(0, i, w, 0);
	}
	w1->WindowUnLock();
	w2->AddBaseMenu("File ", 'F', 0);
	w2->AddBaseMenu("Edit ", 'E', 0);
	eb = w2->AddBaseMenu("Help ", 'H', 0);
	w2->WindowBox(0, 0, w, h);

    set_ppop(_GTRANSP);
	set_bcolor(9);
    set_font(0);
	text_out(50,300,"4589e76tyeuir ghdpfuiset;rhgukdh;fgsdjk;rtyergnfjkdfjhk");
	w4->printf(10, 134, "You can move or resize this window\n");
	w4->printf(10, 134+20, "       like under WIN 95\n");
	w4->printf(10, 134+40, "   for help run this with -h switch\n");
    set_font(4);
    set_ppop(0);
	MyApp.SetDelayProc(boxes);
	MenuWindow *m = new MenuWindow(0, 0, 120, 100, "Menu WND");

	m->AddMenu("first",'f',xxx);
	m->AddMenu("second",'s');
	m->AddMenu("third",'t');
	m->Separator();
	m->AddMenu("styri",'s');

 	w1->WindowFillCircle(100,100,50,CBLACK);
	int mz[][2]={{62,186},{135,150},{221,197},{377,125},{231,25},{150,85},{10,18},{62,186}};
	set_ppop(_GXOR);
	w1->WindowFillPolygon(8,mz,CRED);
	set_ppop(_GSET);
	w1->WindowDrawPolygon(8,mz,CRED);

// 	new FileDialog(select_file, ".", ".cc .o .gpr","Files in this dir", FDIALOG_SAVE);
	sprintf(s,"The Vendor code of this card is %04x, using %s driver", pci_find_vendor(), GetDriverName());
	set_font(2);
	IError(s,0);
	MyApp.Run(AppProc);

	cCfg->WriteString("prvy3","retazec");
	cCfg->WriteInt("prvy2",12345678);
	cCfg->WriteDouble("prvy1",123.435643);
	return 0;
}
