/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Get & translate user events

*/
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef __QNX__
#include <sys/kernel.h>	
#include <sys/name.h>
#include <sys/sched.h>
#endif

#ifdef __linux__
#include <sys/kd.h>
#include <sys/ioctl.h>
#endif
	
#include "fastgl.h"
#include "_fastgl.h"

static int mouseflag = -1;
static int mx, my, mb, oldx, oldy, oldb, drag, action;
int	fulldrag = 0;
static int startXdrag =	0;
static int startYdrag =	0;
static int endXdrag	= 0;
static int endYdrag	= 0;

#ifndef	__QNX__
#define		REPEAT_DELAY1			700
#define		REPEAT_DELAY2			100
#else
#define		REPEAT_DELAY1			5000
#define		REPEAT_DELAY2			3200
#endif

#define		MSZ				16	// size of mouse cursor (X&Y)
#define		MAX_JOBS		20

static Widget Tjobs[MAX_JOBS];
static int index1, index2, jobs;

static int repeat_status=0, repeat_delay1=REPEAT_DELAY1, repeat_delay2=REPEAT_DELAY2;
static GuiEvent	 *hold_event;
static void (*DragShape)(int , int ,int	, int );

EditBox	*ininput = 0;
Control	*idm = 0, *oldidm =	0;
Window	*idw = 0, *oldidw =	0;
int	GuiEvent::user_pid;
static Widget GetJobs(void);

long IntCounter;
char *GuiEvent::eventName[]= { "NOEVENT", "KEYEVENT",
	  "MOUSEEVENT", "QUITEVENT", "ACCELEVENT",
	  "TERMINATEEVENT", "RESIZEEVENT", "INPUTEVENT1",
	  "INPUTEVENT2", "MOVEEVENT", "CLICKRIGHTEVENT",
	  "CLICKLEFTEVENT",	"DRAGLEFTEVENT", "DRAGRIGHTEVENT",
	  "GETFOCUSEVENT", "LOSTFOCUSEVENT", "INITEVENT",
	  "BUTTONHOLDEVENT", "WINDOWMOVEEVENT", "STARTDRAGLEFTEVENT",
	  "STARTDRAGRIGHTEVENT",
  // must by at the end
	  "NONSENSE"};

//
// Save Screen to BMP file
//

void SaveScreen(void)
{
	Bitmap *a =	new	Bitmap(X_width,	Y_width);
	char s[20];
	time_t num = time(0);
	get_block(0,0,X_width,Y_width,a->GetArray());
	sprintf(s,"%x",(unsigned int)num);
	printf("Bitmap '%s' saved\n", s);
	a->BitmapSave(s);
	delete a;
}

void SetRepeatDelay(int	c1,	int	c2)
{
	if (c1>0 &&	c1<2000) repeat_delay1 = c1;
	if (c2>0 &&	c2<500)	 repeat_delay2 = c2;
}

int	GetMouseX(void)
{
	return mx;
}

//
// Get real mouse Y-position
//

int	GetMouseY(void)
{
	return my;
}

int	MouseDraw(int x, int y,	int	a)
{
	int	old	= mouseflag;
	int	i,cx=cx_max,cy=cy_max;
	char *pom =	Image;
	char *maska, *mapa;
	static char	work[sizeof(m_save)];

	mouseflag =	a;
	cx_max = cy_max	= MSZ;
	if (a) // draw cursor
	{
		Image =	m_save;
		VideoToRam(x, y, 0,	0, MSZ,	MSZ);
		memcpy(work, m_save, sizeof(m_save));
		maska =	m_mask;
		mapa = m_bmap;
		for	(i = 0;	i <	(MSZ * MSZ); i++)
		{
			work[i]	&= *maska;
			work[i]	|= ((*mapa++) &	(char)(~*maska++));
		}
		Image =	work;
		RamToVideo(0, 0, x,	y, MSZ,	MSZ);
	}
	else // restore background
	{
		char tmp[sizeof(m_save)];
		Image =	tmp;
		VideoToRam(x, y, 0,	0, MSZ,	MSZ);
		if (memcmp(tmp,	work, MSZ*MSZ) != 0) // yes, changed
		{
			for	(i = 0;	i <	(MSZ * MSZ); i++)
			{
				if (tmp[i]!=work[i]) m_save[i] = tmp[i];
			}
		}
		Image =	m_save;
		RamToVideo(0, 0, x,	y, MSZ,	MSZ);
	}
	Image =	pom;
	cx_max=cx;
	cy_max=cy;
	return old;
}

void GuiEvent::InitUserEvent(void)
{
	hold_event = new GuiEvent(BUTTONHOLDEVENT);

#ifdef __MSDOS__
	__dpmi_regs	dpmir;

	ismouse	= 0;
	dpmir.x.ax = 0;
	__dpmi_int(0x33, &dpmir);
	if (dpmir.x.ax != 0)
	{
		ismouse	= 1;			/* present, but not initted */
		dpmir.x.ax = 15;		// citlivost
		dpmir.x.cx = 8;
		dpmir.x.dx = 16;
		__dpmi_int(0x33, &dpmir);
		dpmir.x.ax = 4;
		dpmir.x.cx = short(X_width / 2);
		dpmir.x.dx = short(Y_width + 2);
		__dpmi_int(0x33, &dpmir);
		dpmir.x.ax = 7;
		dpmir.x.dx = 0;
		dpmir.x.cx = short(X_width-1);
		__dpmi_int(0x33, &dpmir);
		dpmir.x.ax = 8;
		dpmir.x.dx = 0;
		dpmir.x.cx = short(Y_width-1);
		__dpmi_int(0x33, &dpmir);
	}
#endif

#ifdef __linux__
	ismouse = LinuxInputOpen();
#endif 

#ifdef __QNX__
	ismouse	= 1;
	user_pid = spawnlp(P_NOWAIT, "userevent", "userevent", itoa(X_width, "       ",	10), itoa(Y_width, "      ", 10), "1", 0);
	if (user_pid ==	-1)	
	{
	    perror("can't spawn 'userevent' server!");
	    graph_set_mode(0);
	    abort();
	}
#endif
}

void GuiEvent::CloseUserEvent(void)
{
#ifdef __QNX__
	kill(user_pid,SIGINT);
	sync();
	delay(500);
	sync();
#endif
#ifdef __linux__
	LinuxInputClose();
#endif
	ismouse = 0;
	mouseflag = -1;
}

GuiEvent *GuiEvent::GetUserEvent(int waits)
{
	static int xx =	X_width	/ 2, yy	= Y_width / 2, bb =	0;
	int	xx2, yy2, k;
	GuiEvent *val =	0;
    Widget pom;
#ifdef __MSDOS__
	static int idle_supp=0;
	__dpmi_regs	dpmir;
#endif

	xx2	= xx;
	yy2	= yy;
	if (mouseflag == 1)
		MouseDraw(xx, yy, TRUE);
	for	(; waits;)
	{
#ifdef __MSDOS__
		dpmir.x.ax = 0x1680;
		if (idle_supp) __dpmi_int(0x2f, &dpmir);
		if (dpmir.x.ax&255) idle_supp = 0;
		dpmir.h.ah = 0x11;		// sched_yield
		__dpmi_int(0x16, &dpmir);
		if (!(dpmir.x.flags	& 0x40))
		{
			dpmir.h.ah = 0x10;	// test for key buffer

			__dpmi_int(0x16, &dpmir);
			switch (dpmir.h.al)
			{
				case 0xe0:
					k =	dpmir.h.ah + 0x200;
					break;
				case 0x00:
					k =	dpmir.h.ah + 0x100;
					break;
				default:
					k =	dpmir.h.al;
					break;
			}
			type = KEYEVENT;
			key	= k;
			x = y = buttons = 0;
			break;
		}
		if (ismouse)
		{
			dpmir.x.ax = 3;		// test for key buffer
			__dpmi_int(0x33, &dpmir);
			if (dpmir.x.bx != bb ||	dpmir.x.cx != xx ||	dpmir.x.dx != yy)
			{
				bb = dpmir.x.bx;
				xx = dpmir.x.cx;
				yy = dpmir.x.dx;
				type = MOUSEEVENT;
				key	= 0;
				x =	xx;
				y =	yy;
				buttons	= bb;
				val	= this;
				break;
			}
		}
#endif
#ifdef __QNX__
		if (Creceive(user_pid,this,sizeof(GuiEvent)) !=	-1)
		{
			val	= this;
			xx = x;
			yy = y;
			k  = key;
			bb = buttons;
			Reply(user_pid,this,sizeof(GuiEvent));
			if (key==429) {	SaveScreen(); continue;	} // PrtScr
			break;
		}
		else sched_yield();
#endif
#ifdef __linux__
		if (LinuxGetEvent(type,key,x,y,buttons,ismouse)==0) sched_yield();
		else
		{
			if (key==0xe01b) { SaveScreen(); continue; } // PrtScr
			if (key==0x03) raise(SIGINT);
			val= this;
			xx = x;
			yy = y;
			k  = key;
			bb = buttons;
			break;
		}
#endif // LINUX
		IntCounter ++;
		if ((pom=GetJobs())!=0) pom();	// call job handler
		App::CallDelayProc();			// call delay handler
		App::Timer();                   // call timer handler
		if (repeat_status>0) AutoRepeatDo();
	}
//	printf("typ %d, key %x, x %d, y %d b %d\n", type,key,x,y,buttons);
	if (mouseflag == 1)
		MouseDraw(xx2, yy2,	FALSE);
	if (type ==	KEYEVENT)
		mouseflag =	0;
	else
		mouseflag =	1;
	return val;
}

void RemoveMousePointer(void)
{
	if (mouseflag == 1)
		MouseDraw(mx, my, FALSE);
	mouseflag =	0;
}

static void	blue_rect(int x, int y,	int	w, int h)
{
	int	a =	set_ppop(_GNOT);
	draw_box(x,y, w-1, h-1);
	draw_box(x + 1, y + 1,w - 3, h - 3);
	draw_box(x + 2, y + 2,w - 5, h - 5);
	set_ppop(a);
}

static void	blue_rect2(int x, int y, int w, int h)
{
	if (!DragShape) blue_rect(x,y,w,h);
	else DragShape(x,y,w,h);
}

int isgmkey(int	k)
{
	switch (k)
	{
		case CTRL_TAB:			// ctrl+TAB
	 		Window::nextwnd();
			return 1;
		case F12:
		{
	 		int	a =	Window::nWnd;
			Window *p =	Window::first;
			while(a--)
			{
				if (p->GetStatus()&WHIDE) p->WindowStatus(WVISIBLE);
				p =	(Window	*)p->GetNext();
			}
			return 0;
		}
		case ALT_X:			// alt+X
			if (cApp->flags	& APP_ENABLEALTX)
			{
				App::AppDone();
				return 1;
			}
			else return	0;
		case ALT_F04:			// alt+F4
			if (Window::GetCurrent())
				if (!Window::TestNullHandler()) 
					delete Window::GetCurrent();
			return 1;
	}
	return 0;
}

int	GuiEvent::ismouse =	0;

void GuiEvent::TranslateUserEvent(void)
{
	static int mousefirst, resize =	0, tmp_event,
		resizex, resizey,
		dragx, dragy,
		clickx,	clicky,	clickw,	clickh,
		vyrez=0;
	static Control *idcb;
	static Control *idc2;
	Window *n =	0, *curr	= Window::GetCurrent();
	static Window *drag_okno;
	int	magn = cApp->flags&APP_MAGNIFIER;

	GuiEvent app(NOEVENT); // events to  application

	call_handler = 0; // reset Control handler
	if (curr)
		switch (type)
		{
			case KEYEVENT:
				if (!ininput)	//ai nieje input 
				{
					if (isgmkey(key))
						return ;
			  		idc2 = Control::ButtonFind(this, 7);
					if (curr->IsVisible() && idc2)	//tak zisti buttony
					{
						idc2->ClickDown();
						type = ACCELEVENT;	//bude to sprava
						guiType	= idc2->GetType(); // od buttonu typ ...
						accel = idc2;
						key	= idc2->GetId();
						idc2->ClickUp(TRUE);
						curr = Window::GetCurrent();
					}
				}
				else
				{
					int	key2 = ininput->GetId();
					int	a =	ininput->inputproc(key);

					if (a == 0)
						type = NOEVENT;
					else if	(a == 1)
						type = INPUTEVENT1;
					else if	(a == -1)
						type = INPUTEVENT2;
					key	= key2;
				}
				break;
			case MOUSEEVENT:
				if (mousefirst)
				{
					mousefirst = 0;
					mx = oldx =	x;
					my = oldy =	y;
					mb = oldb =	buttons;
				}
				mx = x;
				my = y;
				mb = buttons;
				tmp_event = type;
				type = NOEVENT;

				if (resize && ((mb & 1)	== 1))
				{
					if (fulldrag)
					{
						curr->WindowResize(mx -	oldx, my - oldy);
						type = RESIZEEVENT;
					}
					else
					{
						blue_rect(curr->GetX(),	curr->GetY(), curr->GetW() + resizex, curr->GetH() + resizey);
						resizex	+= (mx - oldx);
						resizey	+= (my - oldy);
						blue_rect(curr->GetX(),	curr->GetY(), curr->GetW() + resizex, curr->GetH() + resizey);
					}
					resize++;
					break;
				}
				else if	(resize	&& (!mb))
				{
					if (!fulldrag)
					{
						blue_rect(curr->GetX(),	curr->GetY(), curr->GetW() + resizex, curr->GetH() + resizey);
						if (resizex	+ resizey)
						{
							curr->WindowResize(resizex,	resizey);
							type = RESIZEEVENT;
						}
					}
					Window::WindowInvalidate();
					resize = 0;
				}
				else if	(drag && ((mb &	1) == 1))
				{
					if (fulldrag)
					{
						curr->WindowMove(mx	- oldx,	my - oldy);
					}
					else
					{
						blue_rect(curr->GetX() + dragx,	curr->GetY() + dragy, curr->GetW(),	curr->GetH());
						dragx += (mx - oldx);
						dragy += (my - oldy);
						blue_rect(curr->GetX() + dragx,	curr->GetY() + dragy, curr->GetW(),	curr->GetH());
					}
					drag++;
				}
				else if	(drag && (!mb))
				{
					if (!fulldrag)
					{
						blue_rect(curr->GetX() + dragx,	curr->GetY() + dragy, curr->GetW(),	curr->GetH());
						if (dragx +	dragy)
							curr->WindowMove(dragx,	dragy);
					}
					Window::WindowInvalidate();
					drag = 0;
				}
				else if	(action	&& (!mb))
				{
					action = 0;
					idcb->ClickUp(TRUE);
					AutoRepeatEnd();
					curr = Window::GetCurrent();
					if (curr->IsVisible() && ((idc2->ButtonFind(this, 3)) == idcb))
					{
						type = ACCELEVENT;	//bude to sprava
						guiType	= idcb->GetType();
						accel = idcb;
					}
					else
						type = NOEVENT;
					key	= idcb->GetId();
					break;
				}
				else if	(action	&& ((mb	& 1) ==	1))
				{
					if (curr->IsVisible() && ((idc2	= Control::ButtonFind(this,3)) != idcb))
					{
						action = 0;
						AutoRepeatEnd();
						int tt = idcb->GetType();
						if (tt!=Control::POINTBUTTON && tt!=Control::CHECKBUTTON) 
						    idcb->ClickUp(FALSE);	// nevolat handler !!!!
						break;
					} else idcb->ClickMove(mx-curr->GetX()-cx_work,	my-curr->GetY()-cy_work);
				}
				else if	(vyrez && (!mb)) // vyrez end
				{
					if (drag_okno) // right click to wnd
					{
						startXdrag = clickx	- curr->GetX() - cx_work;
						startYdrag = clicky	- curr->GetY() - cy_work;
						endXdrag = clickw;
						endYdrag = clickh;
					}
					else
					{
						startXdrag = clickx;
						startYdrag = clicky;
						endXdrag = clickw;
						endYdrag = clickh;
					}
					if (vyrez >	3) if (magn) blue_rect2(clickx, clicky, clickw, clickh);
					if (clickw<0) {	clickx += clickw; clickw = -clickw;	}
					if (clickh<0) {	clicky += clickh; clickh = -clickh;	}
					if (drag_okno) // right click to wnd
					{
						if (vyrez >	2 && oldb == 2)	type = DRAGRIGHTEVENT;
						else if	(vyrez <= 2	&& oldb	== 2) type = CLICKRIGHTEVENT;
						else if	(vyrez > 2 && oldb == 1) type =	DRAGLEFTEVENT;
						else if	(vyrez <= 2	&& oldb	== 1) type = CLICKLEFTEVENT;
						w =	clickw;
						h =	clickh;
						curr = drag_okno; // redirect it to right window
						x =	clickx - curr->GetX() -	cx_work;
						y =	clicky - curr->GetY() -	cy_work;
					}
					else  // right click to background
					{
						if (vyrez >	2 && oldb == 2)	app.type = DRAGRIGHTEVENT;
						else if	(vyrez <= 2	&& oldb	== 2) app.type = CLICKRIGHTEVENT;
						else if	(vyrez > 2 && oldb == 1) app.type =	DRAGLEFTEVENT;
						else if	(vyrez <= 2	&& oldb	== 1) app.type = CLICKLEFTEVENT;
						app.x =	clickx;
						app.y =	clicky;
						app.w =	clickw;
						app.h =	clickh;
					}
					vyrez =	0;
					break;
				}
				else if	(vyrez && (mb &	3))	// vyrez continue
				{
					if (vyrez == 3)	if (magn) blue_rect2(clickx,	clicky,	clickw,	clickh);
					if (vyrez >	2) if (magn) blue_rect2(clickx, clicky, clickw, clickh);
					clickw += (mx -	oldx);
					clickh += (my -	oldy);
					if (vyrez >	2) if (magn) blue_rect2(clickx, clicky, clickw, clickh);
					vyrez++;
					if (vyrez == 3)
					{
						int type2 =	mb==2?STARTDRAGRIGHTEVENT:STARTDRAGLEFTEVENT;
						if (drag_okno)
						{
							type = type2;
							x =	clickx - curr->GetX() -	cx_work;
							y =	clicky - curr->GetY() -	cy_work;
						}
						else
						{
							app.type = type2;
							app.x = clickx;
							app.y = clicky;
						}
					}
					else
					{
						if (drag_okno) type = MOVEEVENT;
						else
						{
	    	                app.type = MOVEEVENT;
    	    	            app.x = x;
                	        app.y = y;
                    	    app.key = 0;
						}
					}
				}
				else if	((!action) && (!drag) && (!vyrez) && (!resize) && (mb == 1))
				{
					int	t;

					t =	curr->TitleFind(this);
					if (curr->IsVisible()
					   && ((idcb = Control::ButtonFind(this, 7)) !=	0) && t	!= 4)
					{
						action = 1;
						idcb->ClickDown();
						AutoRepeatStart(idcb);
					}
					else if	(t)
					{
						if (t == 1 && (!oldb) && !(curr->GetStatus() & WUNMOVED))
						{
							drag = 1;
							dragx =	dragy =	0;
							if (!fulldrag)
							{
								blue_rect(curr->GetX() + dragx,	curr->GetY() + dragy, curr->GetW(),	curr->GetH());
							}
						}
						else if	(t == 2)
						{
							if (!Window::TestNullHandler())
							{
								delete curr;
								return ;
							}
						}
				  		else if	(t==3) curr->Iconize();
						else if	(t == 4)
						{
							resize = 1;
							resizex	= resizey =	0;
							if (!fulldrag)
							{
								blue_rect(curr->GetX(),	curr->GetY(), curr->GetW() + resizex, curr->GetH() + resizey);
							}
						}
					}
					else		// tuklo sa vedla titulku
					{
						n =	Window::WindowFind(this);
						// do okna
						// prepni na toto okno ak nieje aktivne
						if ((n != curr)	&& (n))
						{
							if (!(curr->GetStatus()	& WMODAL))
							{
								n->WindowFocus();
								type = tmp_event;
								TranslateUserEvent();
								curr = Window::GetCurrent();
								if (curr != n || !n) return; // window destroyed !!
							}
							else WarningBeep(0);
						}
						else
						{
							vyrez =	1;
							drag_okno =	Window::WindowFind(this); // 0-back, 1-wnd
							clickx = x;
							clicky = y;
							clickw = clickh	= 0;
							if (ininput)				   // if input, force ESC
							{
								int	key2 = ininput->GetId();
		
								ininput->inputproc(CR);
								type = INPUTEVENT1;
								key	= key2;
							}
						}
					}
				}
				else if	(oldb == 0 && mb ==	2)	// right click down
				{
					vyrez =	1;
					drag_okno =	Window::WindowFind(this);  // find window for click
					if (ininput)				   // if input, force ESC
					{
						int	key2 = ininput->GetId();

						ininput->inputproc(ESC);
						type = INPUTEVENT2;
						key	= key2;
					}
					clickx = x;
					clicky = y;
					clickw = clickh	= 0;
				}
				else if	(mb == 0 &&	oldb ==	0)	// only mouse move
				{
					type = MOVEEVENT;
					idm	= Control::ButtonFind(this, 3);
					if (idm	&& idm->GetOwner() != curr)
                                        {
                                                break;
                                        }
					if (idm)
					{
						key = idm->GetId();
						if (idm->GetTrigger()) idm = 0;
					}
					else if	((idw =	Window::WindowFind(this)) != 0)
					{
						key	= idw==curr?0:-1;
						curr = idw;		// sender is changed !!!
						x =	x-idw->GetX()-idw->xwrk;
						y =	y-idw->GetY()-idw->ywrk;
					}
					else
                                        {
                                                type = NOEVENT;
                                                app.type = MOVEEVENT;
                                                app.x = x;
                                                app.y = y;
                                                app.key = 0;
                                        }
					if ((!oldidm &&	idm) ||	((idm && oldidm) &&	(idm !=	oldidm)))
					  	idm->MoveIn();
					if ((oldidm	&& !idm) ||	((idm && oldidm) &&	(idm !=	oldidm)))
					  	oldidm->MoveOut();
					if ((!oldidw &&	idw) ||	((idw && oldidw) &&	(idw !=	oldidw)))
						idw->MoveIn();
					if ((oldidw	&& !idw) ||	((idw && oldidw) &&	(idw !=	oldidw)))
						oldidw->MoveOut();
					break;
				}
		}
	else
	{
		if (type == KEYEVENT)
		{
			if (isgmkey(key)) return;	// exit when no window are
			App::SendToApp(this); // send keys only
		}
		return ;
	}							// no window exists
	oldx = mx;
	oldy = my;
	oldb = mb;
	oldidm = idm;
	oldidw = idw;
	if (app.type !=	NOEVENT) App::SendToApp(&app); // send to app if needed
	if (type !=	NOEVENT)						   // send to Window if needed
	{
		if (type == ACCELEVENT) 
			if (Control::GetLastActive())
				Control::GetLastActive()->RefreshGroup();
		if ((curr=Window::GetCurrent()) != 0) curr->SendToWindow(this);
		if (call_handler) call_handler(); // call to control handler also
	}
}

// start autorepeat routine
void GuiEvent::AutoRepeatStart(Control *id)
{
	hold_event->key=id->GetId();
	hold_event->accel=id;
	hold_event->guiType=id->GetType(); // od buttonu typ ...
	repeat_status =	1;
	AutoRepeatDo();
	repeat_status =	REPEAT_DELAY1;
}

// end autorepeat routine
void GuiEvent::AutoRepeatEnd(void)
{
 	repeat_status =	0;
}

// process -||-
void GuiEvent::AutoRepeatDo(void)
{
 	if (--repeat_status	<= 0)
	{
		Window::GetCurrent()->SendToWindow(hold_event);
		repeat_status =	REPEAT_DELAY2;
	}
}

void GuiEvent::GetDragVector(int &a, int &b, int &c, int &d)
{
	a =	startXdrag;
	b =	startYdrag;
	c =	endXdrag;
	d =	endYdrag;
}

void GuiEvent::SetDragShape(void (*fnc)(int, int, int, int))
{
	DragShape = fnc;
}

int RegisterJob(Widget w)
{
	int pom;
	if (jobs==MAX_JOBS) return -1;
	Tjobs[pom=index1++] = w;
    if (index1==MAX_JOBS) index1 = 0;
    jobs++;
    return pom;
}

static Widget GetJobs(void)
{
	Widget pom;
	if (jobs==0) return 0;
	pom = Tjobs[index2];
	Tjobs[index2++] = 0;
    if (index2==MAX_JOBS) index2=0;
	jobs--;
    return pom;
}

void CloseUserInput(void)
{
	GuiEvent::CloseUserEvent();
}

