/*
    Copyright (C) 1996,99  Marian Krivos
    nezmar@internet.alcatel.sk

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    low level portion of user events (QNX)

*/
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/mouse.h>
#include <sys/dev.h>
#include <sys/proxy.h>
#include <sys/kernel.h> 
#include <sys/name.h>

enum events { NOEVENT, KEYEVENT, MOUSEEVENT, QUITEVENT, ACCELEVENT,
			  CLICKEVENT, TERMINATEEVENT, RESIZEEVENT, RESIZEENDEVENT,
			  INPUTEVENT1, INPUTEVENT2, MOVEEVENT};

typedef struct {
		int		type;
		int		key;
		int		buttons, x, y, w ,h;
		void	*wnd;
		int		gui;
		void	*accel;
} GuiEvent ;

static pid_t GMPid;

short isattached(char *s)
{
	int id;
	struct _nameinfo buf;
	
	for(id=0; (id = qnx_name_query(0,id,&buf)) != -1; ++id) if (!strcmp(s, buf.name)) return buf.pid;
	return -1;
}

void posli(GuiEvent *p)
{
	Send(GMPid, p, p, sizeof(GuiEvent), sizeof(GuiEvent));
//	printf("%x\t%x\t%x\t%x\t%x\n",p->type,p->key,p->x,p->y,p->buttons);
}

int sig=0;

pid_t mproxy, kproxy, pid;
struct _mouse_ctrl * mc=NULL;
int old;

void koniec(int)
{
	printf("\rUserevent terminated\n\r");
	qnx_proxy_detach(kproxy);
	dev_mode(0, old, _DEV_MODES);
	if (mc) mouse_close(mc);
	exit(0);
}

int main(int argc, char **argv)
{
	int armed;
	int oldx, oldy, oldb, err=0,button=0;
	int X_max=atoi(argv[1]), 
	    Y_max=atoi(argv[2]);
	int mousex=X_max/2, mousey=Y_max/2;
	int shift=0;
	GuiEvent           userevent,_e;
	struct mouse_event *buf = (struct mouse_event *)&_e;
	int                kbuf=0;
	
	GMPid=getppid();
	argc=argc;

	signal(SIGINT, koniec);
	old=dev_mode(0,0,_DEV_ECHO | _DEV_EDIT);
	mc = mouse_open((nid_t)0, 0, 0);
	if (mc) if (isattached("qnx/mouse")==-1) printf("mouse failed!\n\r");

	dev_mode(0,0,_DEV_ECHO | _DEV_EDIT);
	if (mc) mproxy = qnx_proxy_attach(0,0,0,-1);
	kproxy = qnx_proxy_attach(0,0,0,-1);
	if (mc) mouse_flush(mc);
	
	if (mc) mouse_read(mc, buf, 0, mproxy, NULL);
	dev_read(0, &kbuf, 0, 1, 0, 0, kproxy, NULL);
	
	for(;;)
	{
		pid = Receive( 0, buf, sizeof(buf));
		if (mc && pid == mproxy)
		{
			armed = 0;
			while (!armed) 
			{
				oldb=buf->buttons;
				mouse_read(mc, buf, 1, mproxy, &armed);
				
				oldy=mousey;
				oldx=mousex;
				if (((mousex+buf->dx)>=0)&&((mousex+buf->dx)<X_max)) mousex+=buf->dx;
				if (((mousey+-buf->dy)>=0)&&((mousey+-buf->dy)<Y_max)) mousey+=(-buf->dy);

				userevent.type = MOUSEEVENT;
				userevent.key  = 0;
				userevent.x = mousex;
				userevent.y = mousey;
				if (buf->buttons==1) 
				{
					buf->buttons=2; 
				}
				else if (buf->buttons==4) buf->buttons=1; else buf->buttons=0;
				
				userevent.buttons = buf->buttons;
				if (mousex!=oldx || mousey!=oldy || oldb!=buf->buttons) 
					posli(&userevent);
			}
		}
		else if (pid == kproxy)
		{
			armed=0;
			while (!armed) 
			{
				dev_read(0, &kbuf, 1, 1, 0, 0, kproxy, &armed);
				if (kbuf == 255) {shift=0x100; continue; }
				userevent.type = KEYEVENT;
				userevent.key = kbuf+shift;
				userevent.x = userevent.y = userevent.buttons = 0;
				shift = 0;
				posli(&userevent);
			} 
		}
	}
	return 0;
}