/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
* for dialing users, connect to gossip server and get username for given
* ip address
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "defs.h"
#include "innuendod.p"

PRIVATE char *tok_gossip_greet = "Gossip ";

/***************************************************************************
*
***************************************************************************/
PUBLIC int test_dynamic_range(struct in_addr *ia)
{
  unsigned long int x;

  x = ntohl(ia->s_addr);
  if(x >= conf.dynamic_range_min && x <= conf.dynamic_range_max)
    return 1;

  return 0;
}

/***************************************************************************
*
***************************************************************************/
PRIVATE int resolv_user_sub(kon_t *k, char *addr, char *username)
{
  char strln[STR_LEN + 1], user[STR_LEN + 1];
  int  code;

  if(!sock_gets(k, strln, STR_LEN, 1))
    return 0;
  if(strncmp(strln, tok_gossip_greet, strlen(tok_gossip_greet)))
    return 0;

  sprintf(strln, "%s\n\r", addr);
  sock_puts(k, strln);

  if(!sock_gets(k, strln, STR_LEN, 1))
    return 0;
  if(sscanf(strln, "%d %s", &code, user) != 2)
    return 0;

  if(code == 0)
    strncpy2(username, user, STR_LEN_SMALL);

  return 1;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void resolv_user(struct in_addr *ia, char *username)
{
  kon_t kon;
  char  str[STR_LEN + 1], str2[STR_LEN + 1];

  strcpy(username, "?");
  if(conf.gossip_server[0] == 0)
    return;

  inet_ntop(AF_INET, ia, str2, STR_LEN);
  sprintf(str, "I attempting to resolve %s (connecting to gossip)", str2);
  log_m(str);

  if(!sock_open(&kon, &in_gossip_server))
    return;

  kon.rq_ll = NULL;
  resolv_user_sub(&kon, str2, username);

  sock_close(&kon);
}
