/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au, jsno@downunder.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <netinet/in.h>

#define PRIVATE static
#define PUBLIC

#define WELCOME \
"innuendod R" REVISION \
", By Jason Nunn <jsno@arafura.net.au>, Arafura Connect.\n"

#define CONF_FILE          VAR_PATH "/conf"

#define STR_LEN            256
#define STR_LEN_LN         2048
#define STR_LEN_SMALL      40
#define RECV_BUF_FRAG_SIZE 256

/**************************************************************************
* atomic struct defs
**************************************************************************/
typedef struct _ll_t
{
  struct _ll_t    *next;
} ll_t;

typedef struct _treap_t
{
  int             p;
  struct _treap_t *l;
  struct _treap_t *r;
} treap_t;

/**************************************************************************
* data struct defs
**************************************************************************/
typedef struct
{
  int               proxy_port;
  char              nntp_server[STR_LEN_SMALL + 1];
  int               nntp_port;
  char              gossip_server[STR_LEN_SMALL + 1];
  int               gossip_port;
  unsigned long int dynamic_range_min; /*32bit addresses in host order*/
  unsigned long int dynamic_range_max;
} conf_t;

typedef struct   /*recv queue*/
{
  char buf[RECV_BUF_FRAG_SIZE];
  int  ptr;
  int  size;
} rq_t;

#define KON_FLAG_DIR_IN  0
#define KON_FLAG_DIR_OUT 1

typedef struct
{
  unsigned dir : 1;
} kon_flag_t;

typedef struct
{
  kon_flag_t     flag;
  int            s;
  struct in_addr ip_addr;
  char           username[STR_LEN_SMALL + 1];
  ll_t           *rq_ll;
} kon_t;

typedef struct
{
  int            kid;
  kon_t          c;
  kon_t          s;
  char           strln[STR_LEN_LN + 1];
  FILE           *fp;
  int            mode_in;
  int            mode_out;
} handle_t;

typedef struct
{
  struct in_addr ip_addr;
  char           username[STR_LEN_SMALL + 1];
  int            count;
} resolv_t;
