/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <fcntl.h>
#include <pwd.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/types.h>
#include "defs.h"
#include "innuendod.p"

/***************************************************************************
* this routine turns clobberd into a daemon. no attached terminal, no
* parent process etc.
***************************************************************************/
PRIVATE void daemonise(void)
{
  int x;

  void furk(void)
  {
    switch(fork())
    {
      case -1: /*error*/
        perror(__FUNCTION__ " fork()");
        exit(0);
      case 0: /*child*/
        break;
      default:
        exit(0);
    }
  }

  fflush(NULL);
  furk();
  for(x = 0; x <= getdtablesize(); ++x)
    close(x);
  setsid();
  furk();
  umask(0);
  chdir("/");
  x = open("/dev/null", O_RDWR);
  dup(x);
  dup(x);
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void poll_socket(void)
{
  fd_set    fds;
  struct    timeval tv;
  int       sr;
  pthread_t thread;

  for(;;)
  {
    tv.tv_sec = 0;
    tv.tv_usec = 0;
    FD_ZERO(&fds);
    FD_SET(listen_s, &fds);
    sr = select(listen_s + 1, &fds, NULL, NULL, &tv);
    if(sr == -1)
    {
      log_e(__FUNCTION__ "::select()");
      exit(-1);
    }
    if(sr == 0)
      return;

    if(pthread_create(&thread, NULL, kon_handler, &listen_s) != 0)
    {
      log_e(__FUNCTION__ ":pthread_create()");
      exit(-1);
    }
  }
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void main_loop(void)
{
  for(;;)
  {
    poll_socket();
    sleep(1);
  }
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void kill_daemon(int sig)
{
  log_m("I TERM signal received (terminating daemon)");
  exit(0);
}

PRIVATE void seg_fault(int sig)
{
  log_m("I Segmentation fault. Aborting");
  exit(-1);
}

PRIVATE void init(void)
{
  char str[STR_LEN + 1];
  struct passwd *pw;

  pw = getpwuid(getuid());
  if(pw != NULL)
  {
    if(strcmp(pw->pw_name, "root"))
    {
      printf("E Must be root to run program.\n");
      exit(-1);
    }
  }

  signal(SIGINT, kill_daemon);
  signal(SIGKILL, kill_daemon);
  signal(SIGTERM, kill_daemon);
  signal(SIGHUP, SIG_IGN);
  signal(SIGPIPE, SIG_IGN);
  signal(SIGSEGV, seg_fault);

  daemonise();
  umask(022);

  if(gethostname(our_hostname, STR_LEN) == -1)
  {
    log_m("E Couldn't resolve current hostname, Aborting");
    exit(-1);
  }

  read_conf();

  sprintf(str, "I proxy port is %d", conf.proxy_port);
  log_m(str);

  resolve_addr(&in_nntp_server, conf.nntp_server, conf.nntp_port);
  sprintf(str, "I NNTP server is %s:%d",
    conf.nntp_server, conf.nntp_port);
  log_m(str);

  if(conf.gossip_server[0] != 0)
  {
    sprintf(str, "I gossip server is %s:%d", conf.gossip_server, conf.gossip_port);
    log_m(str);
    resolve_addr(&in_gossip_server, conf.gossip_server, conf.gossip_port);
  }

  pthread_mutex_init(&mut_log, NULL);
  pthread_mutex_init(&mut_kid, NULL);
  pthread_mutex_init(&mut_resolv, NULL);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int main(int argc, char *argv[])
{
  int x;

  printf(WELCOME);
  for(x = 0; x < argc; x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            "\nUsage: innuendod <options>\n"
             " -h        Display this help info\n"
             " -c        log commands\n"
             "\n"
          );
          return 0;

        case 'c':
          log_cmd_f = 1;
          break;
      }
    }
  }

  log_m("I Starting innuendod R" REVISION);
  if(log_cmd_f)
    log_m("I logging commands");

  init();
  sock_open_server();
  log_m("I daemon started");
  main_loop();

  return 0;
}
