/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <pthread.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "defs.h"
#include "innuendod.p"

#define MODE_CMD    0
#define MODE_HEADER 1
#define MODE_BODY   2

PUBLIC int             log_cmd_f;
PUBLIC pthread_mutex_t mut_kid;

/***************************************************************************
*
***************************************************************************/
PRIVATE int get_kid(void)
{
  static int kid;
  int r;

  pthread_mutex_lock(&mut_kid);
  kid++;
  r = kid;
  pthread_mutex_unlock(&mut_kid);
  return r;
}

/**************************************************************************
*
**************************************************************************/
PRIVATE void strip_crlf(char *s1, char *s2, int len)
{
  char *s;

  strncpy2(s2, s1, len);
  s = strchr(s2, '\r');
  if(s != NULL)
    *s = 0;
}

PRIVATE void log_header(handle_t *h, char *op)
{
  char str[STR_LEN + 1], str2[STR_LEN + 1];
  int x = 0;

  if(!strncasecmp(h->strln, tok_nntp_newsgroups, strlen(tok_nntp_newsgroups)))
  {
    inet_ntop(AF_INET, &(h->c.ip_addr), str2, STR_LEN);
    sprintf(str, "I @%d %s- ip=%s, user=%s", h->kid, op, str2, h->c.username);
    log_m(str);
    x = 1;
  }

  if(x ||
     !strncasecmp(h->strln, tok_nntp_subject, strlen(tok_nntp_subject)) ||
     !strncasecmp(h->strln, tok_nntp_from, strlen(tok_nntp_from)))
  {
    strip_crlf(h->strln, str2, STR_LEN - 50);
    sprintf(str, "I @%d %s- %s", h->kid, op, str2);
    log_m(str);
  }
}

/**************************************************************************
*
**************************************************************************/
PRIVATE int stream_capture_in(handle_t *h)
{
  if(!strncmp(h->strln, tok_nntp_eop, strlen(tok_nntp_eop)))
  {
    h->mode_in = MODE_HEADER;
    return 1;
  }

  if(h->mode_in == MODE_HEADER)
  {
    if(!strncmp(h->strln, tok_nntp_eoh, strlen(tok_nntp_eoh)))
      h->mode_in = MODE_BODY;
    else
      log_header(h, "read");
  }

  return 1;
}

/**************************************************************************
*
**************************************************************************/
PRIVATE int stream_capture_out(handle_t *h)
{
  char   str[STR_LEN_LN + 1], str2[STR_LEN + 1];
  time_t t;
  int    x;
  FILE   *fp;

  if(h->mode_out == MODE_CMD)
  {
    if(log_cmd_f)
    {
      strip_crlf(h->strln, str2, STR_LEN - 50);
      sprintf(str, "I @%d cmd- %s", h->kid, str2);
      log_m(str);
    }

    if(!strncasecmp(h->strln, tok_nntp_innuendo_list, strlen(tok_nntp_innuendo_list)))
    {
      display_resolv_list(&(h->c));
      return 0;
    }

    if(!strncasecmp(h->strln, tok_nntp_post, strlen(tok_nntp_post)))
    {
      h->mode_out = MODE_HEADER;

      h->fp = tmpfile();
      if(h->fp == NULL)
      {
        log_e(__FUNCTION__ "::tmpnam()");
        exit(-1);
      }
    }

    return 1;
  }

  if(!strncmp(h->strln, tok_nntp_eop, strlen(tok_nntp_eop)))
  {
    h->mode_out = MODE_CMD;

    inet_ntop(AF_INET, &(h->c.ip_addr), str2, STR_LEN);
    sprintf(str, "%08lx.%s", time(NULL), str2);
    sprintf(str2, "I @%d post captured. saving- %s", h->kid, str);
    log_m(str2);
    fp = fopen_file(str, "w");
    rewind(h->fp);
    for(;;)
    {
      if(feof(h->fp))
        break;

      x = fread(str, 1, STR_LEN_LN, h->fp);
      fwrite(str, 1, x, fp);
    }

    fclose(fp);
    fclose(h->fp);
    return 1;
  }

  if(h->mode_out == MODE_HEADER)
  {
    log_header(h, "write");

    if(!strncmp(h->strln, tok_nntp_eoh, strlen(tok_nntp_eoh)))
    {
      h->mode_out = MODE_BODY;

      strcpy(str,
        "X-innuendod: innuendod R" REVISION
        ". NNTP proxy/spy. By Jason Nunn/Arafura Connect\r\n");
      sock_puts(&(h->s), str);
      fprintf(h->fp, str);

      sprintf(str, "X-innuendod: proxy- %s\r\n", our_hostname);
      sock_puts(&(h->s), str);
      fprintf(h->fp, str);

      inet_ntop(AF_INET, &(h->c.ip_addr), str2, STR_LEN);
      sprintf(str, "X-innuendod: src IP- %s, user- %s\r\n", str2, h->c.username);
      sock_puts(&(h->s), str);
      fprintf(h->fp, str);

      t = time(NULL);
      strncpy(str2, ctime(&t), STR_LEN);
      x = strlen(str2);
      if(x > 1)
        str2[x - 1] = 0;
      sprintf(str, "X-innuendod: date- %s\r\n", str2);
      sock_puts(&(h->s), str);
      fprintf(h->fp, str);
    }
  }

  fwrite(h->strln, strlen(h->strln), 1, h->fp);
  return 1;
}

/**************************************************************************
*
**************************************************************************/
PRIVATE void kon_handler_sub(handle_t *h)
{
  char *s;

  for(;;)   /*read first line (220 hand shake)*/
  {
    if(sock_gets(&(h->s), h->strln, STR_LEN_LN, 0))  /*server -> client*/
    {
      if(strlen(h->strln) < STR_LEN - 60)
      {
        s = strstr(h->strln, "\r\n");
        if(s != NULL)
          strcpy(s, " (innuendod " REVISION " is watching you)\r\n");
      }
      sock_puts(&(h->c), h->strln);
      break;
    }
    if(h->s.s == -1)
      return;
  }

  for(;;)
  {
    if(sock_gets(&(h->s), h->strln, STR_LEN_LN, 0))  /*server -> client*/
    {
      if(stream_capture_in(h))
        sock_puts(&(h->c), h->strln);
    }
    if(h->s.s == -1)
      return;

    if(sock_gets(&(h->c), h->strln, STR_LEN_LN, 0))  /*client -> server*/
    {
      if(stream_capture_out(h))
        sock_puts(&(h->s), h->strln);
    }
    if(h->c.s == -1)
      return;
  }
}

/**************************************************************************
*
**************************************************************************/
PUBLIC void *kon_handler(void *arg)
{
  handle_t handle;
  char     str[STR_LEN + 1], str2[STR_LEN + 1];

  sock_accept(*(int *)arg, &(handle.c));
  handle.kid = get_kid();
  handle.fp = NULL;
  handle.mode_in = MODE_HEADER;
  handle.mode_out = MODE_CMD;

  if(sock_open(&(handle.s), &in_nntp_server))
  {
    inet_ntop(AF_INET, &(handle.c.ip_addr), str2, STR_LEN);
    sprintf(str, "I @%d NEW SESSION (pid=%d, ip=%s, user=%s, csock=%d, ssock=%d)",
      handle.kid, getpid(), str2, handle.c.username,
      handle.c.s, handle.s.s);
    log_m(str);

    kon_handler_sub(&handle);
    sock_close(&(handle.s));
  }

  sock_close(&(handle.c));
  pthread_detach(pthread_self());
  pthread_exit(0);
  return NULL;
}
