/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "defs.h"
#include "innuendod.p"

/***************************************************************************
*
***************************************************************************/
PUBLIC void ll_append_unsorted(ll_t **n, void *entry, int entry_size)
{
  ll_t *tmp;

  tmp = *n;
  *n = alloc_mem(sizeof(ll_t) + entry_size);
  (*n)->next = tmp;
  memcpy((void *)*n + sizeof(ll_t), entry, entry_size);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void *ll_find(ll_t **ll, int (*cmp_func)(ll_t *))
{
  ll_t *n;
  void *e;

  n = *ll;
  for(;;)
  {
    if(n == NULL)
      return NULL;
    e = (void *)n + sizeof(ll_t);
    if(cmp_func(e))
      return e;
    n = n->next;
  }
  return NULL;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void ll_remove_entry(ll_t **n)
{
  ll_t *tmp;

  if(*n == NULL)
    return;
  tmp = (*n)->next;
  free(*n);
  *n = tmp;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int ll_remove(ll_t **ll, int (*cmp_func)(ll_t *))
{
  ll_t **n;

  n = ll;
  for(;;)
  {
    if(*n == NULL)
      break;

    if(cmp_func((void *)n + sizeof(ll_t)))
    {
      ll_remove_entry(n);
      return 1;
    }

    n = &((*n)->next);
  }

  return 0;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void ll_free(ll_t **ll)
{
  ll_t **n, *tmp;

  n = ll;
  for(;;)
  {
    if(*n == NULL)
      break;
    tmp = (*n)->next;
    free(*n);
    *n = tmp;
  }
  *ll = NULL;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void *ll_read_entry(ll_t **ll_ptr)
{
  void *e;

  if(*ll_ptr == NULL)
    return NULL;
  e = (void *)*ll_ptr + sizeof(ll_t);
  *ll_ptr = (*ll_ptr)->next;
  return e;
}
