/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <pthread.h>
#include "defs.h"
#include "innuendod.p"

PUBLIC pthread_mutex_t mut_log;

/***************************************************************************
* log atoms
*
* E: = error
* W: = Warning
* I: = Information
***************************************************************************/
PUBLIC void compose_log_msg(char *str, char *msg)
{
  struct tm *tm_st;
  time_t t;

  t = time(NULL);
  tm_st = localtime(&t);
  if(tm_st != NULL)
  {
    char *mon_tab[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    sprintf(str, "%s%02d %02d:%02d:%02d %s",
      mon_tab[tm_st->tm_mon], tm_st->tm_mday,
      tm_st->tm_hour, tm_st->tm_min, tm_st->tm_sec, msg);
  }
}

PUBLIC void log_m(char *msg)
{
  FILE *fp;
  char str[STR_LEN + 1];

  pthread_mutex_lock(&mut_log);
  fp = fopen_file("log", "a");
  if(fp)
  {
    compose_log_msg(str, msg);
    fprintf(fp, "%s\n", str);
    fclose(fp);
  }
  pthread_mutex_unlock(&mut_log);
}

PUBLIC void log_e(char *msg)
{
  char str[STR_LEN + 1];

  sprintf(str, "E %s: %s", msg, strerror(errno));
  log_m(str);
  exit(-1);
}
