/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "defs.h"
#include "innuendod.p"

PUBLIC char   *tok_nntp_innuendo_list = "innuendo_list\r\n",
              *tok_nntp_post          = "post\r\n",
              *tok_nntp_group         = "group ",
              *tok_nntp_article       = "article ",
              *tok_nntp_newsgroups    = "newsgroups: ",
              *tok_nntp_subject       = "subject: ",
              *tok_nntp_from          = "from: ",
              *tok_nntp_eoh           = "\r\n",
              *tok_nntp_eop           = ".\r\n";

PUBLIC conf_t conf;

/***************************************************************************
*
***************************************************************************/
PUBLIC void *alloc_mem(int mem_size)
{
  void *r;

  r = malloc(mem_size);
  if(r == NULL)
  {
    log_e(__FUNCTION__ ":malloc()");
    exit(-1);
  }

  return r;
}

PUBLIC void *realloc_mem(void *p, int mem_size)
{
  void *r;

  r = realloc(p, mem_size);
  if(r == NULL)
  {
    log_e(__FUNCTION__ ":realloc()");
    exit(-1);
  }

  return r;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void strncpy2(char *dst, char *src, int len)
{
  strncpy(dst, src, len);
  dst[len] = 0;
}

PUBLIC void strip_cr(char *str)
{
  int s;

  s = strlen(str);
  if(s > 0)
    if(str[s - 1] == '\n')
      str[s - 1] = 0;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int get_param(char *d_str, char *s_str, char *key, int max)
{
  char tok[STR_LEN + 1], param[STR_LEN + 1];

  sscanf(s_str, "%s %s", tok, param);
  if(!strcmp(tok, key))
  {
    char *s;

    s = strstr(s_str + strlen(tok), param);
    if(s != NULL)
      strncpy2(d_str, s, max);
    s = strchr(d_str, '\n');
    if(s != NULL) *s = 0;
    s = strchr(d_str, '\r');
    if(s != NULL) *s = 0;
    return 1;
  }
  return 0;
}

PUBLIC void read_conf(void)
{
  FILE           *fp;
  char           str[STR_LEN + 1], str1[STR_LEN + 1], str2[STR_LEN + 1];
  int            r0, r1;
  struct in_addr inp;

  void parse_err(void)
  {
    char str2[STR_LEN + 1];

    strip_cr(str);
    sprintf(str2, "E error parsing conf file- '%s'", str);
    log_m(str2);
    exit(-1);
  }

  sprintf(str, "I loading conf file %s", CONF_FILE);
  log_m(str);
  if((fp = fopen(CONF_FILE, "r")) == NULL)
  {
    log_e("E "__FUNCTION__ "::fopen()");
    exit(-1);
  }

  memset(&conf, 0, sizeof(conf_t));
  for(;;)
  {
    if(feof(fp))
      break;

    if(!fgets(str, STR_LEN, fp))
      continue;

    if(get_param(str1, str, "proxy_port:", STR_LEN_SMALL))
    {
      conf.proxy_port = atoi(str1);
      continue;
    }

    if(get_param(conf.nntp_server, str, "nntp_server:", STR_LEN_SMALL))
      continue;

    if(get_param(str1, str, "nntp_port:", STR_LEN_SMALL))
    {
      conf.nntp_port = atoi(str1);
      continue;
    }

    if(get_param(conf.gossip_server, str, "gossip_server:", STR_LEN_SMALL))
      continue;

    if(get_param(str1, str, "gossip_port:", STR_LEN_SMALL))
    {
      conf.gossip_port = atoi(str1);
      continue;
    }

    if(get_param(str2, str, "dynamic_range:", STR_LEN))
    {
      sscanf(str2, "%s %s", str, str1);

      r0 = inet_pton(AF_INET, str, &inp);
      conf.dynamic_range_min = ntohl(inp.s_addr);
      r1 = inet_pton(AF_INET, str1, &inp);
      conf.dynamic_range_max = ntohl(inp.s_addr);

      if(r0 == -1 || r1 == -1)
        parse_err();
      continue;
    }
  }
}

/***************************************************************************
*
***************************************************************************/
PUBLIC FILE *fopen_file(char *file, char *mode)
{
  time_t    t;
  struct tm *tm_st;
  char      path[STR_LEN + 1], str[STR_LEN + 1];
  FILE      *fp;

  t = time(NULL);
  tm_st = localtime((time_t *)&t);
  sprintf(path, VAR_PATH "/%02d.%02d.%02d",
    tm_st->tm_year % 100, tm_st->tm_mon + 1, tm_st->tm_mday);

  strcpy(str, path);
  strcat(str, "/");
  strcat(str, file);

  fp = fopen(str, mode);
  if(fp == NULL)
  {
    mkdir(path, 0755);

    fp = fopen(str, mode);
    if(fp == NULL)
    {
      log_e(__FUNCTION__ "::fopen()");
      exit(-1);
    }
  }

  return fp;
}
