/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "defs.h"
#include "innuendod.p"

PUBLIC char               our_hostname[STR_LEN + 1];
PUBLIC int                listen_s = -1,
                          addrlen = sizeof(struct sockaddr_in);
PUBLIC struct sockaddr_in in_nntp_server,
                          in_gossip_server;
PUBLIC treap_t            *resolv_bt;
PUBLIC pthread_mutex_t    mut_resolv;

/***************************************************************************
*
***************************************************************************/
PUBLIC int sock_puts(kon_t *k, char *str)
{
  int sl;

  sl = strlen(str);
  if(send(k->s, str, sl, 0) == sl)
    return 1;
  return 0;
}

/***************************************************************************
* user resolution management
***************************************************************************/
PRIVATE struct in_addr *resolv_key;

PRIVATE int resolv_cmp_func1(void *n)
{
  return memcmp(resolv_key, &(((resolv_t *)n)->ip_addr), sizeof(struct in_addr));
}

PRIVATE int resolv_cmp_func2(void *a, void *b)
{
  return memcmp(&(((resolv_t *)a)->ip_addr),
                &(((resolv_t *)b)->ip_addr), sizeof(struct in_addr));
}

PUBLIC void resolve(struct in_addr *ia, char *username)
{
  resolv_t e, *p;
  char        str[STR_LEN + 1], str2[STR_LEN + 1];

  pthread_mutex_lock(&mut_resolv);

  resolv_key = ia;
  p = treap_find(&resolv_bt, resolv_cmp_func1);
  if(p == NULL)
  {
    memcpy(&(e.ip_addr), resolv_key, sizeof(struct in_addr));
    if(!test_dynamic_range(ia))
      strcpy(e.username, "*static*");
    else
      resolv_user(resolv_key, e.username);
    e.count = 0;
    treap_append(&resolv_bt, &e, sizeof(resolv_t), resolv_cmp_func2);
    p = treap_find(&resolv_bt, resolv_cmp_func1);
    if(p == NULL)
      log_e(__FUNCTION__ ":treap_find()");

    inet_ntop(AF_INET, &(e.ip_addr), str2, STR_LEN);
    sprintf(str, "I resolve entry added- %s:%s", str2, e.username);
    log_m(str);
  }
  p->count++;
  strcpy(username, p->username);

  pthread_mutex_unlock(&mut_resolv);
}

PUBLIC void remove_resolv_entry(struct in_addr *ia)
{
  resolv_t *p;
  char     str[STR_LEN + 1], str2[STR_LEN + 1];

  pthread_mutex_lock(&mut_resolv);

  resolv_key = ia;
  p = treap_find(&resolv_bt, resolv_cmp_func1);
  if(p != NULL)
  {
    p->count--;
    if(p->count == 0)
    {
      inet_ntop(AF_INET, &(p->ip_addr), str2, STR_LEN);
      sprintf(str, "I resolve entry deleted- %s:%s", str2, p->username);
      log_m(str);

      treap_remove(&resolv_bt, resolv_cmp_func1, resolv_cmp_func2);
    }
  }

  pthread_mutex_unlock(&mut_resolv);
}

PUBLIC void display_resolv_list(kon_t *k)
{
  char     str[STR_LEN + 1], str2[STR_LEN + 1];
  resolv_t *e;

  void wt(treap_t *n)
  {
    if(n == NULL)
      return;

    wt(n->l);

    e = (void *)n + sizeof(treap_t);
    inet_ntop(AF_INET, &(e->ip_addr), str2, STR_LEN);
    sprintf(str, "  %-16s %32s %d\r\n", str2, e->username, e->count);
    sock_puts(k, str);

    wt(n->r);
  }

  sock_puts(k, "100 resolve list\r\n");
  pthread_mutex_lock(&mut_resolv);
  wt(resolv_bt);
  pthread_mutex_unlock(&mut_resolv);
  sock_puts(k, tok_nntp_eop);
}

/***************************************************************************
* creates the main listen socket for tcp connections to this daemon
***************************************************************************/
PUBLIC void sock_open_server(void)
{
  int reuse_opt = 1;
  struct sockaddr_in myaddr_in;
  char str[STR_LEN + 1];

  memset((char *)&myaddr_in, 0, sizeof(struct sockaddr_in));
  myaddr_in.sin_family = AF_INET;
  myaddr_in.sin_addr.s_addr = INADDR_ANY;
  myaddr_in.sin_port = htons(conf.proxy_port);
  if((listen_s = socket(AF_INET, SOCK_STREAM, 0)) != -1)
  {
    setsockopt(listen_s, SOL_SOCKET, SO_REUSEADDR,
      &reuse_opt, sizeof(reuse_opt));
    if(bind(listen_s,(struct sockaddr *)&myaddr_in,
      sizeof(struct sockaddr_in)) != -1)
      if(listen(listen_s, 5) != -1)
        return;
  }
  sprintf(str,"E Couldn't bind Port %d", conf.proxy_port);
  log_m(str);
  exit(-1);
}

/***************************************************************************
* this code isn't reentrant.. besides, it's nore efficient to resolve 
* everything first.
***************************************************************************/
PUBLIC void resolve_addr(struct sockaddr_in *in, char *addr, int port)
{
  struct hostent *he;
  char           str[STR_LEN + 1];

  he = gethostbyname(addr);
  if(he == NULL)
  {
    sprintf(str, "E '%s' doesn't resolve. aborting", addr);
    log_m(str);
    exit(-1);
  }
  memset((char *)in, 0, sizeof(struct sockaddr_in));
  in->sin_family = AF_INET;
  in->sin_addr.s_addr = ((struct in_addr *)(he->h_addr))->s_addr;
  in->sin_port = htons(port);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void sock_accept(int listen_sock, kon_t *k)
{
  char               str[STR_LEN + 1], str2[STR_LEN + 1];
  struct sockaddr_in saddr;

  k->s = accept(listen_sock, (struct sockaddr *)&saddr, &addrlen);
  if(k->s == -1)
  {
    log_e(__FUNCTION__ "::accept()");
    exit(-1);
  }

  k->flag.dir = KON_FLAG_DIR_IN;
  memcpy(&(k->ip_addr), &(saddr.sin_addr), sizeof(struct in_addr));
  resolve(&(k->ip_addr), k->username);
  k->rq_ll = NULL;

  inet_ntop(AF_INET, &(k->ip_addr), str2, STR_LEN);
  sprintf(str, "I accepting socket (addr=%s, sock=%d)", str2, k->s);
  log_m(str);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int sock_open(kon_t *k, struct sockaddr_in *in)
{
  char str[STR_LEN + 1], str2[STR_LEN + 1];

  k->s = socket(AF_INET, SOCK_STREAM, 0);
  if(k->s == -1)
  {
    sprintf(str, "W " __FUNCTION__ ":socket(): %s", strerror(errno));
    log_m(str);
    return 0;
  }

  if(connect(k->s, (struct sockaddr *)in, sizeof(struct sockaddr_in)) == -1)
  {
    sprintf(str, "W " __FUNCTION__ ":connect(): %s", strerror(errno));
    log_m(str);
    return 0;
  }

  k->flag.dir = KON_FLAG_DIR_OUT;
  memcpy(&(k->ip_addr), &(in->sin_addr), sizeof(struct in_addr));
  strcpy(k->username, "N/A");
  k->rq_ll = NULL;

  inet_ntop(AF_INET, &(k->ip_addr), str2, STR_LEN);
  sprintf(str, "I opening socket (addr=%s, sock=%d)", str2, k->s);
  log_m(str);

  return 1;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void sock_close(kon_t *k)
{
  char str[STR_LEN + 1], str2[STR_LEN + 1];

  if(k->s == -1)
    return;

  inet_ntop(AF_INET, &(k->ip_addr), str2, STR_LEN);
  sprintf(str, "I closing socket (addr=%s, sock=%d)", str2, k->s);
  log_m(str);

 /*
  * out connections (sock_open()) are invalid as they are not added
  * to the resolv tree.. so don't try to remove them. .. also, if
  * you do, a nasty deadlock occurrs, when you call sock_accept(),
  * which calls resolve(), which locks mut_resolv, when can call
  * sock_close(), which locks mut_resolv... hence the lockup
  */
  if(k->flag.dir == KON_FLAG_DIR_IN)
    remove_resolv_entry(&(k->ip_addr));

  shutdown(k->s, 2);
  close(k->s);
  ll_free(&(k->rq_ll));
  k->s = -1;
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void queue_recv_msg(kon_t *k, char *cmd)
{
  char str[STR_LEN + 1];

  sprintf(str, "%s: %s - ending connection (sock=%d)", cmd, 
    strerror(errno), k->s);
  log_m(str);
}

PRIVATE int queue_recv_data(kon_t *k)
{
  rq_t b;

  b.ptr = 0;
  b.size = recv(k->s, b.buf, RECV_BUF_FRAG_SIZE, 0);
  switch(b.size)
  {
    case -1:
      queue_recv_msg(k, __FUNCTION__ ":recv()");

    case 0:
      sock_close(k);
      return 0;
  }

  ll_append_unsorted(&(k->rq_ll), &b, sizeof(rq_t));
  return 1;
}

PRIVATE int queue_recv_data_nonblock(kon_t *k)
{
  fd_set         fds;
  struct timeval tv = {0, 0};

  FD_ZERO(&fds);
  FD_SET(k->s, &fds);
  switch(select(k->s + 1, &fds, NULL, NULL, &tv))
  {
    case -1:
      queue_recv_msg(k, __FUNCTION__ ":select()");
      sock_close(k);

    case 0:  /*no data avail*/
      return 0;

    default:
    {
      if(!queue_recv_data(k))
        return 0;
      break;
    }
  }

  return 1;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int sock_gets(kon_t *k, char *ins, int max_str_len, int block_f)
{
  int  f, i;
  char *sp;
  rq_t *b;

  void check_for_nl(ll_t *n)
  {
    if(n == NULL)
      return;
    check_for_nl(n->next);

    b = (void *)n + sizeof(ll_t);
    for(i = b->ptr; i < b->size; i++)
      if(b->buf[i] == '\n')
      {
        f = 1;
        break;
      }
  }

  void pull_line_off_queue(ll_t **n)
  {
    if(*n == NULL)
      return;
    pull_line_off_queue(&((*n)->next));
    if(f)
      return;

    b = (void *)*n + sizeof(ll_t);
    for(; b->ptr < b->size; (b->ptr)++)
    {
      int ls;

      ls = (int)(sp - ins);
      if(ls >= max_str_len)
      {
        char str[STR_LEN + 1];

        sprintf(str,
          "W recv line too long, dropping connection (sock=%d)", k->s);
        log_m(str);
        sock_close(k);
        f = 1;
        return;
      }

      *sp = b->buf[b->ptr];
      sp++;
      if(b->buf[b->ptr] == '\n')
      {
        b->ptr++;
        *sp = 0;
        break;
      }
    }

    if(b->ptr >= b->size)
      ll_remove_entry(n);
  }

/*start*/
  f = 0;
  check_for_nl(k->rq_ll);
  if(!f)
  {
    if(block_f)
    {
      if(!queue_recv_data(k))
        return 0;
    }
    else
    {
      if(!queue_recv_data_nonblock(k))
        return 0;
    }

    f = 0;
    check_for_nl(k->rq_ll);
    if(!f)
      return 0;
  }

  sp = ins;
  f = 0;
  pull_line_off_queue(&(k->rq_ll));
  if(f)
    return 0;

  return 1;
}
