/***************************************************************************
****************************************************************************
****************************************************************************
*
* innuendod - NNTP proxy, POST spy- Arafura Connect
* By Jason Nunn- jsno@arafura.net.au
* Nov 2001
*
* =======================================================================
* treap code... (balanced binary tree algo's)
*
* based on java routines from doctor dobbs journal (circa 96).
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "defs.h"
#include "innuendod.p"

/***************************************************************************
*
***************************************************************************/
PRIVATE treap_t *rot_l(treap_t **n)
{
  treap_t *tmp;

  tmp = (*n)->r;
  (*n)->r = (*n)->r->l;
  tmp->l = *n;
  return tmp;
}

PRIVATE treap_t *rot_r(treap_t **n)
{
  treap_t *tmp;

  tmp = (*n)->l;
  (*n)->l = (*n)->l->r;
  tmp->r = *n;
  return tmp;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void treap_append(
  treap_t **t, void *e, int slen, int (*cmp_func)(void *, void *))
{
  void aw_tr(treap_t **n)
  {
    if(*n != NULL)
    {
      int r;

      r = cmp_func(e, (void *)*n + sizeof(treap_t));
      if(r < 0)                  /*if key_entry < tree_entry*/
      {
        aw_tr(&((*n)->l));
        if((*n)->p > (*n)->l->p)
          *n = rot_r(n);
      }
      else
        if(r > 0)                /*if key_entry > tree_entry*/
        {
          aw_tr(&((*n)->r));
          if((*n)->p > (*n)->r->p)
            *n = rot_l(n);
        }
        else
          log_m("W treap_append(), key not unique. ignored");
    }
    else
    {
      *n = alloc_mem(sizeof(treap_t) + slen);
      (*n)->p = random();
      (*n)->l = NULL;
      (*n)->r = NULL;
      memcpy((void *)*n + sizeof(treap_t), e, slen);
    }
  }

  aw_tr(t);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void treap_append_branch(
  treap_t **t, treap_t *b, int (*cmp_func)(void *, void *))
{
  void aw_tr(treap_t **n)
  {
    if(*n != NULL)
    {
      int r;

      r = cmp_func((void *)b + sizeof(treap_t), (void *)*n + sizeof(treap_t));
      if(r < 0)
      {
        aw_tr(&((*n)->l));
        if((*n)->p > (*n)->l->p)
          *n = rot_r(n);
      }
      else
        if(r > 0)
        {
          aw_tr(&((*n)->r));
          if((*n)->p > (*n)->r->p)
            *n = rot_l(n);
        }
        else
          log_m("W treap_branch_append(), key not unique. ignored");
    }
    else
      *n = b;
  }

  aw_tr(t);
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void *treap_find(treap_t **t, int (*cmp_func)(void *))
{
  treap_t *n;
  int r;
  void *e;

  n = *t;
  for(;;)
  {
    if(n == NULL)
      break;

    e = (void *)n + sizeof(treap_t);
    r = cmp_func(e);
    if(r < 0)
      n = n->l;
    else
      if(r > 0)
        n = n->r;
      else
        return e;
  }
  return NULL;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC int treap_remove(
  treap_t **t, int (*cmp_func1)(void *), int (*cmp_func2)(void *, void *))
{
  treap_t **n, *l, *r;
  int ret;

  n = t;
  for(;;)
  {
    if(*n == NULL)
      break;

    ret = cmp_func1((void *)*n + sizeof(treap_t));
    if(ret < 0)
      n = &((*n)->l);
    else
      if(ret > 0)
        n = &((*n)->r);
      else
      {
        l = (*n)->l;
        r = (*n)->r;
        free(*n);
        *n = NULL;
        if(l != NULL)
          treap_append_branch(t, l, cmp_func2);
        if(r != NULL)
          treap_append_branch(t, r, cmp_func2);

        return 1;
      }
  }

  return 0;
}

/***************************************************************************
*
***************************************************************************/
PUBLIC void treap_free(treap_t **t)
{
  if(*t == NULL)
    return;

  treap_free(&((*t)->l));
  treap_free(&((*t)->r));

  free(*t);
  *t = NULL;
}
