/*
  mkprotos- prototype generation utility

  by jason nunn <jsno@arafura.net.au>, Jan 2002
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define STR_LEN 256
#define INS_LEN 2048

FILE *fp_in;
char ins[INS_LEN + 1],
     *tok_public = "PUBLIC ";

void cleanup_field(char *str)
{
  int s, i;

  s = strlen(str);
  if(s == 0)
    return;

  for(i = s - 1; i >= 0; i--)
    if(isspace(str[i]))
      str[i] = 0;
    else
      break;

  for(i = 0; i < s; i++)
  {
    if(str[i] == '\t')
      continue;

    if(isspace(str[i]))
      str[i] = ' ';
  }
}

void strip_cr(char *str)
{
  int s;

  s = strlen(str);
  if(s > 0)
    if(str[s - 1] == '\n')
      str[s - 1] = 0;
}

void extract_protos(void)
{
  char *s, *s2;
  int toks, tag_f = 0, x;

  toks = strlen(tok_public);
  for(;;)
  {
    if(feof(fp_in))
      break;

    if(!fgets(ins, INS_LEN, fp_in))
      continue;

    if(!tag_f)
    {
      if(strncmp(ins, tok_public, toks))
        continue;
      tag_f = 1;
      printf("extern ");
      s = ins + toks;
    }
    else
      s = ins;

    strip_cr(s);
    cleanup_field(s);
    x = strlen(s);
    if(x <= 0)
      continue;
    s2 = s + x - 1;
    if(*s2 == ';')
      tag_f = 0;
    if(*s2 == ')')
    {
      strcat(s2, ";");
      tag_f = 0;
    }
    s2 = strchr(s, '=');
    if(s2)
      for(; *s2 != 0; s2++)
      {
        if(*s2 == ';' || *s2 == ',')
          break;
        *s2 = ' ';
      }

    printf("%s\n", s);
  }
}

int main(int c, char *v[])
{
  int i;

  for(i = 1; i < c; i++)
  {
    fp_in = fopen(v[i], "r");
    if(fp_in == NULL)
      continue;
    extract_protos();
    fclose(fp_in);
  }

  return 0;
}
