/***************************************************************************
* Stream Redirector
* By Jason Nunn <jsno8192@gmail.com>, Feb 2005
* Birdwood, South Australia
*
* ====================================================================
* main program
***************************************************************************/
#include "defs.h"
#include "protos.p"

PRIVATE char target_addr[STR_LEN + 1];
PRIVATE int  target_port = 0,
             sock;

/***************************************************************************
*
***************************************************************************/
PRIVATE void sock_open_client(void)
{
  struct sockaddr_in in;
  struct hostent     *he;

  he = gethostbyname(target_addr);
  if(he == NULL)
  {
    printf("'%s' doesn't resolve. aborting", target_addr);
    exit(-1);
  }
  memset(&in, 0, sizeof(struct sockaddr_in));
  in.sin_family = AF_INET;
  in.sin_addr.s_addr = ((struct in_addr *)(he->h_addr))->s_addr;
  in.sin_port = htons(target_port);

  sock = socket(AF_INET, SOCK_STREAM, 0);
  if(sock == -1)
    print_error(__func__, "socket()");

  if(connect(sock, (struct sockaddr *)&in, sizeof(struct sockaddr_in)) == -1)
    print_error(__func__, "connect()");
}

/**************************************************************************
*
**************************************************************************/
PRIVATE char *parse_cmdline(int argc, char *argv[], int i)
{
  i++;
  if(i >= argc)
  {
    printf("Error: missing -f parameter\n");
    exit(-1);
  }

  return argv[i];
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void redirect_stream(int s_in, int s_out)
{
  int  r;
  char buf[SOCK_BUF_SIZE];

  for(;;)
  {
    r = read(s_in, buf, SOCK_BUF_SIZE);
    if(r == -1)
      exit(-1);

    if(!r)
      exit(0);

    r = write(s_out, buf, r);
    if(r == -1)
      exit(-1);
  }
}

/***************************************************************************
*
***************************************************************************/
int main(int argc, char *argv[])
{
  int i, p0, p1, s;

  for(i = 0; i < argc; i++)
  {
    if(argv[i][0] == '-')
    {
      switch(argv[i][1])
      {
        case 'h':
          printf(
            WELCOME
            "\nUsage: segtun <options>\n"
             " -h                Display this help info\n"
             " -a <addr>:<port>  address:port of server (making this a client)\n"
             "\n"
          );
          return 0;

        case 'a':
          {
            char *s, *s2;

            s = parse_cmdline(argc, argv, i);
            s2 = strchr(s, ':');
            if(s2 != NULL)
            {
              *s2 = ' ';
              if(sscanf(s, "%s %d", target_addr, &target_port) == 2)
                break;
            }
            printf("Invalid addr:port parameter\n");
            exit(-1);
          }
      }
    }
  }

  sock_open_client();

  i = strlen(argv[0]) - 1;
  p0 = fork();
  if(p0 == -1)
    exit(-1);
  if(!p0)
  {
    if(i) argv[0][i] = '>';
    close(STDOUT_FILENO);
    close(STDERR_FILENO);
    redirect_stream(STDIN_FILENO, sock);
  }

  p1 = fork();
  if(p1 == -1)
    exit(-1);
  if(!p1)
  {
    if(i) argv[0][i] = '<';
    close(STDIN_FILENO);
    close(STDERR_FILENO);
    setsid();
    redirect_stream(sock, STDOUT_FILENO);
  }

  i = wait(&s);
  if(i == p0)
    kill(p1, SIGKILL);
  else
    kill(p0, SIGKILL);
  wait(&s);

  return 0;
}
