/***************************************************************************
* Stream Redirector
* By Jason Nunn <jsno8192@gmail.com>, Feb 2005
* Birdwood, South Australia
*
* =====================================================================
* test server
***************************************************************************/
#include "defs.h"
#include "protos.p"

PRIVATE char our_hostname[STR_LEN + 1];
PRIVATE int  listen_s = -1,
             server_port = 5000,
             addrlen = sizeof(struct sockaddr_in);

/***************************************************************************
* creates the main listen socket for tcp connections to this daemon
***************************************************************************/
PRIVATE void sock_open_server(void)
{
  int                reuse_opt = 1;
  struct sockaddr_in myaddr_in;

  memset((char *)&myaddr_in, 0, sizeof(struct sockaddr_in));
  myaddr_in.sin_family = AF_INET;
  myaddr_in.sin_addr.s_addr = INADDR_ANY;
  myaddr_in.sin_port = htons(server_port);

  listen_s = socket(AF_INET, SOCK_STREAM, 0);
  if(listen_s == -1)
    print_error(__func__, "socket()");

  if(setsockopt(listen_s, SOL_SOCKET, SO_REUSEADDR, &reuse_opt, sizeof(reuse_opt)))
    print_error(__func__, "setsockopt()");

  if(bind(listen_s, (struct sockaddr *)&myaddr_in,
    sizeof(struct sockaddr_in)) == -1)
  {
    print_error(__func__, "bind()");
  }

  if(listen(listen_s, 5) == -1)
    print_error(__func__, "listen()");
}

/**************************************************************************
*
**************************************************************************/
PRIVATE void child_process(void)
{
  int                s;
  struct sockaddr_in saddr;
  FILE               *fp;
  char               str[STR_LEN + 1];

  s = accept(listen_s, (struct sockaddr *)&saddr, &addrlen);
  if(s == -1)
  {
    print_error(__func__, "accept()");
  }

  inet_ntop(AF_INET, &(saddr.sin_addr), str, STR_LEN);
  printf("I accepting socket (addr=%s, sock=%d)\n", str, s);

  fp = fdopen(s, "r+");
  if(fp == NULL)
  {
    print_warning(__func__, "fdopen()");
    exit(0);
  }

  for(;;)
  {
    if(feof(fp))
      break;

    if(fgets(str, STR_LEN, fp) == NULL)
      continue;

    printf("I received: %s", str);

    fwrite(str, strlen(str), 1, fp);
  }

  printf("I ending socket\n");

  exit(0);
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void poll_socket(void)
{
  fd_set             fds;
  struct timeval     tv;
  int                sr;

  for(;;)
  {
    tv.tv_sec = 0;
    tv.tv_usec = 10000;
    FD_ZERO(&fds);
    FD_SET(listen_s, &fds);
    sr = select(listen_s + 1, &fds, NULL, NULL, &tv);
    if(sr == -1)
    {
      print_error(__func__, "select()");
    }
    if(sr == 0)
      return;

    switch(fork())
    {
      case -1:
        print_error(__func__, "fork()");

      case 0:
        child_process();
    }
  }
}

/***************************************************************************
*
***************************************************************************/
PRIVATE void seg_fault(int sig)
{
  printf("I segmentation fault. aborting\n");
  exit(-1);
}

/***************************************************************************
*
***************************************************************************/
int main(int argc, char *argv[])
{
  int x;

  printf(WELCOME);

#if DEBUG == 1
  printf("DEBUG MODE.\n");
#endif

  for(x = 0; x < argc; x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            "\nUsage: jigg <options>\n"
             " -h        Display this help info\n"
             "\n"
          );
          return 0;
      }
    }
  }

  signal(SIGSEGV, seg_fault);

  printf("I starting tester\n");

  if(gethostname(our_hostname, STR_LEN) == -1)
  {
    printf("E couldn't resolve current hostname, Aborting\n");
    exit(-1);
  }

  sock_open_server();
  printf("I daemon started\n");

  for(;;)
  {
    poll_socket();
    sleep(1);
  }

  return 0;
}
